/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.facelets.tag.icefaces.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.MethodExpression;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public class MethodRule
extends MetaRule {
    private final String methodName;
    private final Class returnTypeClass;
    private final Class[] params;

    public MethodRule(String methodName, Class returnTypeClass, Class[] params) {
        this.methodName = methodName;
        this.returnTypeClass = returnTypeClass;
        this.params = params;
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method method;
        if (!name.equals(this.methodName)) {
            return null;
        }
        if (MethodBinding.class.equals((Object)meta.getPropertyType(name))) {
            Method method2 = meta.getWriteMethod(name);
            if (null != method2) {
                return new MethodBindingMetadata(method2, attribute, this.returnTypeClass, this.params);
            }
        } else if (MethodExpression.class.equals((Object)meta.getPropertyType(name)) && null != (method = meta.getWriteMethod(name))) {
            return new MethodExpressionMetadata(method, attribute, this.returnTypeClass, this.params);
        }
        return null;
    }

    private static class MethodExpressionMethodBinding
    extends MethodBinding
    implements Serializable {
        private final MethodExpression expression;

        public MethodExpressionMethodBinding(MethodExpression expression) {
            this.expression = expression;
        }

        public Class getType(FacesContext facesContext) {
            return this.expression.getMethodInfo(facesContext.getELContext()).getReturnType();
        }

        public Object invoke(FacesContext facesContext, Object[] params) {
            return this.expression.invoke(facesContext.getELContext(), params);
        }

        public String getExpressionString() {
            return this.expression.getExpressionString();
        }
    }

    private static class MethodExpressionMetadata
    extends Metadata {
        private final Method method;
        private final TagAttribute attribute;
        private Class[] params;
        private Class returnTypeClass;

        public MethodExpressionMetadata(Method method, TagAttribute attribute, Class returnTypeClass, Class[] params) {
            this.method = method;
            this.attribute = attribute;
            this.returnTypeClass = returnTypeClass;
            this.params = params;
        }

        public void applyMetadata(FaceletContext faceletContext, Object instance) {
            MethodExpression expr = this.attribute.getMethodExpression(faceletContext, this.returnTypeClass, this.params);
            try {
                this.method.invoke(instance, expr);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.attribute, (Throwable)e);
            }
        }
    }

    private static class MethodBindingMetadata
    extends Metadata {
        private final Method method;
        private final TagAttribute attribute;
        private Class[] params;
        private Class returnTypeClass;

        public MethodBindingMetadata(Method method, TagAttribute attribute, Class returnTypeClass, Class[] params) {
            this.method = method;
            this.attribute = attribute;
            this.returnTypeClass = returnTypeClass;
            this.params = params;
        }

        public void applyMetadata(FaceletContext faceletContext, Object instance) {
            MethodExpression expr = this.attribute.getMethodExpression(faceletContext, this.returnTypeClass, this.params);
            try {
                this.method.invoke(instance, new MethodExpressionMethodBinding(expr));
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.attribute, (Throwable)e);
            }
        }
    }
}

