/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.icefaces.impl.application.PersistentPart;

public class AuxUploadResourceHandler
extends ResourceHandlerWrapper {
    private static Logger log = Logger.getLogger(AuxUploadResourceHandler.class.getName());
    public static String AUX_REQ_MAP_KEY = "iceAuxRequestMap";
    public static String CLOUD_PUSH_KEY = "iceCloudPushId";
    private ResourceHandler wrapped;
    private Resource tokenResource = null;

    public AuxUploadResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    private Resource getTokenResource() {
        if (null == this.tokenResource) {
            this.tokenResource = this.createResource("auxupload.txt");
        }
        return this.tokenResource;
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (this.getTokenResource().getRequestPath().equals(AuxUploadResourceHandler.getResourcePath(facesContext))) {
            this.storeParts(externalContext);
            externalContext.setResponseContentType("text/plain");
            OutputStream out = externalContext.getResponseOutputStream();
            out.write("handled by AuxUploadResourceHandler".getBytes());
            return;
        }
        this.wrapped.handleResourceRequest(facesContext);
    }

    public static Map pollAuxRequestMap() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        Map auxRequestMap = (Map)sessionMap.get(AUX_REQ_MAP_KEY);
        return auxRequestMap;
    }

    public static Map getAuxRequestMap() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        Map requestMap = externalContext.getRequestMap();
        Map auxRequestMap = (HashMap)requestMap.get(AUX_REQ_MAP_KEY);
        if (null != auxRequestMap) {
            return auxRequestMap;
        }
        auxRequestMap = (Map)sessionMap.get(AUX_REQ_MAP_KEY);
        if (null != auxRequestMap) {
            sessionMap.put(AUX_REQ_MAP_KEY, new HashMap());
        } else {
            auxRequestMap = new HashMap();
        }
        requestMap.put(AUX_REQ_MAP_KEY, auxRequestMap);
        return auxRequestMap;
    }

    private void storeParts(ExternalContext externalContext) {
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        HttpSession session = request.getSession();
        try {
            HashMap auxRequestMap = (HashMap)session.getAttribute(AUX_REQ_MAP_KEY);
            if (null == auxRequestMap) {
                auxRequestMap = new HashMap();
            }
            Collection parts = new ArrayList();
            try {
                parts = request.getParts();
            }
            catch (Throwable t) {
                Map requestMap = externalContext.getRequestMap();
                for (Object keyObj : requestMap.keySet()) {
                    String key;
                    if (!(keyObj instanceof String) || !(key = (String)keyObj).startsWith("org.icemobile.file.")) continue;
                    auxRequestMap.put(key, requestMap.get(key));
                }
                Map requestParameterMap = externalContext.getRequestParameterMap();
                for (String key : requestParameterMap.keySet()) {
                    auxRequestMap.put(key, requestParameterMap.get(key));
                    if (!CLOUD_PUSH_KEY.equals(key)) continue;
                    session.setAttribute(CLOUD_PUSH_KEY, requestParameterMap.get(key));
                }
            }
            for (Part part : parts) {
                String partType = part.getContentType();
                String partName = part.getName();
                String partParameter = request.getParameter(partName);
                if (null != partParameter) {
                    auxRequestMap.put(partName, partParameter);
                    if (!CLOUD_PUSH_KEY.equals(partName)) continue;
                    session.setAttribute(CLOUD_PUSH_KEY, (Object)partParameter);
                    continue;
                }
                auxRequestMap.put(partName, new PersistentPart(externalContext, part));
            }
            session.setAttribute(AUX_REQ_MAP_KEY, auxRequestMap);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to decode auxUpload Parts", e);
        }
    }

    public String getTokenResourcePath() {
        return this.getTokenResource().getRequestPath();
    }

    private static String getResourcePath(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String path = externalContext.getRequestServletPath();
        if (null == path) {
            path = externalContext.getRequestPathInfo();
        }
        return externalContext.getRequestContextPath() + path;
    }

    public String getCloudPushId() {
        String cloudPushId = (String)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get(CLOUD_PUSH_KEY);
        return cloudPushId;
    }
}

