/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.impl.application.SkipBOMInputStream;
import org.icefaces.impl.util.Util;

public class CoalescingResource
extends Resource {
    private Date lastModified = new Date();
    private String name;
    private String library;
    private Infos resourceInfos;
    private String mimeType;
    private String mapping;
    private boolean extensionMapping;

    public CoalescingResource(String name, String library, String mapping, boolean extensionMapping, Infos resourceInfos) {
        this.name = name;
        this.library = library;
        this.mapping = mapping;
        this.extensionMapping = extensionMapping;
        this.resourceInfos = resourceInfos;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        this.mimeType = externalContext.getMimeType(this.name);
    }

    public String getLibraryName() {
        return this.library;
    }

    public String getResourceName() {
        return this.name;
    }

    public InputStream getInputStream() throws IOException {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        for (Info next : this.resourceInfos.resources) {
            ResourceHandler handler = FacesContext.getCurrentInstance().getApplication().getResourceHandler();
            Resource resource = handler.createResource(next.name, next.library);
            streams.add(new SkipBOMInputStream(resource.getInputStream()));
            streams.add(new ByteArrayInputStream("\n\r".getBytes("UTF-8")));
        }
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public Map<String, String> getResponseHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ETag", this.eTag());
        headers.put("Cache-Control", "public");
        headers.put("Content-Type", this.mimeType);
        headers.put("Date", Util.formatHTTPDate(new Date()));
        headers.put("Last-Modified", Util.formatHTTPDate(this.lastModified));
        return headers;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public String getRequestPath() {
        String path;
        if (this.extensionMapping) {
            path = "/javax.faces.resource/" + this.name + this.mapping;
        } else {
            path = "/javax.faces.resource/" + this.name;
            path = this.mapping == null ? path : this.mapping + path;
        }
        path = path + "?ln=" + this.library;
        path = path + "&dgst=" + this.calculateDigest(this.resourceInfos);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().getViewHandler().getResourceURL(facesContext, path);
    }

    public URL getURL() {
        try {
            return FacesContext.getCurrentInstance().getExternalContext().getResource(this.name);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        Map requestHeaders = context.getExternalContext().getRequestHeaderMap();
        return !requestHeaders.containsKey("If-Modified-Since") || this.resourceInfos.modified;
    }

    private String eTag() {
        return this.calculateDigest(this.resourceInfos);
    }

    private String calculateDigest(Infos resourceInfos) {
        StringBuffer digest = new StringBuffer();
        for (Info info : resourceInfos.resources) {
            digest.append(info.toString());
        }
        return Long.toString(Math.abs(digest.toString().hashCode()), 36);
    }

    protected String calculateInfosDigest() {
        return this.calculateDigest(this.resourceInfos);
    }

    public static class Infos
    implements Externalizable {
        public boolean modified = true;
        public ArrayList<Info> resources = new ArrayList();

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.modified = true;
            this.resources = new ArrayList();
        }

        public String toString() {
            return this.resources.toString();
        }
    }

    public static class Info
    implements Serializable {
        private String name;
        private String library;

        public Info(String name, String library) {
            this.name = name;
            this.library = library;
        }

        public String toString() {
            return this.name + '[' + this.library + ']';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            if (this.library != null ? !this.library.equals(info.library) : info.library != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(info.name) : info.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.library != null ? this.library.hashCode() : 0);
            return result;
        }
    }
}

