/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.icefaces.impl.application.CoalescingPortletResource;
import org.icefaces.impl.application.CoalescingResource;
import org.icefaces.impl.event.ResourceOrdering;
import org.icefaces.util.EnvUtils;

public class CoalescingResourceHandler
extends ResourceHandlerWrapper {
    private static final Logger log = Logger.getLogger(CoalescingResourceHandler.class.getName());
    public static final String COALESCED = "coalesced";
    public static final String CSS_EXTENSION = ".css";
    public static final String COALESCED_CSS = "coalesced.css";
    public static final String JS_EXTENSION = ".js";
    public static final String COALESCED_JS = "coalesced.js";
    public static final String ICE_CORE_LIBRARY = "ice.core";
    private ResourceHandler handler;
    private String mapping;

    public CoalescingResourceHandler(ResourceHandler handler) {
        this.handler = handler;
    }

    public ResourceHandler getWrapped() {
        return this.handler;
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (EnvUtils.isCoallesceResources(context)) {
            ExternalContext ec = context.getExternalContext();
            boolean isPortlet = EnvUtils.instanceofPortletRequest(ec.getRequest());
            if (ICE_CORE_LIBRARY.equals(libraryName) && COALESCED_CSS.equals(resourceName)) {
                CoalescingResource.Infos resourceInfos = CoalescingResourceHandler.getResourceInfos(context, CSS_EXTENSION);
                if (isPortlet) {
                    return new CoalescingPortletResource(COALESCED_CSS, ICE_CORE_LIBRARY, this.getMapping(context), this.isExtensionMapping(context), resourceInfos);
                }
                return new CoalescingResource(COALESCED_CSS, ICE_CORE_LIBRARY, this.getMapping(context), this.isExtensionMapping(context), resourceInfos);
            }
            if (ICE_CORE_LIBRARY.equals(libraryName) && COALESCED_JS.equals(resourceName)) {
                CoalescingResource.Infos resourceInfos = CoalescingResourceHandler.getResourceInfos(context, JS_EXTENSION);
                if (isPortlet) {
                    return new CoalescingPortletResource(COALESCED_JS, ICE_CORE_LIBRARY, this.getMapping(context), this.isExtensionMapping(context), resourceInfos);
                }
                return new CoalescingResource(COALESCED_JS, ICE_CORE_LIBRARY, this.getMapping(context), this.isExtensionMapping(context), resourceInfos);
            }
            return super.createResource(resourceName, libraryName, contentType);
        }
        return super.createResource(resourceName, libraryName, contentType);
    }

    private static CoalescingResource.Infos getResourceInfos(FacesContext fc, String extension) {
        HttpSession sess = EnvUtils.getSafeSession(fc);
        return (CoalescingResource.Infos)sess.getAttribute(CoalescingResourceHandler.class.getName() + extension);
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    private static UIComponent getHeadResourceContainer(UIViewRoot root) {
        String facetName = EnvUtils.isMojarra() ? "javax_faces_location_HEAD" : "head";
        return (UIComponent)root.getFacets().get(facetName);
    }

    private String getMapping(FacesContext context) {
        if (this.mapping == null) {
            ExternalContext extContext = context.getExternalContext();
            String servletPath = extContext.getRequestServletPath();
            String pathInfo = extContext.getRequestPathInfo();
            if (servletPath == null) {
                this.mapping = "/";
            } else if (servletPath.length() == 0) {
                this.mapping = "/*";
            }
            this.mapping = pathInfo != null ? servletPath : (servletPath.indexOf(".") > -1 ? servletPath.substring(servletPath.lastIndexOf(46)) : servletPath);
        }
        return this.mapping;
    }

    private boolean isExtensionMapping(FacesContext context) {
        String m = this.getMapping(context);
        return m != null && !m.startsWith("/");
    }

    public static class RegisterListener
    implements SystemEventListener {
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            FacesContext context = FacesContext.getCurrentInstance();
            if (EnvUtils.isCoallesceResources(context)) {
                context.getApplication().subscribeToEvent(PreRenderComponentEvent.class, (SystemEventListener)new ResourceCollector());
            }
        }

        public boolean isListenerForSource(Object source) {
            return true;
        }
    }

    public static class ResourceCollector
    implements SystemEventListener,
    ResourceOrdering.ResourceIterator {
        private ArrayList<CoalescingResource.Info> orderedResourceInfos = new ArrayList();

        @Override
        public void resource(String name, String library, String target) {
            this.orderedResourceInfos.add(new CoalescingResource.Info(name, library));
        }

        public ResourceCollector() {
            FacesContext context = FacesContext.getCurrentInstance();
            ResourceOrdering resourceOrdering = (ResourceOrdering)context.getExternalContext().getApplicationMap().get(ResourceOrdering.class.getName());
            resourceOrdering.traverseOrderedResources(this);
        }

        public boolean isListenerForSource(Object source) {
            return EnvUtils.isICEfacesView(FacesContext.getCurrentInstance()) && source instanceof UIViewRoot;
        }

        public void processEvent(SystemEvent event) {
            FacesContext context = FacesContext.getCurrentInstance();
            UIViewRoot root = (UIViewRoot)event.getSource();
            this.replaceResources(context, root, CoalescingResourceHandler.CSS_EXTENSION);
            this.replaceResources(context, root, CoalescingResourceHandler.JS_EXTENSION);
        }

        private void replaceResources(FacesContext context, UIViewRoot root, String extension) {
            UIComponent resourceContainer = CoalescingResourceHandler.getHeadResourceContainer(root);
            resourceContainer.setInView(false);
            UIOutput coallescedResourceComponent = new UIOutput();
            Map attrs = coallescedResourceComponent.getAttributes();
            String name = CoalescingResourceHandler.COALESCED + extension;
            attrs.put("name", name);
            attrs.put("library", CoalescingResourceHandler.ICE_CORE_LIBRARY);
            ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
            String rendererType = resourceHandler.getRendererTypeForResourceName(name);
            coallescedResourceComponent.setRendererType(rendererType);
            coallescedResourceComponent.setTransient(true);
            HttpSession sess = EnvUtils.getSafeSession(context);
            CoalescingResource.Infos previousResourceInfos = CoalescingResourceHandler.getResourceInfos(context, extension);
            CoalescingResource.Infos resourceInfos = new CoalescingResource.Infos();
            List children = resourceContainer.getChildren();
            ArrayList<UIComponent> toBeReAdded = new ArrayList<UIComponent>();
            for (UIComponent next : new ArrayList(children)) {
                Map nextAttributes = next.getAttributes();
                String nextName = (String)nextAttributes.get("name");
                if (nextName == null) continue;
                String nextLibrary = (String)nextAttributes.get("library");
                String iceType = (String)nextAttributes.get("ice.type");
                Resource nextResource = null;
                if (iceType == null) {
                    nextResource = resourceHandler.createResource(nextName, nextLibrary);
                }
                if (!nextName.endsWith(extension) || "jsf.js".equals(nextName) || nextResource == null || ResourceCollector.isExternalResource(nextResource)) continue;
                CoalescingResource.Info info = new CoalescingResource.Info(nextName, nextLibrary);
                if (!context.isPostback() || previousResourceInfos == null || previousResourceInfos.resources.contains(info)) {
                    resourceInfos.resources.add(info);
                } else {
                    toBeReAdded.add(next);
                }
                root.removeComponentResource(context, next);
            }
            root.addComponentResource(context, (UIComponent)coallescedResourceComponent);
            for (UIComponent next : toBeReAdded) {
                root.addComponentResource(context, next);
            }
            HttpServletRequest originalRequest = EnvUtils.getOriginalServletRequest(context);
            if (previousResourceInfos == null) {
                sess.setAttribute(CoalescingResourceHandler.class.getName() + extension, (Object)resourceInfos);
            } else {
                ArrayList<CoalescingResource.Info> previousResources = previousResourceInfos.resources;
                ArrayList<CoalescingResource.Info> currentResources = resourceInfos.resources;
                if (previousResources.equals(currentResources)) {
                    previousResourceInfos.modified = !context.isPostback();
                } else {
                    ArrayList sameRequestPreviousResources = (ArrayList)originalRequest.getAttribute(CoalescingResourceHandler.class.getName() + extension);
                    if (sameRequestPreviousResources != null) {
                        ArrayList<CoalescingResource.Info> viewMergedResources = new ArrayList<CoalescingResource.Info>();
                        for (CoalescingResource.Info info : this.orderedResourceInfos) {
                            if (!currentResources.contains(info) && !sameRequestPreviousResources.contains(info)) continue;
                            viewMergedResources.add(info);
                        }
                        HashSet<CoalescingResource.Info> remainingResources = new HashSet<CoalescingResource.Info>();
                        remainingResources.addAll(currentResources);
                        remainingResources.addAll(sameRequestPreviousResources);
                        remainingResources.removeAll(viewMergedResources);
                        viewMergedResources.addAll(remainingResources);
                        resourceInfos.resources = viewMergedResources;
                        resourceInfos.modified = true;
                    }
                    sess.setAttribute(CoalescingResourceHandler.class.getName() + extension, (Object)resourceInfos);
                }
            }
            originalRequest.setAttribute(CoalescingResourceHandler.class.getName() + extension, resourceInfos.resources);
            resourceContainer.setInView(true);
        }

        private static boolean isExternalResource(Resource rez) {
            String path = rez.getRequestPath();
            URI rezURI = URI.create(path);
            if (!rezURI.isAbsolute()) {
                return false;
            }
            String rezHost = rezURI.getHost();
            if (rezHost == null) {
                return false;
            }
            FacesContext fc = FacesContext.getCurrentInstance();
            ExternalContext ec = fc.getExternalContext();
            String requestHost = ec.getRequestServerName();
            if (rezHost.trim().equals(requestHost)) {
                return false;
            }
            log.log(Level.FINE, "external resource detected: resource host [" + rezHost + "] is different from request host [" + requestHost + "]");
            return true;
        }
    }
}

