/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewExpiredException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpSession;
import org.icefaces.application.SessionExpiredException;
import org.icefaces.util.EnvUtils;

public class ExtendedExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger log = Logger.getLogger(ExtendedExceptionHandler.class.getName());
    private ExceptionHandler wrapped;

    public ExtendedExceptionHandler(ExceptionHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public boolean isListenerForSource(Object o) {
        return super.isListenerForSource(o);
    }

    public void handle() throws FacesException {
        boolean sessionExpired = false;
        Iterator iter = this.getUnhandledExceptionQueuedEvents().iterator();
        while (iter.hasNext()) {
            ExceptionQueuedEvent event = (ExceptionQueuedEvent)iter.next();
            ExceptionQueuedEventContext queueContext = (ExceptionQueuedEventContext)event.getSource();
            Throwable ex = queueContext.getException();
            FacesContext fc = FacesContext.getCurrentInstance();
            if (fc.isProjectStage(ProjectStage.Development)) {
                log.log(Level.WARNING, "queued exception", ex);
            }
            if (!(ex instanceof ViewExpiredException) || !PhaseId.RESTORE_VIEW.equals(queueContext.getPhaseId())) continue;
            ViewExpiredException vex = (ViewExpiredException)ex;
            String viewId = vex.getViewId();
            ExternalContext ec = fc.getExternalContext();
            Object sessObj = ec.getSession(false);
            boolean isPortalEnvironment = EnvUtils.instanceofPortletSession(sessObj);
            if (sessObj == null && isPortalEnvironment || this.isValidSession(fc, viewId) && !isPortalEnvironment) continue;
            iter.remove();
            sessionExpired = true;
            break;
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        if (sessionExpired) {
            Application app = fc.getApplication();
            if (app == null) {
                ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                app = factory.getApplication();
            }
            ExceptionQueuedEventContext ctxt = new ExceptionQueuedEventContext(fc, (Throwable)new SessionExpiredException("session expired (causing view to expire)"));
            app.publishEvent(fc, ExceptionQueuedEvent.class, (Object)ctxt);
        }
        if (fc.getViewRoot() == null) {
            UIViewRoot viewRoot = new UIViewRoot();
            viewRoot.setRenderKitId("HTML_BASIC");
            fc.setViewRoot(viewRoot);
        }
        this.getWrapped().handle();
    }

    private boolean isValidSession(FacesContext fc, String viewId) {
        boolean validSession = false;
        HttpSession httpSession = EnvUtils.getSafeSession(fc, false);
        try {
            boolean newSession = httpSession.isNew();
            long lastAccessed = httpSession.getLastAccessedTime();
            int maxInactive = httpSession.getMaxInactiveInterval();
            long now = System.currentTimeMillis();
            if (!newSession && now - lastAccessed <= (long)(maxInactive * 1000)) {
                validSession = true;
            }
            log.log(Level.FINE, "checking for session validity: \n  isNew         : " + newSession + "\n  now           : " + now + "\n  last accessed : " + lastAccessed + "\n  max inactive  : " + maxInactive * 1000 + "\n  time is fine  : " + (now - lastAccessed <= (long)(maxInactive * 1000)) + "\n  valid         : " + validSession);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        return validSession;
    }
}

