/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.icefaces.util.EnvUtils;

public abstract class LazyPushManager {
    private static final Logger LOGGER = Logger.getLogger(LazyPushManager.class.getName());

    public static LazyPushManager get(final HttpSession session) {
        return new LazyPushManager(){

            @Override
            protected State getState() {
                State state = (State)session.getAttribute(LazyPushManager.class.getName());
                if (state == null) {
                    state = new State();
                    session.setAttribute(LazyPushManager.class.getName(), (Object)state);
                }
                return state;
            }
        };
    }

    public static LazyPushManager get(final Map sessionMap) {
        return new LazyPushManager(){

            @Override
            protected State getState() {
                if (sessionMap == null) {
                    throw new IllegalStateException("The session was invalidated/expired.");
                }
                State state = (State)sessionMap.get(LazyPushManager.class.getName());
                if (state == null) {
                    state = new State();
                    sessionMap.put(LazyPushManager.class.getName(), state);
                }
                return state;
            }
        };
    }

    public static LazyPushManager get(FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        return LazyPushManager.get(sessionMap);
    }

    public boolean enablePush(FacesContext context, String viewID) {
        try {
            if (!EnvUtils.isLazyPush(context)) {
                return true;
            }
            State state = this.getState();
            if (state.sessionViewsEnabled) {
                return true;
            }
            Integer no = (Integer)state.individualyRegisteredViews.get(viewID);
            return no != null && no > 0;
        }
        catch (IllegalStateException e) {
            LOGGER.fine("The session was invalidated/expired.");
            return false;
        }
    }

    public void enablePushForView(String viewID) {
        try {
            State state = this.getState();
            Integer no = (Integer)state.individualyRegisteredViews.get(viewID);
            if (no == null) {
                state.individualyRegisteredViews.put(viewID, 1);
            } else {
                no = no + 1;
                state.individualyRegisteredViews.put(viewID, no);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.fine("The session was invalidated/expired.");
        }
    }

    public void disablePushForView(String viewID) {
        try {
            State state = this.getState();
            Integer no = (Integer)state.individualyRegisteredViews.get(viewID);
            if (no != null) {
                if ((no = Integer.valueOf(no - 1)) > 0) {
                    state.individualyRegisteredViews.put(viewID, no);
                } else {
                    state.individualyRegisteredViews.remove(viewID);
                }
            }
        }
        catch (IllegalStateException e) {
            LOGGER.fine("The session was invalidated/expired.");
        }
    }

    public void enablePushForSessionViews() {
        try {
            State state = this.getState();
            state.sessionViewsEnabled = true;
        }
        catch (IllegalStateException e) {
            LOGGER.fine("The session was invalidated/expired.");
        }
    }

    public void disablePushForSessionViews() {
        try {
            State state = this.getState();
            state.sessionViewsEnabled = false;
        }
        catch (IllegalStateException e) {
            LOGGER.fine("The session was invalidated/expired.");
        }
    }

    protected abstract State getState();

    private static class State
    implements Serializable {
        private boolean sessionViewsEnabled = false;
        private HashMap individualyRegisteredViews = new HashMap();

        private State() {
        }
    }
}

