/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.icefaces.bean.ViewRetained;
import org.icefaces.util.EnvUtils;

public class PropagatingNavigationHandler
extends ConfigurableNavigationHandler {
    private static Logger log = Logger.getLogger(PropagatingNavigationHandler.class.getName());
    NavigationHandler wrapped;

    public PropagatingNavigationHandler(NavigationHandler wrapped) {
        this.wrapped = wrapped;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (!EnvUtils.isICEfacesView(context)) {
            this.wrapped.handleNavigation(context, fromAction, outcome);
            return;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        Map viewMap = viewRoot.getViewMap();
        HashMap propagated = new HashMap(viewMap);
        Iterator keys = propagated.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!propagated.get(key).getClass().isAnnotationPresent(ViewRetained.class)) {
                keys.remove();
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Propagating ViewScoped bean " + key);
        }
        Object oldDOM = viewMap.get("org.icefaces.old-dom");
        this.wrapped.handleNavigation(context, fromAction, outcome);
        viewRoot = context.getViewRoot();
        NavigationCase navigationCase = this.getNavigationCase(context, fromAction, outcome);
        if (navigationCase != null && !navigationCase.isRedirect()) {
            viewMap = viewRoot.getViewMap();
            viewMap.putAll(propagated);
            if (null != oldDOM) {
                viewMap.put("org.icefaces.old-dom", oldDOM);
            }
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        if (this.wrapped instanceof ConfigurableNavigationHandler) {
            return ((ConfigurableNavigationHandler)this.wrapped).getNavigationCase(context, fromAction, outcome);
        }
        log.warning(this.wrapped.toString() + " is not a ConfigurableNavigationHandler");
        return null;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this.wrapped instanceof ConfigurableNavigationHandler) {
            return ((ConfigurableNavigationHandler)this.wrapped).getNavigationCases();
        }
        log.warning(this.wrapped.toString() + " is not a ConfigurableNavigationHandler");
        return null;
    }
}

