/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import org.icefaces.util.EnvUtils;

public class RedirectOnExceptionHandler
extends ExceptionHandlerWrapper {
    private ExceptionHandler handler;
    private Map<Class, String> mapping = new HashMap<Class, String>();

    public RedirectOnExceptionHandler(ExceptionHandler handler) {
        this.handler = handler;
        this.mapping = EnvUtils.getRedirectOnExceptionMapping(FacesContext.getCurrentInstance());
    }

    public ExceptionHandler getWrapped() {
        return this.handler;
    }

    public void handle() throws FacesException {
        FacesContext fc = FacesContext.getCurrentInstance();
        for (ExceptionQueuedEvent event : this.getUnhandledExceptionQueuedEvents()) {
            ExceptionQueuedEventContext queueContext = (ExceptionQueuedEventContext)event.getSource();
            Throwable ex = queueContext.getException();
            while (ex.getCause() != null) {
                ex = ex.getCause();
            }
            String redirectURL = this.mapping.get(ex.getClass());
            if (redirectURL == null) continue;
            PartialResponseWriter writer = fc.getPartialViewContext().getPartialResponseWriter();
            String uri = fc.getApplication().getViewHandler().getResourceURL(fc, redirectURL);
            try {
                writer.startDocument();
                writer.redirect(uri);
                writer.endDocument();
                fc.responseComplete();
                return;
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
        this.handler.handle();
    }

    public static class Factory
    extends ExceptionHandlerFactory {
        private ExceptionHandlerFactory parent;

        public Factory(ExceptionHandlerFactory parent) {
            this.parent = parent;
        }

        public ExceptionHandler getExceptionHandler() {
            return new RedirectOnExceptionHandler(this.parent.getExceptionHandler());
        }
    }
}

