/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import org.icefaces.application.SessionExpiredException;
import org.icefaces.util.EnvUtils;

public class RedirectOnSessionExpiryHandler
extends ExceptionHandlerWrapper {
    private ExceptionHandler handler;

    public RedirectOnSessionExpiryHandler(ExceptionHandler handler) {
        this.handler = handler;
    }

    public ExceptionHandler getWrapped() {
        return this.handler;
    }

    public void handle() throws FacesException {
        FacesContext fc = FacesContext.getCurrentInstance();
        String uri = EnvUtils.getSessionExpiredRedirectURI(fc);
        boolean redirect = false;
        for (ExceptionQueuedEvent event : this.getUnhandledExceptionQueuedEvents()) {
            ExceptionQueuedEventContext queueContext = (ExceptionQueuedEventContext)event.getSource();
            Throwable ex = queueContext.getException();
            if (!(ex instanceof SessionExpiredException) || uri == null) continue;
            redirect = true;
        }
        if (redirect) {
            PartialResponseWriter writer = fc.getPartialViewContext().getPartialResponseWriter();
            String resolvedURI = fc.getApplication().getViewHandler().getResourceURL(fc, uri);
            try {
                writer.startDocument();
                writer.redirect(resolvedURI);
                writer.endDocument();
                fc.responseComplete();
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        } else {
            this.handler.handle();
        }
    }

    public static class Factory
    extends ExceptionHandlerFactory {
        private ExceptionHandlerFactory parent;

        public Factory(ExceptionHandlerFactory parent) {
            this.parent = parent;
        }

        public ExceptionHandler getExceptionHandler() {
            return new RedirectOnSessionExpiryHandler(this.parent.getExceptionHandler());
        }
    }
}

