/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.icefaces.application.SessionExpiredException;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.util.EnvUtils;
import org.icepush.PushContext;

public class SessionExpiredListener
implements HttpSessionListener {
    private static Logger LOGGER = Logger.getLogger(SessionExpiredListener.class.getName());

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        WindowScopeManager.sessionCreated(httpSessionEvent.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        ServletContext servletContext;
        PushContext pushContext;
        FacesContext fc = FacesContext.getCurrentInstance();
        if (fc != null) {
            try {
                Application app = fc.getApplication();
                if (app == null) {
                    ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                    app = factory.getApplication();
                }
                ExceptionQueuedEventContext ctxt = new ExceptionQueuedEventContext(fc, (Throwable)new SessionExpiredException("Session has expired"));
                app.publishEvent(fc, ExceptionQueuedEvent.class, (Object)ctxt);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "could not publish SessionExpiredException: " + e.getMessage());
            }
        }
        HttpSession session = httpSessionEvent.getSession();
        try {
            WindowScopeManager.disposeWindows(session);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "An exception occurred while trying to invoke @PreDestroy on window scoped beans: " + exception.getMessage());
        }
        if (EnvUtils.isICEpushPresent() && (pushContext = PushContext.getInstance((ServletContext)(servletContext = session.getServletContext()))) != null) {
            pushContext.push(session.getId());
        }
    }
}

