/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.icefaces.impl.application.SessionAwareResourceHandlerWrapper;
import org.icefaces.util.EnvUtils;

public class SessionTimeoutMonitor
extends SessionAwareResourceHandlerWrapper {
    private static final Logger Log = Logger.getLogger(SessionTimeoutMonitor.class.getName());
    private ResourceHandler handler;

    public SessionTimeoutMonitor(ResourceHandler handler) {
        this.handler = handler;
    }

    public ResourceHandler getWrapped() {
        return this.handler;
    }

    @Override
    public boolean isSessionAwareResourceRequest(FacesContext context) {
        if (!EnvUtils.isStrictSessionTimeout(context)) {
            return this.handler.isResourceRequest(context);
        }
        HttpSession httpSession = EnvUtils.getSafeSession(context);
        Long lastAccessTime = (Long)httpSession.getAttribute(SessionTimeoutMonitor.class.getName());
        boolean isPushRelatedRequest = EnvUtils.isPushRequest(context);
        if (lastAccessTime == null || !isPushRelatedRequest) {
            lastAccessTime = System.currentTimeMillis();
            httpSession.setAttribute(SessionTimeoutMonitor.class.getName(), (Object)System.currentTimeMillis());
        }
        int maxInactiveInterval = httpSession.getMaxInactiveInterval();
        if (System.currentTimeMillis() - lastAccessTime > (long)(maxInactiveInterval * 1000)) {
            Log.fine("invalidating session enforcing strictSessionTimeout");
            httpSession.removeAttribute(SessionTimeoutMonitor.class.getName());
            context.getExternalContext().invalidateSession();
        }
        return this.handler.isResourceRequest(context);
    }

    @Override
    public void handleSessionAwareResourceRequest(FacesContext context) throws IOException {
        this.handler.handleResourceRequest(context);
    }
}

