/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;
import org.icefaces.impl.application.VersionedResource;
import org.icefaces.util.EnvUtils;

public class VersioningResourceHandler
extends ResourceHandlerWrapper {
    private static Logger log = Logger.getLogger(VersioningResourceHandler.class.getName());
    private ResourceHandler wrapped;
    private List matchTypes;
    private List startsWithTypes;
    private List endsWithTypes;

    public VersioningResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource rez = this.wrapped.createResource(resourceName, libraryName, contentType);
        if (!EnvUtils.isUniqueResourceURLs(FacesContext.getCurrentInstance())) {
            return rez;
        }
        if (this.matchTypes == null) {
            this.createTypeLists();
        }
        if (!this.isVersionableResource(rez)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("ignoring versioning for \n  resource    : " + rez.getResourceName() + "\n  library     : " + rez.getLibraryName() + "\n  content type: " + rez.getContentType());
            }
            return rez;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("adding versioning for \n  resource    : " + resourceName + "\n  library     : " + libraryName + "\n  content type: " + contentType);
        }
        return new VersionedResource(rez);
    }

    private void createTypeLists() {
        this.matchTypes = new ArrayList();
        this.endsWithTypes = new ArrayList();
        this.startsWithTypes = new ArrayList();
        String versionableTypes = EnvUtils.getVersionableTypes(FacesContext.getCurrentInstance());
        if (versionableTypes == null) {
            return;
        }
        String[] types = versionableTypes.split("\\s");
        for (int index = 0; index < types.length; ++index) {
            String type = types[index];
            if (type.startsWith("*/")) {
                this.endsWithTypes.add(type.substring(2));
                continue;
            }
            if (type.endsWith("/*")) {
                this.startsWithTypes.add(type.substring(0, type.length() - 2));
                continue;
            }
            this.matchTypes.add(type);
        }
    }

    private boolean isVersionableResource(Resource rez) {
        if (rez == null) {
            return false;
        }
        String calculatedContentType = rez.getContentType();
        if (calculatedContentType == null) {
            return false;
        }
        if (this.matchTypes.contains(calculatedContentType)) {
            return true;
        }
        int slashIndex = calculatedContentType.indexOf("/");
        if (slashIndex < 0) {
            return false;
        }
        String prefix = calculatedContentType.substring(0, slashIndex);
        if (this.startsWithTypes.contains(prefix)) {
            return true;
        }
        String suffix = calculatedContentType.substring(slashIndex + 1);
        return this.endsWithTypes.contains(suffix);
    }
}

