/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.faces.application.Application;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostConstructCustomScopeEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.ScopeContext;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.lifecycle.ClientWindow;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.icefaces.bean.AllWindowsClosed;
import org.icefaces.bean.WindowDisposed;
import org.icefaces.impl.application.SessionAwareResourceHandlerWrapper;
import org.icefaces.impl.push.SessionViewManager;
import org.icefaces.util.EnvUtils;

public class WindowScopeManager
extends SessionAwareResourceHandlerWrapper {
    public static final String SessionSynchronizationMonitor = WindowScopeManager.class.getName() + "$SessionSynchronizationMonitor";
    public static final String ScopeName = "window";
    private static final Logger log = Logger.getLogger(WindowScopeManager.class.getName());
    private static final String seed = Integer.toString(new Random().nextInt(1000), 36);
    private static SharedMapLookupStrategy sharedMapLookupStrategy;
    private ResourceHandler wrapped;

    public WindowScopeManager(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    @Override
    public void handleSessionAwareResourceRequest(FacesContext facesContext) throws IOException {
        this.wrapped.handleResourceRequest(facesContext);
    }

    @Override
    public boolean isSessionAwareResourceRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map parameters = externalContext.getRequestParameterMap();
        if (WindowScopeManager.isDisposeWindowRequest(parameters)) {
            return false;
        }
        return this.wrapped.isResourceRequest(facesContext);
    }

    public static ScopeMap lookupWindowScope(FacesContext context) {
        String id = WindowScopeManager.lookupAssociatedWindowID(context.getExternalContext().getRequestMap());
        State state = WindowScopeManager.getState(context);
        if (state == null) {
            return null;
        }
        ScopeMap map = (ScopeMap)state.windowScopedMaps.get(id);
        if (map == null) {
            for (ScopeMap next : state.disposedWindowScopedMaps) {
                if (!next.id.equals(id)) continue;
                return next;
            }
            return null;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String determineWindowID(FacesContext context, boolean customWindowTracking) {
        HttpSession safeSession = EnvUtils.getSafeSession(context);
        if (safeSession == null) {
            return null;
        }
        Object synchronizationMonitor = safeSession.getAttribute(SessionSynchronizationMonitor);
        if (synchronizationMonitor == null) {
            log.log(Level.FINE, "synchronization monitor not set by session listener");
            synchronizationMonitor = new SynchronizationMonitorObject();
            safeSession.setAttribute(SessionSynchronizationMonitor, synchronizationMonitor);
        }
        Object object = synchronizationMonitor;
        synchronized (object) {
            ScopeMap map;
            Object scopeMap2;
            State state = WindowScopeManager.getState(context);
            ExternalContext externalContext = context.getExternalContext();
            String id = customWindowTracking ? (String)externalContext.getRequestParameterMap().get("ice.window") : externalContext.getClientWindow().getId();
            try {
                for (Object scopeMap2 : new ArrayList(state.windowScopedMaps.values())) {
                    map = (ScopeMap)scopeMap2;
                    if (map.getId().equals(id)) continue;
                    map.disactivateIfUnused(context);
                }
            }
            catch (Throwable e) {
                log.log(Level.FINE, "Failed to remove window scope map", e);
            }
            try {
                for (Object scopeMap2 : new ArrayList(state.disposedWindowScopedMaps)) {
                    map = (ScopeMap)scopeMap2;
                    if (map.getId().equals(id)) continue;
                    map.discardIfExpired(context);
                }
            }
            catch (Throwable e) {
                log.log(Level.FINE, "Failed to remove window scope map", e);
            }
            Map requestMap = externalContext.getRequestMap();
            if (id == null) {
                scopeMap2 = sharedMapLookupStrategy.lookup(context);
                if (scopeMap2 == null) {
                    scopeMap2 = state.disposedWindowScopedMaps.isEmpty() ? new ScopeMap(context) : (ScopeMap)state.disposedWindowScopedMaps.removeFirst();
                    ((ScopeMap)scopeMap2).activate(state);
                }
                WindowScopeManager.associateWindowID(((ScopeMap)scopeMap2).id, requestMap);
                return ((ScopeMap)scopeMap2).id;
            }
            if (state.windowScopedMaps.containsKey(id)) {
                WindowScopeManager.associateWindowID(id, requestMap);
                return id;
            }
            for (Object disposedScopeMap : new ArrayList(state.disposedWindowScopedMaps)) {
                ScopeMap scopeMap3 = (ScopeMap)disposedScopeMap;
                if (!scopeMap3.getId().equals(id)) continue;
                scopeMap3.activate(state);
                WindowScopeManager.associateWindowID(id, requestMap);
                return id;
            }
            scopeMap2 = new ScopeMap(id, context);
            ((ScopeMap)scopeMap2).activate(state);
            WindowScopeManager.associateWindowID(((ScopeMap)scopeMap2).id, requestMap);
            return ((ScopeMap)scopeMap2).id;
        }
    }

    private static boolean isDisposeWindowRequest(Map parameters) {
        return "ice.dispose.window".equals(parameters.get("ice.submit.type"));
    }

    public static synchronized String generateID() {
        return seed + Long.toString(System.currentTimeMillis(), 36);
    }

    public static void disposeWindows(HttpSession session) {
        State state = (State)session.getAttribute(WindowScopeManager.class.getName());
        if (state == null) {
            return;
        }
        WindowScopeManager.notifyPreDestroyForAll(state.windowScopedMaps.values());
        WindowScopeManager.notifyPreDestroyForAll(state.disposedWindowScopedMaps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyPreDestroyForAll(Collection<ScopeMap> scopeMaps) {
        for (ScopeMap scopeMap : scopeMaps) {
            if (scopeMap.isPreDestroyInvoked()) continue;
            try {
                WindowScopeManager.notifyPreDestroy(scopeMap.values());
            }
            finally {
                scopeMap.preDestroyInvoked();
            }
        }
    }

    private static void notifyPreDestroy(Collection beans) {
        try {
            for (Object bean : beans) {
                try {
                    WindowScopeManager.callAnnotatedMethod(bean, PreDestroy.class);
                }
                catch (Exception exception) {
                    log.log(Level.FINE, "An exception occurred while trying to invoke @PreDestroy on a window scoped bean: " + exception.getMessage());
                }
            }
        }
        catch (Exception exception) {
            log.log(Level.FINE, "An exception occurred while trying to invoke @PreDestroy on window scoped beans: " + exception.getMessage());
        }
    }

    public static synchronized void disposeWindow(FacesContext context, String id, Timer timer) {
        State state = WindowScopeManager.getState(context);
        ScopeMap scopeMap = (ScopeMap)state.windowScopedMaps.get(id);
        if (scopeMap != null) {
            scopeMap.disactivate(state);
            scopeMap.discardIfExpired(context);
        }
        if (state.windowScopedMaps.isEmpty()) {
            long windowScopeExpiration = EnvUtils.getWindowScopeExpiration(context);
            HashMap session = new HashMap(context.getExternalContext().getSessionMap());
            timer.schedule((TimerTask)new AllWindowsClosedNotifier(state, session), windowScopeExpiration * 2L);
        }
        WindowScopeManager.disposeViewScopeBeans(context);
    }

    private static void disposeViewScopeBeans(FacesContext facesContext) {
        ExceptionHandler oldHandler = facesContext.getExceptionHandler();
        facesContext.setExceptionHandler((ExceptionHandler)new DiscardingExceptionHandler(oldHandler));
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (null == viewRoot) {
            return;
        }
        Map viewMap = viewRoot.getViewMap();
        Iterator keys = viewMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object object = viewMap.get(key);
            if (!object.getClass().isAnnotationPresent(WindowDisposed.class)) continue;
            keys.remove();
            WindowScopeManager.callAnnotatedMethod(object, PreDestroy.class);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Closing window disposed ViewScoped bean " + key);
        }
        facesContext.setExceptionHandler(oldHandler);
    }

    private static void callAnnotatedMethod(Object object, Class annotation) {
        Class<?> theClass;
        try {
            for (theClass = object.getClass(); null != theClass; theClass = theClass.getSuperclass()) {
                Method[] methods;
                for (Method method : methods = object.getClass().getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    method.setAccessible(true);
                    method.invoke(object, new Object[0]);
                    return;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to invoke" + annotation + " on " + theClass, e);
        }
    }

    public static void sessionCreated(HttpSession session) {
        session.setAttribute(SessionSynchronizationMonitor, (Object)new SynchronizationMonitorObject());
    }

    public static String lookupAssociatedWindowID(Map requestMap) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        try {
            ClientWindow clientWindow = externalContext.getClientWindow();
            if (clientWindow == null) {
                try {
                    boolean customWindowTracking = !"url".equals(externalContext.getInitParameter("javax.faces.CLIENT_WINDOW_MODE"));
                    String id = WindowScopeManager.determineWindowID(facesContext, customWindowTracking);
                    if (customWindowTracking) {
                        clientWindow = new CustomClientWindow(id);
                        clientWindow.disableClientWindowRenderMode(facesContext);
                        externalContext.setClientWindow(clientWindow);
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Unable to set up WindowScope ", e);
                }
            }
            return clientWindow == null ? null : clientWindow.getId();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public static void associateWindowIDToRequest(String id, FacesContext facesContext) {
        WindowScopeManager.associateWindowID(id, facesContext.getExternalContext().getRequestMap());
    }

    private static void associateWindowID(String id, Map requestMap) {
        requestMap.put(WindowScopeManager.class.getName(), id);
    }

    private static State getState(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Object session = externalContext.getSession(false);
        if (session != null) {
            return EnvUtils.instanceofPortletSession(session) ? WindowScopeManager.getPortletState(context, session) : WindowScopeManager.getServletState(context, session);
        }
        return null;
    }

    private static State getServletState(FacesContext context, Object session) {
        HttpSession servletSession = (HttpSession)session;
        State state = (State)servletSession.getAttribute(WindowScopeManager.class.getName());
        if (state == null) {
            state = new State(EnvUtils.getWindowScopeExpiration(context));
            servletSession.setAttribute(WindowScopeManager.class.getName(), (Object)state);
        }
        return state;
    }

    private static State getPortletState(FacesContext context, Object session) {
        PortletSession portletSession = (PortletSession)session;
        State state = (State)portletSession.getAttribute(WindowScopeManager.class.getName(), 1);
        if (state == null) {
            state = new State(EnvUtils.getWindowScopeExpiration(context));
            portletSession.setAttribute(WindowScopeManager.class.getName(), (Object)state, 1);
        }
        return state;
    }

    static {
        try {
            sharedMapLookupStrategy = new LiferayOriginalRequestWindowScopeSharing();
        }
        catch (Exception e) {
            sharedMapLookupStrategy = new TimeBasedHeuristicWindowScopeSharing();
        }
    }

    private static class CustomClientWindow
    extends ClientWindow {
        private final String id;

        public CustomClientWindow(String id) {
            this.id = id;
        }

        public Map<String, String> getQueryURLParameters(FacesContext context) {
            return Collections.EMPTY_MAP;
        }

        public String getId() {
            return this.id;
        }

        public void decode(FacesContext context) {
        }
    }

    private static class SynchronizationMonitorObject
    implements Serializable {
        private SynchronizationMonitorObject() {
        }
    }

    private static class AllWindowsClosedNotifier
    extends TimerTask {
        private final State state;
        private final Map session;

        public AllWindowsClosedNotifier(State state, Map session) {
            this.state = state;
            this.session = session;
        }

        @Override
        public void run() {
            if (this.state.windowScopedMaps.isEmpty()) {
                ArrayList<ScopeMap> expiredMaps = new ArrayList<ScopeMap>();
                for (ScopeMap scopeMap : this.state.disposedWindowScopedMaps) {
                    if (System.currentTimeMillis() <= scopeMap.deactivateTimestamp + this.state.expirationPeriod) continue;
                    expiredMaps.add(scopeMap);
                }
                WindowScopeManager.notifyPreDestroyForAll(expiredMaps);
                for (Object object : this.session.values()) {
                    WindowScopeManager.callAnnotatedMethod(object, AllWindowsClosed.class);
                }
            }
        }
    }

    public static class SaveScopeState
    implements PhaseListener {
        public void afterPhase(PhaseEvent event) {
            FacesContext context = FacesContext.getCurrentInstance();
            try {
                ExternalContext externalContext = context.getExternalContext();
                Object session = externalContext.getSession(false);
                if (session != null) {
                    if (EnvUtils.instanceofPortletSession(session)) {
                        PortletSession portletSession = (PortletSession)session;
                        Object state = portletSession.getAttribute(WindowScopeManager.class.getName(), 1);
                        if (state != null) {
                            portletSession.setAttribute(WindowScopeManager.class.getName(), state, 1);
                        }
                    } else {
                        HttpSession servletSession = (HttpSession)session;
                        Object state = servletSession.getAttribute(WindowScopeManager.class.getName());
                        if (state != null) {
                            servletSession.setAttribute(WindowScopeManager.class.getName(), state);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, "Unable to reset WindowScope", e);
            }
        }

        public void beforePhase(PhaseEvent event) {
        }

        public PhaseId getPhaseId() {
            return PhaseId.RENDER_RESPONSE;
        }
    }

    public static class DetermineOrDisposeScope
    implements PhaseListener {
        private Timer timer = new Timer("WindowScopeManager timer", true);

        public DetermineOrDisposeScope() {
            FacesContext context = FacesContext.getCurrentInstance();
            Application application = context.getApplication();
            application.subscribeToEvent(PreDestroyApplicationEvent.class, new SystemEventListener(){

                public boolean isListenerForSource(Object source) {
                    return true;
                }

                public void processEvent(SystemEvent event) {
                    DetermineOrDisposeScope.this.timer.cancel();
                }
            });
        }

        public void afterPhase(PhaseEvent event) {
            FacesContext facesContext = event.getFacesContext();
            ExternalContext externalContext = facesContext.getExternalContext();
            Map parameters = externalContext.getRequestParameterMap();
            if (event.getPhaseId() == PhaseId.RENDER_RESPONSE && WindowScopeManager.isDisposeWindowRequest(parameters)) {
                facesContext.responseComplete();
                String windowID = (String)parameters.get("ice.window");
                WindowScopeManager.disposeWindow(facesContext, windowID, this.timer);
                if (EnvUtils.isICEpushPresent()) {
                    try {
                        String[] viewIDs = (String[])externalContext.getRequestParameterValuesMap().get("ice.view");
                        for (int i = 0; i < viewIDs.length; ++i) {
                            SessionViewManager.get(facesContext).removeView(viewIDs[i]);
                        }
                    }
                    catch (RuntimeException e) {
                        log.log(Level.FINE, "Exception during dispose-window ", e);
                    }
                }
            }
        }

        public void beforePhase(PhaseEvent event) {
            if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
                FacesContext context = FacesContext.getCurrentInstance();
                boolean customWindowTracking = !"url".equals(context.getExternalContext().getInitParameter("javax.faces.CLIENT_WINDOW_MODE"));
                WindowScopeManager.determineWindowID(context, customWindowTracking);
            }
        }

        public PhaseId getPhaseId() {
            return PhaseId.ANY_PHASE;
        }
    }

    static class DiscardingExceptionHandler
    extends ExceptionHandlerWrapper {
        ExceptionHandler wrapped;

        public DiscardingExceptionHandler(ExceptionHandler wrapped) {
            this.wrapped = wrapped;
        }

        public void processEvent(SystemEvent exceptionQueuedEvent) {
            Throwable throwable = ((ExceptionQueuedEvent)exceptionQueuedEvent).getContext().getException();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception during window disposal " + throwable);
            }
        }

        public ExceptionHandler getWrapped() {
            return this.wrapped;
        }
    }

    private static class LiferayOriginalRequestWindowScopeSharing
    implements SharedMapLookupStrategy {
        private Class PortalUtilClass = Class.forName("com.liferay.portal.util.PortalUtil");
        private Method GetHttpServletRequest = this.PortalUtilClass.getDeclaredMethod("getHttpServletRequest", PortletRequest.class);
        private Method GetOriginalServletRequest = this.PortalUtilClass.getDeclaredMethod("getOriginalServletRequest", HttpServletRequest.class);

        private LiferayOriginalRequestWindowScopeSharing() throws ClassNotFoundException, NoSuchMethodException {
        }

        @Override
        public ScopeMap lookup(FacesContext context) {
            State state = WindowScopeManager.getState(context);
            ExternalContext externalContext = context.getExternalContext();
            HttpServletRequest originalRequest = this.getOriginalServletRequest(externalContext);
            String sharedWindowID = (String)originalRequest.getAttribute(WindowScopeManager.class.getName());
            return sharedWindowID == null ? null : (ScopeMap)state.windowScopedMaps.get(sharedWindowID);
        }

        @Override
        public void associate(FacesContext context, String windowID) {
            ExternalContext externalContext = context.getExternalContext();
            HttpServletRequest originalRequest = this.getOriginalServletRequest(externalContext);
            originalRequest.setAttribute(WindowScopeManager.class.getName(), (Object)windowID);
        }

        private HttpServletRequest getOriginalServletRequest(ExternalContext externalContext) {
            try {
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                HttpServletRequest httpPortletRequest = (HttpServletRequest)this.GetHttpServletRequest.invoke((Object)this.PortalUtilClass, portletRequest);
                HttpServletRequest originalRequest = (HttpServletRequest)this.GetOriginalServletRequest.invoke((Object)this.PortalUtilClass, httpPortletRequest);
                return originalRequest;
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
    }

    private static class TimeBasedHeuristicWindowScopeSharing
    implements SharedMapLookupStrategy {
        private long sameWindowMaxDelay = -1L;

        private TimeBasedHeuristicWindowScopeSharing() {
        }

        @Override
        public ScopeMap lookup(FacesContext context) {
            if (this.sameWindowMaxDelay == -1L) {
                this.sameWindowMaxDelay = EnvUtils.getWindowScopeExpiration(context);
            }
            State state = WindowScopeManager.getState(context);
            for (ScopeMap sm : state.windowScopedMaps.values()) {
                if (sm.activateTimestamp + this.sameWindowMaxDelay <= System.currentTimeMillis()) continue;
                return sm;
            }
            return null;
        }

        @Override
        public void associate(FacesContext context, String windowID) {
        }
    }

    private static interface SharedMapLookupStrategy {
        public ScopeMap lookup(FacesContext var1);

        public void associate(FacesContext var1, String var2);
    }

    public static class State
    implements Externalizable {
        public HashMap windowScopedMaps = new HashMap();
        private LinkedList disposedWindowScopedMaps = new LinkedList();
        public long expirationPeriod;

        public State() {
        }

        private State(long expirationPeriod) {
            this.expirationPeriod = expirationPeriod;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.windowScopedMaps);
            out.writeObject(this.disposedWindowScopedMaps);
            out.writeLong(this.expirationPeriod);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.windowScopedMaps = (HashMap)in.readObject();
            this.disposedWindowScopedMaps = (LinkedList)in.readObject();
            this.expirationPeriod = in.readLong();
        }
    }

    public static class ScopeMap
    extends HashMap {
        private String id;
        private long activateTimestamp = System.currentTimeMillis();
        private long deactivateTimestamp = -1L;
        private boolean preDestroyInvoked;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScopeMap(String id, FacesContext facesContext) {
            this.id = id;
            boolean processingEvents = facesContext.isProcessingEvents();
            try {
                facesContext.setProcessingEvents(true);
                ScopeContext context = new ScopeContext(WindowScopeManager.ScopeName, (Map)this);
                facesContext.getApplication().publishEvent(facesContext, PostConstructCustomScopeEvent.class, (Object)context);
            }
            finally {
                facesContext.setProcessingEvents(processingEvents);
                sharedMapLookupStrategy.associate(facesContext, id);
            }
        }

        public String getId() {
            return this.id;
        }

        public ScopeMap(FacesContext facesContext) {
            this(WindowScopeManager.generateID(), facesContext);
        }

        private void disactivateIfUnused(FacesContext facesContext) {
            if (!EnvUtils.containsBeans(this)) {
                this.disactivate(WindowScopeManager.getState(facesContext));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void discardIfExpired(FacesContext facesContext) {
            block7: {
                State state = WindowScopeManager.getState(facesContext);
                if (System.currentTimeMillis() > this.deactivateTimestamp + state.expirationPeriod) {
                    try {
                        if (this.isPreDestroyInvoked()) break block7;
                        boolean processingEvents = facesContext.isProcessingEvents();
                        try {
                            facesContext.setProcessingEvents(true);
                            ScopeContext context = new ScopeContext(WindowScopeManager.ScopeName, (Map)this);
                            facesContext.getApplication().publishEvent(facesContext, PreDestroyCustomScopeEvent.class, (Object)context);
                        }
                        finally {
                            this.preDestroyInvoked();
                            facesContext.setProcessingEvents(processingEvents);
                        }
                    }
                    finally {
                        state.disposedWindowScopedMaps.remove(this);
                    }
                }
            }
        }

        private void activate(State state) {
            state.windowScopedMaps.put(this.id, this);
            this.activateTimestamp = System.currentTimeMillis();
        }

        private void disactivate(State state) {
            this.deactivateTimestamp = System.currentTimeMillis();
            state.disposedWindowScopedMaps.addLast(state.windowScopedMaps.remove(this.id));
        }

        public void preDestroyInvoked() {
            this.preDestroyInvoked = true;
        }

        public boolean isPreDestroyInvoked() {
            return this.preDestroyInvoked;
        }
    }
}

