/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

public class LoadBundle
extends UIComponentBase {
    private String oldVar;
    private transient Locale oldLocale;
    private transient String oldBasename = "";
    private transient ResourceBundle bundle;
    private Map map = new SerializableMap();

    public String getFamily() {
        return "javax.faces.Output";
    }

    public String getVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)"var"));
    }

    public void setVar(String var) {
        this.getStateHelper().put((Serializable)((Object)"var"), (Object)var);
    }

    public String getBasename() {
        return (String)this.getStateHelper().eval((Serializable)((Object)"basename"));
    }

    public void setBasename(String basename) {
        this.getStateHelper().put((Serializable)((Object)"basename"), (Object)basename);
    }

    public void decode(FacesContext context) {
        this.updateBundle(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.updateBundle(context);
    }

    private void updateBundle(FacesContext context) {
        boolean reloadRequired;
        String var = this.getVar();
        String basename = this.getBasename();
        Locale locale = context.getViewRoot().getLocale();
        boolean bl = reloadRequired = this.oldLocale == null || !this.oldLocale.getLanguage().equals(locale.getLanguage()) || !basename.equals(this.oldBasename) || !var.equals(this.oldVar);
        if (reloadRequired) {
            this.bundle = ResourceBundle.getBundle(basename.trim(), locale, LoadBundle.getClassLoader((Object)this));
            this.map = new SerializableMap();
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.remove(this.oldVar);
            requestMap.put(var, this.map);
            this.oldBasename = basename;
            this.oldLocale = locale;
            this.oldVar = var;
        }
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.updateBundle(FacesContext.getCurrentInstance());
        }
        return this.bundle;
    }

    private static ClassLoader getClassLoader(Object fallback) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = fallback.getClass().getClassLoader();
        }
        return classLoader;
    }

    private class SerializableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SerializableMap() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return null == key ? false : null != LoadBundle.this.getBundle().getObject(key.toString());
        }

        @Override
        public boolean containsValue(Object value) {
            boolean found = false;
            ResourceBundle resourceBundle = LoadBundle.this.getBundle();
            Enumeration<String> keys = resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                Object currentValue = resourceBundle.getObject(keys.nextElement());
                if (value != currentValue && (null == currentValue || !currentValue.equals(value))) continue;
                found = true;
                break;
            }
            return found;
        }

        public Set entrySet() {
            HashMap<String, Object> entries = new HashMap<String, Object>();
            ResourceBundle resourceBundle = LoadBundle.this.getBundle();
            Enumeration<String> keys = resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object value = resourceBundle.getObject(key);
                entries.put(key, value);
            }
            return entries.entrySet();
        }

        public Object get(Object key) {
            Object result;
            if (null == key) {
                return null;
            }
            try {
                result = LoadBundle.this.getBundle().getObject(key.toString());
            }
            catch (MissingResourceException mre) {
                result = "???" + key + "???";
            }
            return result;
        }

        @Override
        public boolean isEmpty() {
            return !LoadBundle.this.getBundle().getKeys().hasMoreElements();
        }

        public Set keySet() {
            return LoadBundle.this.getBundle().keySet();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            int size = 0;
            Enumeration<String> keys = LoadBundle.this.getBundle().getKeys();
            while (keys.hasMoreElements()) {
                keys.nextElement();
                ++size;
            }
            return size;
        }

        public Collection values() {
            ArrayList<Object> values = new ArrayList<Object>();
            ResourceBundle resourceBundle = LoadBundle.this.getBundle();
            Enumeration<String> keys = resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                values.add(resourceBundle.getObject(keys.nextElement()));
            }
            return values;
        }

        @Override
        public int hashCode() {
            return LoadBundle.this.getBundle().hashCode();
        }
    }
}

