/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.component;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;

public class NavigationNotifierHandler
extends ResourceHandlerWrapper {
    private static final String RSH_JS = "navigation-notifier/rsh.js";
    private static final String RSH_BLANK_HTML = "navigation-notifier/blank.html";
    private static final String BLANK_HTML = "blank.html";
    private static final String UTF_8 = "UTF-8";
    private ResourceHandler handler;
    private Resource cachedRSHdotJS;

    public NavigationNotifierHandler(ResourceHandler handler) {
        this.handler = handler;
    }

    public ResourceHandler getWrapped() {
        return this.handler;
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource resource = super.createResource(resourceName, libraryName);
        if (RSH_JS.equals(resourceName)) {
            if (this.cachedRSHdotJS == null) {
                try {
                    Resource blank = super.createResource(RSH_BLANK_HTML, libraryName);
                    String path = blank.getRequestPath();
                    byte[] content = NavigationNotifierHandler.readIntoByteArray(resource.getInputStream());
                    String replacedContent = new String(content, UTF_8).replaceAll(BLANK_HTML, path);
                    this.cachedRSHdotJS = new CachedResource(resource, replacedContent.getBytes(UTF_8));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cachedRSHdotJS;
        }
        return resource;
    }

    private static byte[] readIntoByteArray(InputStream in) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
        return out.toByteArray();
    }

    private class CachedResource
    extends Resource {
        private Resource resource;
        private byte[] content;

        private CachedResource(Resource resource, byte[] content) {
            this.resource = resource;
            this.content = content;
            this.setContentType(resource.getContentType());
            this.setLibraryName(resource.getLibraryName());
            this.setResourceName(resource.getResourceName());
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content);
        }

        public Map<String, String> getResponseHeaders() {
            return this.resource.getResponseHeaders();
        }

        public String getRequestPath() {
            return this.resource.getRequestPath();
        }

        public URL getURL() {
            return this.resource.getURL();
        }

        public boolean userAgentNeedsUpdate(FacesContext context) {
            return this.resource.userAgentNeedsUpdate(context);
        }
    }
}

