/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icefaces.impl.application.AuxUploadSetup;
import org.icefaces.impl.application.LazyPushManager;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.impl.event.ResourceOutputUtil;
import org.icefaces.impl.event.UIOutputWriter;
import org.icefaces.impl.push.SessionViewManager;
import org.icefaces.util.EnvUtils;
import org.icepush.PushContext;

public class BridgeSetup
implements SystemEventListener {
    public static final String ViewState = BridgeSetup.class.getName() + "::ViewState";
    public static final String BRIDGE_SETUP = BridgeSetup.class.getName();
    public static final String ICE_CORE_LIB = "ice.core";
    public static final String ICE_PUSH_LIB = "ice.push";
    private static final Logger log = Logger.getLogger(BridgeSetup.class.getName());
    private final boolean standardFormSerialization;
    private final boolean reloadOnUpdateFailure;
    private final boolean deltaSubmit;
    private int seed = 0;

    public BridgeSetup() {
        FacesContext fc = FacesContext.getCurrentInstance();
        this.reloadOnUpdateFailure = EnvUtils.reloadOnUpdateFailure(fc);
        this.deltaSubmit = EnvUtils.isDeltaSubmit(fc);
        this.standardFormSerialization = EnvUtils.isStandardFormSerialization(fc);
        fc.getExternalContext().getApplicationMap().put(BRIDGE_SETUP, this);
    }

    public boolean isListenerForSource(Object source) {
        if (!(source instanceof UIViewRoot)) {
            return false;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(facesContext)) {
            return false;
        }
        if (!EnvUtils.hasHeadAndBodyComponents(facesContext)) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "ICEfaces configured for view " + facesContext.getViewRoot().getViewId() + " but h:head and h:body components are required");
            }
            return false;
        }
        return true;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot root = context.getViewRoot();
        List<UIComponent> headResources = this.getHeadResources(context);
        for (UIComponent headResource : headResources) {
            root.addComponentResource(context, headResource, "head");
        }
        List<UIComponent> bodyResources = this.getBodyResources(context);
        for (UIComponent bodyResource : bodyResources) {
            root.addComponentResource(context, bodyResource, "body");
        }
    }

    public static BridgeSetup getBridgeSetup(FacesContext facesContext) {
        return (BridgeSetup)facesContext.getExternalContext().getApplicationMap().get(BRIDGE_SETUP);
    }

    private List<UIComponent> getHeadResources(FacesContext context) {
        ArrayList<UIComponent> resources = new ArrayList<UIComponent>();
        resources.add(ResourceOutputUtil.createTransientScriptResourceComponent("head-update-test.js", ICE_CORE_LIB));
        resources.add(ResourceOutputUtil.createTransientStyleResourceComponent("core.css", ICE_CORE_LIB));
        if (EnvUtils.isICEpushPresent()) {
            resources.add(ResourceOutputUtil.createTransientScriptResourceComponent("icepush.js", ICE_PUSH_LIB));
        }
        return resources;
    }

    public List<UIComponent> getBodyResources(FacesContext context) {
        final ExternalContext externalContext = context.getExternalContext();
        UIViewRoot root = context.getViewRoot();
        ArrayList<UIComponent> bodyResources = new ArrayList<UIComponent>();
        try {
            String tempWindowID = "unknownWindow";
            final WindowScopeManager.ScopeMap windowScope = WindowScopeManager.lookupWindowScope(context);
            if (null != windowScope) {
                tempWindowID = windowScope.getId();
            } else {
                log.log(Level.WARNING, "Unable to find WindowScope for view " + context.getViewRoot().getViewId());
            }
            final String windowID = tempWindowID;
            final String viewID = BridgeSetup.getViewID(externalContext);
            final Map viewScope = root.getViewMap();
            UIOutputWriter icefacesSetup = new UIOutputWriter(){

                @Override
                public void encode(ResponseWriter writer, FacesContext context) throws IOException {
                    boolean sendDisposeWindow = !EnvUtils.isLazyWindowScope(context) || windowScope != null && EnvUtils.containsBeans(windowScope) || viewScope != null && EnvUtils.containsDisposedBeans(viewScope);
                    String clientID = this.getClientId(context);
                    writer.startElement("span", (UIComponent)this);
                    writer.writeAttribute("id", (Object)clientID, null);
                    writer.startElement("script", (UIComponent)this);
                    writer.write("ice.setupBridge('");
                    writer.write(clientID);
                    writer.write("', '");
                    writer.write(viewID);
                    writer.write("', '");
                    writer.write(windowID);
                    writer.write("', {");
                    writer.write("reloadOnUpdateFailure: ");
                    writer.write(Boolean.toString(BridgeSetup.this.reloadOnUpdateFailure));
                    writer.write(",");
                    writer.write("deltaSubmit: ");
                    writer.write(Boolean.toString(BridgeSetup.this.deltaSubmit));
                    writer.write(",");
                    writer.write("focusManaged: ");
                    writer.write(Boolean.toString(EnvUtils.isFocusManaged(context)));
                    writer.write(",");
                    writer.write("disableDefaultErrorPopups: ");
                    writer.write(Boolean.toString(EnvUtils.disableDefaultErrorPopups(context)));
                    writer.write(",");
                    writer.write("standardFormSerialization: ");
                    writer.write(Boolean.toString(BridgeSetup.this.standardFormSerialization));
                    writer.write(",");
                    writer.write("sendDisposeWindow: ");
                    writer.write(Boolean.toString(sendDisposeWindow));
                    writer.write(",");
                    writer.write("blockUIOnSubmit: ");
                    writer.write(Boolean.toString(EnvUtils.isBlockUIOnSubmit(context)));
                    writer.write(",");
                    writer.write("clientSideElementUpdateDetermination: ");
                    writer.write(Boolean.toString(EnvUtils.isClientSideElementUpdateDetermination(context)));
                    writer.write(",");
                    writer.write("parameterPrefix: '");
                    writer.write(EnvUtils.getParameterNamespace(context));
                    writer.write("'});");
                    writer.endElement("script");
                    writer.endElement("span");
                }
            };
            Map attributes = icefacesSetup.getAttributes();
            attributes.put("name", "ICEfacesSetup.js");
            attributes.put("library", ICE_CORE_LIB);
            icefacesSetup.setTransient(true);
            icefacesSetup.setId('v' + viewID.replace(':', '_') + "_icefaces_config");
            bodyResources.add((UIComponent)icefacesSetup);
            if (EnvUtils.isICEpushPresent()) {
                UIOutputWriter icepushSetup = new UIOutputWriter(){

                    @Override
                    public void encode(ResponseWriter writer, FacesContext context) throws IOException {
                        AuxUploadSetup auxUpload;
                        String cloudPushId;
                        SessionViewManager.get(context).addView(viewID);
                        writer.startElement("span", (UIComponent)this);
                        writer.writeAttribute("id", (Object)this.getClientId(context), null);
                        writer.startElement("script", (UIComponent)this);
                        writer.writeAttribute("type", (Object)"text/javascript", null);
                        writer.write(LazyPushManager.get(context).enablePush(context, viewID) ? "ice.setupPush('" + viewID + "');" : "ice.unsetupPush('" + viewID + "');");
                        ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
                        Resource blockingConnectionResource = resourceHandler.createResource("listen.icepush.xml", null, "text/xml");
                        Resource createPushIdResource = resourceHandler.createResource("create-push-id.icepush.txt", null, "text/plain");
                        Resource notifyResource = resourceHandler.createResource("notify.icepush.txt", null, "text/plain");
                        Resource addGroupMemberResource = resourceHandler.createResource("add-group-member.icepush.txt", null, "text/plain");
                        Resource removeGroupMemberResource = resourceHandler.createResource("remove-group-member.icepush.txt", null, "text/plain");
                        boolean isPortalEnvironment = EnvUtils.instanceofPortletRequest(externalContext.getRequest());
                        String contextPath = isPortalEnvironment ? "/" : externalContext.getRequestContextPath();
                        writer.write("ice.push.configuration.contextPath=\"" + contextPath + "\";");
                        writer.write("ice.push.configuration.blockingConnectionURI=\"" + blockingConnectionResource.getRequestPath() + "\";");
                        writer.write("ice.push.configuration.createPushIdURI=\"" + createPushIdResource.getRequestPath() + "\";");
                        writer.write("ice.push.configuration.notifyURI=\"" + notifyResource.getRequestPath() + "\";");
                        writer.write("ice.push.configuration.addGroupMemberURI=\"" + addGroupMemberResource.getRequestPath() + "\";");
                        writer.write("ice.push.configuration.removeGroupMemberURI=\"" + removeGroupMemberResource.getRequestPath() + "\";");
                        writer.write("ice.push.configuration.parameterPrefix=\"" + EnvUtils.getParameterNamespace(context) + "\";");
                        boolean isAuxUpload = EnvUtils.isAuxUploadBrowser(context);
                        if (isAuxUpload && null != (cloudPushId = (auxUpload = AuxUploadSetup.getInstance()).getCloudPushId())) {
                            writer.write("window.addEventListener('load', function() { ice.push.parkInactivePushIds('" + cloudPushId + "'); }, false);");
                        }
                        writer.endElement("script");
                        writer.endElement("span");
                    }
                };
                icepushSetup.setTransient(true);
                icepushSetup.setId('v' + viewID.replace(':', '-') + "_icepush");
                bodyResources.add((UIComponent)icepushSetup);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to generate JS bridge setup.", e);
        }
        return bodyResources;
    }

    private static String assignViewID(ExternalContext externalContext) {
        String viewIDParameter = (String)externalContext.getRequestParameterMap().get("ice.view");
        BridgeSetup bridgeSetup = (BridgeSetup)externalContext.getApplicationMap().get(BRIDGE_SETUP);
        String viewID = viewIDParameter == null ? bridgeSetup.generateViewID(externalContext) : viewIDParameter;
        externalContext.getRequestMap().put(ViewState, viewID);
        return viewID;
    }

    private String generateViewID(ExternalContext externalContext) {
        if (EnvUtils.isICEpushPresent()) {
            PushContext pushContext = PushContext.getInstance((ServletContext)((ServletContext)externalContext.getContext()));
            return pushContext.createPushId((HttpServletRequest)externalContext.getRequest(), (HttpServletResponse)externalContext.getResponse());
        }
        return "v" + Integer.toString(this.hashCode(), 36) + Integer.toString(++this.seed, 36);
    }

    public static String getViewID(ExternalContext externalContext) {
        Map requestMap = externalContext.getRequestMap();
        return (String)requestMap.get(ViewState);
    }

    public static class AssignViewID
    implements PhaseListener {
        public void afterPhase(PhaseEvent event) {
        }

        public void beforePhase(PhaseEvent event) {
            BridgeSetup.assignViewID(event.getFacesContext().getExternalContext());
        }

        public PhaseId getPhaseId() {
            return PhaseId.RESTORE_VIEW;
        }
    }
}

