/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.icefaces.util.EnvUtils;

public class FacesMessagesPhaseListener
implements PhaseListener {
    private static final Logger LOGGER = Logger.getLogger(FacesMessagesPhaseListener.class.getName());
    private static final String SAVED_GLOBAL_FACES_MESSAGES_KEY = "org.icefaces.event.saved_global_faces_messages";
    private static final String SAVED_COMPONENT_FACES_MESSAGES_KEY = "org.icefaces.event.saved_component_faces_messages";

    public void afterPhase(PhaseEvent phaseEvent) {
    }

    protected void saveFacesMessages(FacesContext facesContext) {
        List globals = facesContext.getMessageList(null);
        LinkedHashMap<String, List> components = new LinkedHashMap<String, List>(6);
        Iterator cids = facesContext.getClientIdsWithMessages();
        while (cids.hasNext()) {
            String clientId = (String)cids.next();
            if (clientId == null) continue;
            List msgs = facesContext.getMessageList(clientId);
            components.put(clientId, msgs);
        }
        if (!globals.isEmpty()) {
            facesContext.getViewRoot().getAttributes().put(SAVED_GLOBAL_FACES_MESSAGES_KEY, globals);
        }
        if (!components.isEmpty()) {
            facesContext.getViewRoot().getAttributes().put(SAVED_COMPONENT_FACES_MESSAGES_KEY, components);
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        Map viewMap;
        FacesContext facesContext = phaseEvent.getFacesContext();
        if (facesContext.getViewRoot() != null && ((viewMap = facesContext.getViewRoot().getViewMap()).containsKey(EnvUtils.MESSAGE_PERSISTENCE) && ((Boolean)viewMap.get(EnvUtils.MESSAGE_PERSISTENCE)).booleanValue() || !viewMap.containsKey(EnvUtils.MESSAGE_PERSISTENCE) && EnvUtils.isMessagePersistence(facesContext))) {
            this.restoreFacesMessages(facesContext);
            this.saveFacesMessages(facesContext);
        }
    }

    protected void restoreFacesMessages(FacesContext facesContext) {
        List globals = (List)facesContext.getViewRoot().getAttributes().remove(SAVED_GLOBAL_FACES_MESSAGES_KEY);
        Map components = (Map)facesContext.getViewRoot().getAttributes().remove(SAVED_COMPONENT_FACES_MESSAGES_KEY);
        if (globals != null && globals.size() > 0 && !FacesMessagesPhaseListener.fullExecute(facesContext)) {
            List newGlobals = facesContext.getMessageList(null);
            for (FacesMessage fm : globals) {
                if (newGlobals.contains(fm)) continue;
                boolean matchedSummaryAndDetail = false;
                for (FacesMessage newGlobal : newGlobals) {
                    if (!FacesMessagesPhaseListener.stringEquals(newGlobal.getSummary(), fm.getSummary()) || !FacesMessagesPhaseListener.stringEquals(newGlobal.getDetail(), fm.getDetail())) continue;
                    matchedSummaryAndDetail = true;
                    break;
                }
                if (matchedSummaryAndDetail) continue;
                facesContext.addMessage(null, fm);
            }
        }
        if (components != null && components.size() > 0 && !FacesMessagesPhaseListener.fullExecute(facesContext)) {
            Collection executeIds = facesContext.getPartialViewContext().getExecuteIds();
            HashMap<String, Boolean> clientId2Executed = new HashMap<String, Boolean>(components.size());
            Set clientIds = components.keySet();
            EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, clientIds, hints);
            ComponentsExecutedByExecuteId vcall = new ComponentsExecutedByExecuteId(executeIds, clientId2Executed);
            facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)vcall);
            for (String clientId : clientIds) {
                Boolean executedResult = (Boolean)clientId2Executed.get(clientId);
                boolean executed = executedResult != null && executedResult != false;
                if (executed) continue;
                List msgs = (List)components.get(clientId);
                List existingMsgs = facesContext.getMessageList(clientId);
                for (FacesMessage fm : msgs) {
                    boolean matchedSummaryAndDetail = false;
                    if (existingMsgs != null) {
                        for (FacesMessage existing : existingMsgs) {
                            if (!FacesMessagesPhaseListener.stringEquals(existing.getSummary(), fm.getSummary()) || !FacesMessagesPhaseListener.stringEquals(existing.getDetail(), fm.getDetail())) continue;
                            matchedSummaryAndDetail = true;
                            break;
                        }
                    }
                    if (matchedSummaryAndDetail) continue;
                    facesContext.addMessage(clientId, fm);
                }
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    private static boolean fullExecute(FacesContext facesContext) {
        return !facesContext.getPartialViewContext().isPartialRequest() || facesContext.getPartialViewContext().isExecuteAll();
    }

    private static boolean stringEquals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private static class ComponentsExecutedByExecuteId
    implements VisitCallback {
        private Collection<String> executeIds;
        private Map<String, Boolean> clientId2Executed;

        ComponentsExecutedByExecuteId(Collection<String> executeIds, Map<String, Boolean> clientId2Executed) {
            this.executeIds = executeIds;
            this.clientId2Executed = clientId2Executed;
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
            FacesContext facesContext = visitContext.getFacesContext();
            String clientId = uiComponent.getClientId(facesContext);
            boolean executed = false;
            UIComponent currComp = uiComponent;
            String currClientId = clientId;
            while (true) {
                if (this.executeIds.contains(currClientId)) {
                    executed = true;
                    break;
                }
                if ((currComp = currComp.getParent()) == null || currComp instanceof UIViewRoot) break;
                currClientId = currComp.getClientId(facesContext);
            }
            this.clientId2Executed.put(clientId, executed);
            return VisitResult.ACCEPT;
        }
    }
}

