/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.util.ArrayList;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.util.EnvUtils;

public class FixViewState
implements SystemEventListener {
    private static final String ID_SUFFIX = "_fixviewstate";
    public static final String FORM_LIST_KEY = "ice.faces.formList";

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (fc.isPostback()) {
            UIForm form = (UIForm)((ComponentSystemEvent)event).getComponent();
            String formClientID = form.getClientId();
            Map facesMap = fc.getAttributes();
            ArrayList<String> formIdList = (ArrayList<String>)facesMap.get(FORM_LIST_KEY);
            if (formIdList == null) {
                formIdList = new ArrayList<String>();
                facesMap.put(FORM_LIST_KEY, formIdList);
            }
            formIdList.add(formClientID);
        }
    }

    public boolean isListenerForSource(Object source) {
        if (EnvUtils.isICEfacesView(FacesContext.getCurrentInstance()) && source instanceof UIForm) {
            UIForm form = (UIForm)source;
            String componentId = form.getId() + ID_SUFFIX;
            for (UIComponent comp : form.getParent().getChildren()) {
                if (!componentId.equals(comp.getId())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

