/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitWrapper;
import org.icefaces.impl.event.ResourceOutputUtil;
import org.icefaces.impl.renderkit.DOMRenderKit;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.resources.ICEResourceDependencies;
import org.icefaces.resources.ICEResourceDependency;
import org.icefaces.resources.ICEResourceLibrary;
import org.icefaces.resources.ICEResourceUtils;
import org.icefaces.resources.ResourceInfo;
import org.icefaces.util.EnvUtils;
import org.icefaces.util.UserAgentContext;

public class MandatoryResourcesSetup
implements SystemEventListener {
    private static final Logger log = Logger.getLogger(MandatoryResourcesSetup.class.getName());

    public boolean isListenerForSource(Object source) {
        if (!(source instanceof UIViewRoot)) {
            return false;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(facesContext)) {
            return false;
        }
        if (!EnvUtils.hasHeadAndBodyComponents(facesContext)) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "ICEfaces configured for view " + facesContext.getViewRoot().getViewId() + " but h:head and h:body components are required");
            }
            return false;
        }
        return true;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        Collection facets = context.getViewRoot().getFacets().values();
        for (UIComponent c : facets) {
            c.setInView(false);
        }
        this.addMandatoryResources(context);
        UIComponent jsfResource = ResourceOutputUtil.createTransientScriptResourceComponent("jsf.js", "javax.faces");
        MandatoryResourcesSetup.addOrCollectReplacingResource(context, "jsf.js", "javax.faces", "head", jsfResource);
        for (UIComponent c : facets) {
            c.setInView(true);
        }
    }

    private RenderKit findDOMRenderKit(FacesContext facesContext) {
        RenderKit rk = facesContext.getRenderKit();
        while (rk instanceof RenderKitWrapper) {
            if (rk instanceof DOMRenderKit) {
                return rk;
            }
            rk = ((RenderKitWrapper)rk).getWrapped();
        }
        return rk;
    }

    private void addMandatoryResources(FacesContext context) {
        RenderKit rk = this.findDOMRenderKit(context);
        if (rk instanceof DOMRenderKit) {
            DOMRenderKit drk = (DOMRenderKit)rk;
            HashSet<ResourceInfo> addedResourceDependencies = new HashSet<ResourceInfo>();
            List<MandatoryResourceComponent> mandatoryResourceComponents = drk.getMandatoryResourceComponents();
            String resourceConfig = EnvUtils.getMandatoryResourceConfig(context);
            String resourceConfigPad = " " + resourceConfig + " ";
            UserAgentContext uaContext = UserAgentContext.getInstance(context);
            for (MandatoryResourceComponent mrc : mandatoryResourceComponents) {
                String compClassName = mrc.value();
                if (!"all".equalsIgnoreCase(resourceConfig)) {
                    String tagName = mrc.tagName();
                    if (!resourceConfigPad.contains(" " + compClassName + " ") && tagName != null && tagName.length() > 0 && !resourceConfigPad.contains(" " + tagName + " ")) continue;
                }
                try {
                    ResourceInfo resInfo;
                    Class<?> compClass = Class.forName(compClassName);
                    ICEResourceDependencies resourceDependencies = compClass.getAnnotation(ICEResourceDependencies.class);
                    ICEResourceLibrary library = compClass.getAnnotation(ICEResourceLibrary.class);
                    ICEResourceDependency resourceDependency = compClass.getAnnotation(ICEResourceDependency.class);
                    if (resourceDependencies != null) {
                        for (ICEResourceDependency resDep : resourceDependencies.value()) {
                            ResourceInfo resInfo2 = ICEResourceUtils.getResourceInfo(uaContext, resDep, library);
                            if (resInfo2 == null) continue;
                            MandatoryResourcesSetup.addMandatoryResourceDependency(context, compClassName, addedResourceDependencies, resInfo2);
                        }
                    }
                    if ((resInfo = ICEResourceUtils.getResourceInfo(uaContext, resourceDependency, library)) == null) continue;
                    MandatoryResourcesSetup.addMandatoryResourceDependency(context, compClassName, addedResourceDependencies, resInfo);
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.log(Level.WARNING, "When processing mandatory resource components, could not create instance of '" + compClassName + "'");
                }
            }
        }
    }

    private static void addMandatoryResourceDependency(FacesContext facesContext, String compClassName, Set<ResourceInfo> addedResDeps, ResourceInfo resDep) {
        if (addedResDeps.contains(resDep)) {
            return;
        }
        addedResDeps.add(resDep);
        MandatoryResourcesSetup.addMandatoryResource(facesContext, compClassName, resDep.name, resDep.library, resDep.target);
    }

    private static void addMandatoryResource(FacesContext facesContext, String compClassName, String name, String library, String target) {
        ResourceHandler resourceHandler;
        String rendererType;
        if (target == null || target.length() == 0) {
            target = "head";
        }
        if ((rendererType = (resourceHandler = facesContext.getApplication().getResourceHandler()).getRendererTypeForResourceName(name)) == null || rendererType.length() == 0) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Could not determine renderer type for mandatory resource, for component: " + compClassName + ". Resource name: " + name + ", library: " + library);
            }
        } else {
            UIComponent component = ResourceOutputUtil.createResourceComponent(name, library, rendererType, true);
            MandatoryResourcesSetup.addOrCollectReplacingResource(facesContext, name, library, target, component);
        }
    }

    public static void addOrCollectReplacingResource(FacesContext context, String name, String library, String target, UIComponent component) {
        UIViewRoot viewRoot = context.getViewRoot();
        List componentResources = viewRoot.getComponentResources(context, target);
        int position = -1;
        for (int i = 0; i < componentResources.size(); ++i) {
            UIComponent c = (UIComponent)componentResources.get(i);
            Map attributes = c.getAttributes();
            String resourceName = (String)attributes.get("name");
            String resourceLibrary = MandatoryResourcesSetup.fixResourceParameter((String)attributes.get("library"));
            String normalizedLibrary = MandatoryResourcesSetup.fixResourceParameter(library);
            if (!name.equals(resourceName) || normalizedLibrary != resourceLibrary && !normalizedLibrary.equals(resourceLibrary)) continue;
            position = i;
            break;
        }
        if (position == -1) {
            viewRoot.addComponentResource(context, component, target);
        }
    }

    private static String calculateKey(String name, String library, String target) {
        return name + ":" + library + ":" + target;
    }

    private static String fixResourceParameter(String value) {
        return value == null || "".equals(value) ? null : value;
    }
}

