/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import com.sun.faces.facelets.tag.ui.UIDebug;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseId;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.util.EnvUtils;

public class MojarraDebugTagListener
implements SystemEventListener {
    private static final Logger LOGGER = Logger.getLogger(MojarraDebugTagListener.class.getName());

    public boolean isListenerForSource(Object source) {
        return source.getClass().getName().equals("com.sun.faces.facelets.tag.ui.UIDebug");
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(context)) {
            return;
        }
        if (event instanceof PostAddToViewEvent) {
            UIDebug debugTag = (UIDebug)((PostAddToViewEvent)event).getComponent();
            String debugId = debugTag.getId();
            UIComponent parent = debugTag.getParent();
            if (context.getCurrentPhaseId().equals(PhaseId.RESTORE_VIEW)) {
                parent.getChildren().remove(debugTag);
                return;
            }
            if (parent instanceof HtmlPanelGroup) {
                return;
            }
            Iterator kids = parent.getChildren().iterator();
            int debugLocation = 0;
            int counter = 0;
            while (kids.hasNext()) {
                if (((UIComponent)kids.next()).getId().equals(debugId)) {
                    debugLocation = counter;
                }
                ++counter;
            }
            parent.getChildren().remove(debugTag);
            HtmlPanelGroup enclosingPanel = new HtmlPanelGroup();
            enclosingPanel.setId("debugPanel");
            enclosingPanel.setInView(true);
            enclosingPanel.setTransient(true);
            enclosingPanel.getChildren().add(debugTag);
            parent.getChildren().add(debugLocation, enclosingPanel);
        }
    }
}

