/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.event.ResourceOutputUtil;
import org.icefaces.resources.ICEResourceDependencies;
import org.icefaces.resources.ICEResourceDependency;
import org.icefaces.resources.ICEResourceLibrary;
import org.icefaces.resources.ICEResourceUtils;
import org.icefaces.resources.ResourceInfo;
import org.icefaces.util.UserAgentContext;

public class RestoreResourceDependencies
implements SystemEventListener {
    private static final Set<VisitHint> HINTS = EnumSet.of(VisitHint.SKIP_ITERATION);

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        final FacesContext facesContext = FacesContext.getCurrentInstance();
        final UserAgentContext uaContext = UserAgentContext.getInstance(facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, HINTS);
        viewRoot.visitTree(visitContext, new VisitCallback(){

            public VisitResult visit(VisitContext context, UIComponent target) {
                ResourceInfo resInfo;
                VisitResult result = VisitResult.ACCEPT;
                Class<?> compClass = target.getClass();
                ICEResourceDependencies resourceDependencies = compClass.getAnnotation(ICEResourceDependencies.class);
                ICEResourceDependency resourceDependency = compClass.getAnnotation(ICEResourceDependency.class);
                ICEResourceLibrary library = compClass.getAnnotation(ICEResourceLibrary.class);
                if (resourceDependencies != null) {
                    for (ICEResourceDependency resDep : resourceDependencies.value()) {
                        ResourceInfo resInfo2 = ICEResourceUtils.getResourceInfo(uaContext, resDep, library);
                        if (resInfo2 == null) continue;
                        RestoreResourceDependencies.this.addResourceDependency(facesContext, resInfo2);
                    }
                }
                if ((resInfo = ICEResourceUtils.getResourceInfo(uaContext, resourceDependency, library)) != null) {
                    RestoreResourceDependencies.this.addResourceDependency(facesContext, resInfo);
                }
                return result;
            }
        });
    }

    private void addResourceDependency(FacesContext context, ResourceInfo resourceInfo) {
        UIViewRoot viewRoot = context.getViewRoot();
        ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
        String name = resourceInfo.name;
        String library = resourceInfo.library;
        String target = resourceInfo.target;
        target = target == null || "".equals(target) ? "head" : target;
        List componentResources = viewRoot.getComponentResources(context, target);
        int position = -1;
        for (int i = 0; i < componentResources.size(); ++i) {
            UIComponent c = (UIComponent)componentResources.get(i);
            Map attributes = c.getAttributes();
            String resourceName = (String)attributes.get("name");
            String resourceLibrary = RestoreResourceDependencies.fixResourceParameter((String)attributes.get("library"));
            String normalizedLibrary = RestoreResourceDependencies.fixResourceParameter(library);
            if (!name.equals(resourceName) || normalizedLibrary != resourceLibrary && !normalizedLibrary.equals(resourceLibrary)) continue;
            position = i;
            break;
        }
        if (position == -1) {
            String rendererType = resourceHandler.getRendererTypeForResourceName(name);
            viewRoot.addComponentResource(context, ResourceOutputUtil.createResourceComponent(name, library, rendererType, true), target);
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    private static String fixResourceParameter(String value) {
        return value == null || "".equals(value) ? null : value;
    }
}

