/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.util.Random;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.event.ScriptWriter;
import org.icefaces.util.EnvUtils;

public class SessionExpiryWarning
implements SystemEventListener {
    private static final Random RANDOM = new Random();
    private long intervalBeforeExpiry = EnvUtils.getWarnBeforeExpiryInterval(FacesContext.getCurrentInstance()) * 1000L;

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        long maxInactiveInterval = externalContext.getSessionMaxInactiveInterval() * 1000;
        long deltaTime = maxInactiveInterval - this.intervalBeforeExpiry;
        UIComponent bodyComponent = (UIComponent)event.getSource();
        String code = EnvUtils.isPushRequest(context) ? "" : "ice.resetSessionExpiryTimeout(" + deltaTime + "," + this.intervalBeforeExpiry + ");//" + RANDOM.nextInt();
        ScriptWriter c = new ScriptWriter(bodyComponent, code, "reset_session_expiry_timeout");
        bodyComponent.getChildren().add(c);
    }

    public boolean isListenerForSource(Object source) {
        FacesContext context = FacesContext.getCurrentInstance();
        return EnvUtils.isICEfacesView(context) && "javax.faces.Body".equals(((UIComponent)source).getRendererType()) && this.intervalBeforeExpiry > -1L;
    }
}

