/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.impl.event.UIOutputWriter;
import org.icefaces.util.EnvUtils;

public class WindowAndViewIDSetup
implements SystemEventListener {
    private static final Logger Log = Logger.getLogger(WindowAndViewIDSetup.class.getName());
    private static final String ID_SUFFIX = "_windowviewid";
    private boolean partialStateSaving = EnvUtils.isPartialStateSaving(FacesContext.getCurrentInstance());

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        UIForm form = (UIForm)((ComponentSystemEvent)event).getComponent();
        String componentId = form.getId() + ID_SUFFIX;
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        final String windowID = externalContext.getClientWindow().getId();
        final String viewID = BridgeSetup.getViewID(externalContext);
        final WindowScopeManager.ScopeMap scopeMap = WindowScopeManager.lookupWindowScope(context);
        UIOutputWriter output = new UIOutputWriter(){

            @Override
            public void encode(ResponseWriter writer, FacesContext context) throws IOException {
                if (windowID == null) {
                    if (context.isProjectStage(ProjectStage.Development)) {
                        Log.warning("Missing window ID attribute. Request map cleared prematurely.");
                    }
                    return;
                }
                if (viewID == null) {
                    if (context.isProjectStage(ProjectStage.Development)) {
                        Log.warning("Missing view ID attribute. Request map cleared prematurely.");
                    }
                    return;
                }
                if (scopeMap == null) {
                    if (context.isProjectStage(ProjectStage.Development)) {
                        Log.warning("Missing window scope map. Session was invalidated or dispose window request already cleared the window scope.");
                    }
                    return;
                }
                String prefix = EnvUtils.getParameterNamespace(context);
                writer.startElement("input", (UIComponent)this);
                writer.writeAttribute("type", (Object)"hidden", null);
                writer.writeAttribute("name", (Object)(prefix + "ice.window"), null);
                writer.writeAttribute("value", (Object)scopeMap.getId(), null);
                writer.writeAttribute("autocomplete", (Object)"off", null);
                writer.endElement("input");
                writer.startElement("input", (UIComponent)this);
                writer.writeAttribute("type", (Object)"hidden", null);
                writer.writeAttribute("name", (Object)(prefix + "ice.view"), null);
                writer.writeAttribute("value", (Object)viewID, null);
                writer.writeAttribute("autocomplete", (Object)"off", null);
                writer.endElement("input");
            }
        };
        output.setTransient(true);
        output.setId(componentId);
        form.getChildren().add(0, output);
    }

    public boolean isListenerForSource(Object source) {
        if (!(source instanceof UIForm)) {
            return false;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(facesContext)) {
            return false;
        }
        UIForm htmlForm = (UIForm)source;
        String componentId = htmlForm.getId() + ID_SUFFIX;
        if (!this.partialStateSaving) {
            for (UIComponent child : htmlForm.getChildren()) {
                String id = child.getId();
                if (null == id || !id.endsWith(ID_SUFFIX)) continue;
                return false;
            }
        }
        for (UIComponent comp : htmlForm.getChildren()) {
            if (!componentId.equals(comp.getId())) continue;
            return false;
        }
        return true;
    }
}

