/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.facelets.tag.icefaces.core;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.icefaces.util.EnvUtils;

public class ConfigHandler
extends TagHandler {
    private static final Logger LOGGER = Logger.getLogger(ConfigHandler.class.getName());
    private final TagAttribute render = this.getAttribute("render");
    private final TagAttribute ariaEnabled = this.getAttribute("ariaEnabled");
    private final TagAttribute blockUIOnSubmit = this.getAttribute("blockUIOnSubmit");
    private final TagAttribute lazyPush = this.getAttribute("lazyPush");
    private final TagAttribute subtreeDiff = this.getAttribute("subtreeDiff");
    private final TagAttribute diffConfig = this.getAttribute("diffConfig");
    private final TagAttribute mandatoryResource = this.getAttribute("mandatoryResource");
    private final TagAttribute messagePersistence = this.getAttribute("messagePersistence");
    private final TagAttribute focusManaged = this.getAttribute("focusManaged");

    public ConfigHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        FacesContext fc = ctx.getFacesContext();
        UIViewRoot root = fc.getViewRoot();
        Map viewMap = root.getViewMap();
        String renderValue = "true";
        if (this.render != null) {
            renderValue = this.render.getValue();
        }
        viewMap.put(EnvUtils.ICEFACES_RENDER, new Boolean("true".equalsIgnoreCase(renderValue)));
        if (this.ariaEnabled != null) {
            viewMap.put(EnvUtils.ARIA_ENABLED, new Boolean(this.ariaEnabled.getValue()));
        }
        if (this.blockUIOnSubmit != null) {
            viewMap.put(EnvUtils.BLOCK_UI_ON_SUBMIT, new Boolean(this.blockUIOnSubmit.getValue()));
        }
        if (this.lazyPush != null) {
            viewMap.put(EnvUtils.LAZY_PUSH, new Boolean(this.lazyPush.getValue()));
        }
        if (this.focusManaged != null) {
            viewMap.put(EnvUtils.FOCUS_MANAGED, new Boolean(this.focusManaged.getValue()));
        }
        if (this.subtreeDiff != null) {
            viewMap.put(EnvUtils.SUBTREE_DIFF, new Boolean(this.subtreeDiff.getValue()));
        }
        if (this.diffConfig != null) {
            viewMap.put(EnvUtils.DIFF_CONFIG, new String(this.diffConfig.getValue()));
        }
        if (null != this.mandatoryResource) {
            viewMap.put(EnvUtils.MANDATORY_RESOURCE_CONFIG, this.mandatoryResource.getValue());
        }
        if (this.messagePersistence != null) {
            viewMap.put(EnvUtils.MESSAGE_PERSISTENCE, new Boolean(this.messagePersistence.getValue()));
        }
    }
}

