/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.push;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.portlet.PortletSession;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.icepush.PushContext;

public abstract class SessionViewManager {
    private static final Logger LOGGER = Logger.getLogger(SessionViewManager.class.getName());

    public static SessionViewManager get(final Map applicationMap, final Map sessionMap, final Object session) {
        return new SessionViewManager(){

            @Override
            protected State getState() {
                if (sessionMap == null) {
                    throw new IllegalStateException("The session was invalidated/expired.");
                }
                State state = (State)sessionMap.get(SessionViewManager.class.getName());
                if (state == null) {
                    if (session instanceof HttpSession) {
                        state = new State(((HttpSession)session).getId());
                    } else if (session instanceof PortletSession) {
                        state = new State(((PortletSession)session).getId());
                    } else {
                        throw new RuntimeException("Unknown session object: " + session);
                    }
                    sessionMap.put(SessionViewManager.class.getName(), state);
                }
                return state;
            }

            @Override
            protected PushContext getPushContext() {
                return (PushContext)applicationMap.get(PushContext.class.getName());
            }
        };
    }

    public static SessionViewManager get(final FacesContext context) {
        return new SessionViewManager(){

            @Override
            protected State getState() {
                Map sessionMap = context.getExternalContext().getSessionMap();
                if (sessionMap == null) {
                    throw new IllegalStateException("The session was invalidated/expired.");
                }
                State state = (State)sessionMap.get(SessionViewManager.class.getName());
                if (state == null) {
                    Object session = context.getExternalContext().getSession(true);
                    if (session instanceof HttpSession) {
                        state = new State(((HttpSession)session).getId());
                    } else if (session instanceof PortletSession) {
                        state = new State(((PortletSession)session).getId());
                    } else {
                        throw new RuntimeException("Unknown session object: " + session);
                    }
                    sessionMap.put(SessionViewManager.class.getName(), state);
                }
                return state;
            }

            @Override
            protected PushContext getPushContext() {
                return (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            }
        };
    }

    public static SessionViewManager get(final HttpSession session) {
        return new SessionViewManager(){

            @Override
            protected State getState() {
                State state = (State)session.getAttribute(SessionViewManager.class.getName());
                if (state == null) {
                    if (session instanceof HttpSession) {
                        state = new State(session.getId());
                    } else if (session instanceof PortletSession) {
                        state = new State(((PortletSession)session).getId());
                    } else {
                        throw new RuntimeException("Unknown session object: " + session);
                    }
                    session.setAttribute(SessionViewManager.class.getName(), (Object)state);
                }
                return state;
            }

            @Override
            protected PushContext getPushContext() {
                return PushContext.getInstance((ServletContext)session.getServletContext());
            }
        };
    }

    public void addCurrentSessionToGroup(String groupName) {
        try {
            this.startAddingNewViewsToGroup(groupName);
            PushContext pushContext = this.getPushContext();
            State state = this.getState();
            Iterator viewIDs = state.viewIDSet.iterator();
            while (viewIDs.hasNext()) {
                pushContext.addGroupMember(groupName, (String)viewIDs.next());
            }
        }
        catch (IllegalStateException e) {
            LOGGER.fine("The session was invalidated/expired.");
        }
    }

    public void addView(String id) {
        try {
            PushContext pushContext = this.getPushContext();
            State state = this.getState();
            state.viewIDSet.add(id);
            pushContext.addGroupMember(state.groupName, id);
            Iterator i = state.groups.iterator();
            while (i.hasNext()) {
                pushContext.addGroupMember((String)i.next(), id);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.fine("The session was invalidated/expired.");
        }
    }

    public Set<String> getCurrentSessionViewSet() {
        return Collections.unmodifiableSet(this.getState().viewIDSet);
    }

    public void removeCurrentSessionFromGroup(String groupName) {
        try {
            this.stopAddingNewViewsToGroup(groupName);
            PushContext pushContext = this.getPushContext();
            State state = this.getState();
            Iterator viewIDs = state.viewIDSet.iterator();
            while (viewIDs.hasNext()) {
                pushContext.removeGroupMember(groupName, (String)viewIDs.next());
            }
        }
        catch (IllegalStateException e) {
            LOGGER.fine("The session was invalidated/expired.");
        }
    }

    public void removeView(String id) {
        try {
            PushContext pushContext = this.getPushContext();
            State state = this.getState();
            state.viewIDSet.remove(id);
            pushContext.removeGroupMember(state.groupName, id);
            Iterator i = state.groups.iterator();
            while (i.hasNext()) {
                pushContext.removeGroupMember((String)i.next(), id);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.fine("The session was invalidated/expired.");
        }
    }

    public void startAddingNewViewsToGroup(String groupName) {
        State state = this.getState();
        state.groups.add(groupName);
    }

    public void stopAddingNewViewsToGroup(String groupName) {
        State state = this.getState();
        state.groups.remove(groupName);
    }

    protected abstract State getState();

    protected abstract PushContext getPushContext();

    private static class State
    implements Serializable {
        private final CopyOnWriteArraySet<String> viewIDSet = new CopyOnWriteArraySet();
        private String groupName;
        private HashSet groups = new HashSet();

        private State(String groupName) {
            this.groupName = groupName;
        }
    }
}

