/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.push.servlet;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FactoryFinder;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icefaces.impl.event.DebugTagListener;
import org.icefaces.impl.push.servlet.ProxyHttpServletRequest;
import org.icefaces.util.EnvUtils;
import org.icepush.PushContext;
import org.icepush.servlet.MainServlet;
import org.icepush.util.ExtensionRegistry;

public class ICEpushResourceHandler
extends ResourceHandlerWrapper
implements PhaseListener {
    private static final Logger log = Logger.getLogger(ICEpushResourceHandler.class.getName());
    public static final String BLOCKING_CONNECTION_RESOURCE_NAME = "listen.icepush.xml";
    public static final String CREATE_PUSH_ID_RESOURCE_NAME = "create-push-id.icepush.txt";
    public static final String NOTIFY_RESOURCE_NAME = "notify.icepush.txt";
    public static final String ADD_GROUP_MEMBER_RESOURCE_NAME = "add-group-member.icepush.txt";
    public static final String REMOVE_GROUP_MEMBER_RESOURCE_NAME = "remove-group-member.icepush.txt";
    private static final Collection RESOURCES = Arrays.asList("listen.icepush.xml", "notify.icepush.txt", "create-push-id.icepush.txt", "add-group-member.icepush.txt", "remove-group-member.icepush.txt");
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Condition condition = lock.newCondition();
    private transient AbstractICEpushResourceHandler resourceHandler;

    public ICEpushResourceHandler(final ResourceHandler resourceHandler) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        final ServletContext servletContext = (ServletContext)facesContext.getExternalContext().getContext();
        String projectStage = servletContext.getInitParameter("javax.faces.PROJECT_STAGE");
        if (projectStage != null && !projectStage.equals("Production")) {
            facesContext.getApplication().subscribeToEvent(PostAddToViewEvent.class, (SystemEventListener)new DebugTagListener());
        }
        if (EnvUtils.isICEpushPresent()) {
            String serverInfo = servletContext.getServerInfo();
            if (!serverInfo.startsWith("JBoss Web/3.0.0-CR1") && !serverInfo.startsWith("JBoss Web/3.0.0-CR2")) {
                this.resourceHandler = new ICEpushResourceHandlerImpl();
                this.resourceHandler.initialize(resourceHandler, servletContext, this);
            } else {
                final ICEpushResourceHandlerImpl impl = new ICEpushResourceHandlerImpl();
                this.resourceHandler = new BlockingICEpushResourceHandlerWrapper(impl);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ICEpushResourceHandler.this.resourceHandler.initialize(resourceHandler, servletContext, ICEpushResourceHandler.this);
                        ICEpushResourceHandler.this.resourceHandler = impl;
                        lock.lock();
                        try {
                            condition.signalAll();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }).start();
            }
        } else {
            this.resourceHandler = new ProxyICEpushResourceHandler(resourceHandler);
            log.log(Level.INFO, "Ajax Push Resource Handling not available.");
        }
    }

    public void afterPhase(PhaseEvent event) {
        this.resourceHandler.afterPhase(event);
    }

    public void beforePhase(PhaseEvent event) {
        this.resourceHandler.beforePhase(event);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        return this.resourceHandler.createResource(resourceName, libraryName, contentType);
    }

    public PhaseId getPhaseId() {
        return this.resourceHandler.getPhaseId();
    }

    public ResourceHandler getWrapped() {
        return this.resourceHandler.getWrapped();
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        this.resourceHandler.handleResourceRequest(facesContext);
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        return this.resourceHandler.isResourceRequest(facesContext);
    }

    public static void notifyContextShutdown(ServletContext context) {
        try {
            ((ICEpushResourceHandler)((Object)context.getAttribute(ICEpushResourceHandler.class.getName()))).shutdownMainServlet();
        }
        catch (Throwable t) {
            log.log(Level.FINE, "MainServlet not found in application scope: " + t);
        }
    }

    private void shutdownMainServlet() {
        this.resourceHandler.shutdownMainServlet();
    }

    private static class ProxyICEpushResourceHandler
    extends AbstractICEpushResourceHandler {
        private final ResourceHandler resourceHandler;

        public ProxyICEpushResourceHandler(ResourceHandler resourceHandler) {
            this.resourceHandler = resourceHandler;
        }

        @Override
        void initialize(ResourceHandler resourceHandler, ServletContext servletContext, ICEpushResourceHandler icePushResourceHandler) {
        }

        @Override
        void shutdownMainServlet() {
        }

        public void afterPhase(PhaseEvent event) {
        }

        public void beforePhase(PhaseEvent event) {
        }

        public PhaseId getPhaseId() {
            return null;
        }

        public ResourceHandler getWrapped() {
            return this.resourceHandler;
        }
    }

    private static class BlockingICEpushResourceHandlerWrapper
    extends AbstractICEpushResourceHandler {
        private final ICEpushResourceHandlerImpl resourceHandler;

        private BlockingICEpushResourceHandlerWrapper(ICEpushResourceHandlerImpl resourceHandler) {
            this.resourceHandler = resourceHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterPhase(PhaseEvent event) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                this.resourceHandler.afterPhase(event);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforePhase(PhaseEvent event) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                this.resourceHandler.beforePhase(event);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource createResource(String resourceName) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                Resource resource = this.resourceHandler.createResource(resourceName);
                return resource;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource createResource(String resourceName, String libraryName) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                Resource resource = this.resourceHandler.createResource(resourceName, libraryName);
                return resource;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource createResource(String resourceName, String libraryName, String contentType) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                Resource resource = this.resourceHandler.createResource(resourceName, libraryName, contentType);
                return resource;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PhaseId getPhaseId() {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                PhaseId phaseId = this.resourceHandler.getPhaseId();
                return phaseId;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getRendererTypeForResourceName(String resourceName) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                String string = this.resourceHandler.getRendererTypeForResourceName(resourceName);
                return string;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourceHandler getWrapped() {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                ResourceHandler resourceHandler = this.resourceHandler.getWrapped();
                return resourceHandler;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResourceRequest(FacesContext facesContext) throws IOException {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                this.resourceHandler.handleResourceRequest(facesContext);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isResourceRequest(FacesContext facesContext) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                boolean bl = this.resourceHandler.isResourceRequest(facesContext);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean libraryExists(String libraryName) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                boolean bl = this.resourceHandler.libraryExists(libraryName);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        void initialize(ResourceHandler resourceHandler, ServletContext servletContext, ICEpushResourceHandler icePushResourceHandler) {
            this.resourceHandler.initialize(resourceHandler, servletContext, icePushResourceHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void shutdownMainServlet() {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                this.resourceHandler.shutdownMainServlet();
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class ICEpushResourceHandlerImpl
    extends AbstractICEpushResourceHandler {
        private static final Pattern ICEpushRequestPattern = Pattern.compile(".*\\.icepush");
        private static final String RESOURCE_KEY = "javax.faces.resource";
        private static final String BROWSERID_COOKIE = "ice.push.browser";
        private ResourceHandler resourceHandler;
        private MainServlet mainServlet;
        private ServletContext servletContext;

        private ICEpushResourceHandlerImpl() {
        }

        public void afterPhase(PhaseEvent event) {
        }

        public void beforePhase(PhaseEvent event) {
            if (this.mainServlet == null) {
                Class mainServletClass = (Class)ExtensionRegistry.getBestExtension((ServletContext)this.servletContext, (String)"org.icepush.MainServlet");
                try {
                    Method mainServletGet = mainServletClass.getMethod("getInstance", ServletContext.class);
                    this.mainServlet = (MainServlet)mainServletGet.invoke(null, this.servletContext);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Cannot instantiate extension org.icepush.MainServlet.", e);
                    throw new RuntimeException(e);
                }
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            Object BrowserID = externalContext.getRequestCookieMap().get(BROWSERID_COOKIE);
            HttpServletRequest request = EnvUtils.getSafeRequest(facesContext);
            HttpServletResponse response = EnvUtils.getSafeResponse(facesContext);
            if (null == BrowserID) {
                ((PushContext)externalContext.getApplicationMap().get(PushContext.class.getName())).createPushId(request, response);
            }
        }

        public PhaseId getPhaseId() {
            return PhaseId.RESTORE_VIEW;
        }

        public ResourceHandler getWrapped() {
            return this.resourceHandler;
        }

        public void handleResourceRequest(FacesContext facesContext) throws IOException {
            if (null == this.mainServlet) {
                this.resourceHandler.handleResourceRequest(facesContext);
                return;
            }
            String resourceName = (String)facesContext.getExternalContext().getRequestParameterMap().get(RESOURCE_KEY);
            HttpServletRequest request = EnvUtils.getSafeRequest(facesContext);
            HttpServletResponse response = EnvUtils.getSafeResponse(facesContext);
            if (RESOURCES.contains(resourceName)) {
                try {
                    this.mainServlet.service(request, response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            if (request instanceof ProxyHttpServletRequest) {
                this.resourceHandler.handleResourceRequest(facesContext);
                return;
            }
            String requestURI = request.getRequestURI();
            if (ICEpushRequestPattern.matcher(requestURI).find()) {
                try {
                    this.mainServlet.service(request, response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.resourceHandler.handleResourceRequest(facesContext);
            }
            catch (IOException e) {
                if (e.getClass().getName().endsWith("ClientAbortException")) {
                    log.fine("Browser closed the connection prematurely for " + requestURI);
                }
                throw e;
            }
        }

        public boolean isResourceRequest(FacesContext facesContext) {
            String resourceName = (String)facesContext.getExternalContext().getRequestParameterMap().get(RESOURCE_KEY);
            if (RESOURCES.contains(resourceName)) {
                return true;
            }
            ExternalContext externalContext = facesContext.getExternalContext();
            if (EnvUtils.instanceofPortletRequest(externalContext.getRequest())) {
                return this.resourceHandler.isResourceRequest(facesContext);
            }
            HttpServletRequest servletRequest = (HttpServletRequest)externalContext.getRequest();
            String requestURI = servletRequest.getRequestURI();
            return this.resourceHandler.isResourceRequest(facesContext) || ICEpushRequestPattern.matcher(requestURI).find();
        }

        @Override
        void initialize(ResourceHandler resourceHandler, ServletContext servletContext, ICEpushResourceHandler icePushResourceHandler) {
            this.resourceHandler = resourceHandler;
            this.servletContext = servletContext;
            servletContext.setAttribute(ICEpushResourceHandler.class.getName(), (Object)icePushResourceHandler);
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Iterator lifecycleIds = lifecycleFactory.getLifecycleIds();
            while (lifecycleIds.hasNext()) {
                String lifecycleId = (String)lifecycleIds.next();
                Lifecycle lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
                lifecycle.addPhaseListener((PhaseListener)icePushResourceHandler);
            }
        }

        @Override
        void shutdownMainServlet() {
            this.mainServlet.shutdown();
        }
    }

    private static abstract class AbstractICEpushResourceHandler
    extends ResourceHandlerWrapper
    implements PhaseListener {
        private AbstractICEpushResourceHandler() {
        }

        abstract void initialize(ResourceHandler var1, ServletContext var2, ICEpushResourceHandler var3);

        abstract void shutdownMainServlet();
    }
}

