/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.push.servlet;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class ProxySession
implements HttpSession {
    private static Logger log = Logger.getLogger(ProxySession.class.getName());
    private FacesContext facesContext;
    public static final int APPLICATION_SCOPE = 1;
    public static final int PORTLET_SCOPE = 2;
    private int currentScope = 1;
    private static final Class[] getAttributeParamTypes = new Class[]{String.class, Integer.TYPE};
    private static final Class[] setAttributeParamTypes = new Class[]{String.class, Object.class, Integer.TYPE};
    private static final Class[] getAttributeNamesParamTypes = new Class[]{Integer.TYPE};
    private static final Class[] removeAttributeTypes = new Class[]{String.class};

    public ProxySession(FacesContext facesContext) {
        this(facesContext, 1);
    }

    public ProxySession(FacesContext facesContext, int defaultScope) {
        this.facesContext = facesContext;
        this.currentScope = defaultScope;
    }

    public ServletContext getServletContext() {
        log.severe("ProxySession unsupported operation");
        throw new UnsupportedOperationException();
    }

    public HttpSessionContext getSessionContext() {
        log.severe("ProxySession unsupported operation");
        throw new UnsupportedOperationException();
    }

    public Object getValue(String s) {
        log.severe("ProxySession unsupported operation");
        throw new UnsupportedOperationException();
    }

    public String[] getValueNames() {
        log.severe("ProxySession unsupported operation");
        throw new UnsupportedOperationException();
    }

    public void putValue(String s, Object o) {
        log.severe("ProxySession unsupported operation");
        throw new UnsupportedOperationException();
    }

    public void removeValue(String s) {
        log.severe("ProxySession unsupported operation");
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String key) {
        Object sess = this.facesContext.getExternalContext().getSession(true);
        Class<?> clazz = sess.getClass();
        Object val = null;
        try {
            Method meth = clazz.getMethod("getAttribute", getAttributeParamTypes);
            val = meth.invoke(sess, key, this.currentScope);
        }
        catch (Exception e) {
            Throwable theCause = e.getCause();
            if (theCause != null && theCause instanceof IllegalStateException) {
                throw (IllegalStateException)theCause;
            }
            log.log(Level.WARNING, "could not get attribute " + key + " on PortletSession ", e);
        }
        return val;
    }

    public Enumeration<String> getAttributeNames() {
        Object sess = this.facesContext.getExternalContext().getSession(true);
        Class<?> clazz = sess.getClass();
        Enumeration val = null;
        try {
            Method meth = clazz.getMethod("getAttributeNames", getAttributeNamesParamTypes);
            val = (Enumeration)meth.invoke(sess, this.currentScope);
        }
        catch (Exception e) {
            Throwable theCause = e.getCause();
            if (theCause != null && theCause instanceof IllegalStateException) {
                throw (IllegalStateException)theCause;
            }
            log.log(Level.WARNING, "could not get attribute names from PortletSession ", e);
        }
        return val;
    }

    public Map getAttributesMap() {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        Enumeration<String> names = this.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            attributeMap.put(name, this.getAttribute(name));
        }
        return attributeMap;
    }

    public long getCreationTime() {
        Object sess = this.facesContext.getExternalContext().getSession(true);
        Class<?> clazz = sess.getClass();
        long val = -1L;
        try {
            Method meth = clazz.getMethod("getCreationTime", new Class[0]);
            val = (Long)meth.invoke(sess, new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not get creation time from PortletSession ", e);
        }
        return val;
    }

    public String getId() {
        Object sess = this.facesContext.getExternalContext().getSession(true);
        Class<?> clazz = sess.getClass();
        String val = null;
        try {
            Method meth = clazz.getMethod("getId", new Class[0]);
            val = (String)meth.invoke(sess, new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not get id from PortletSession ", e);
        }
        return val;
    }

    public long getLastAccessedTime() {
        Object sess = this.facesContext.getExternalContext().getSession(true);
        Class<?> clazz = sess.getClass();
        long val = -1L;
        try {
            Method meth = clazz.getMethod("getLastAccessedTime", new Class[0]);
            val = (Long)meth.invoke(sess, new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not get last accessed time from PortletSession ", e);
        }
        return val;
    }

    public int getMaxInactiveInterval() {
        Object sess = this.facesContext.getExternalContext().getSession(true);
        Class<?> clazz = sess.getClass();
        int val = -1;
        try {
            Method meth = clazz.getMethod("getMaxInactiveInterval", new Class[0]);
            val = (Integer)meth.invoke(sess, new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not get maximum inactive interval from PortletSession ", e);
        }
        return val;
    }

    public void invalidate() {
        log.severe("ProxySession unsupported operation");
        throw new UnsupportedOperationException();
    }

    public boolean isNew() {
        Object sess = this.facesContext.getExternalContext().getSession(true);
        Class<?> clazz = sess.getClass();
        boolean val = false;
        try {
            Method meth = clazz.getMethod("isNew", new Class[0]);
            val = (Boolean)meth.invoke(sess, new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not get isNew from PortletSession ", e);
        }
        return val;
    }

    public void removeAttribute(String key) {
        Object sess = this.facesContext.getExternalContext().getSession(true);
        Class<?> clazz = sess.getClass();
        try {
            Method meth = clazz.getMethod("removeAttribute", removeAttributeTypes);
            meth.invoke(sess, key);
        }
        catch (Exception e) {
            Throwable theCause = e.getCause();
            if (theCause != null && theCause instanceof IllegalStateException) {
                throw (IllegalStateException)theCause;
            }
            log.log(Level.WARNING, "could not remove attribute " + key + " on PortletSession ", e);
        }
    }

    public void setAttribute(String key, Object val) {
        Object sess = this.facesContext.getExternalContext().getSession(true);
        Class<?> clazz = sess.getClass();
        try {
            Method meth = clazz.getMethod("setAttribute", setAttributeParamTypes);
            meth.invoke(sess, key, val, 1);
        }
        catch (Exception e) {
            Throwable theCause = e.getCause();
            if (theCause != null && theCause instanceof IllegalStateException) {
                throw (IllegalStateException)theCause;
            }
            log.log(Level.WARNING, "could not set attribute " + key + ", " + val + " on PortletSession ", e);
        }
    }

    public void setMaxInactiveInterval(int i) {
        log.severe("ProxySession unsupported operation");
        throw new UnsupportedOperationException();
    }
}

