/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.renderkit;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitWrapper;
import javax.faces.render.Renderer;
import org.icefaces.application.ProductInfo;
import org.icefaces.impl.context.DOMResponseWriter;
import org.icefaces.impl.event.BridgeFormsSetup;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.impl.renderkit.RendererWrapper;
import org.icefaces.impl.util.FormEndRendering;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

public class DOMRenderKit
extends RenderKitWrapper {
    private static Logger log = Logger.getLogger(DOMRenderKit.class.getName());
    private RenderKit delegate;
    private boolean deltaSubmit;
    private ArrayList<MandatoryResourceComponent> mandatoryResourceComponents = new ArrayList();
    public static final String ACE_THEME_PARAM = "org.icefaces.ace.theme";
    public static final String ACE_HEAD_RENDERER_CLASSNAME = "org.icefaces.ace.renderkit.HeadRenderer";

    public DOMRenderKit(RenderKit delegate) {
        this.delegate = delegate;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.deltaSubmit = EnvUtils.isDeltaSubmit(facesContext);
    }

    public RenderKit getWrapped() {
        return this.delegate;
    }

    private boolean useAceHeadRenderer() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String aceThemeParam = facesContext.getExternalContext().getInitParameter(ACE_THEME_PARAM);
        return aceThemeParam == null || !aceThemeParam.trim().equalsIgnoreCase("none");
    }

    public void addRenderer(String family, String rendererType, Renderer r) {
        Renderer renderer;
        String compClassName;
        Class<?> clazz = r.getClass();
        if (FacesContext.getCurrentInstance().getApplication().getProjectStage().equals((Object)ProjectStage.Development)) {
            for (Class<?> currClass = clazz; currClass != null && !Renderer.class.equals(currClass); currClass = currClass.getSuperclass()) {
                if (currClass.getName().startsWith("com.sun")) continue;
                for (Field field : currClass.getDeclaredFields()) {
                    int m = field.getModifiers();
                    if (Modifier.isStatic(m) && Modifier.isFinal(m)) continue;
                    StringBuilder sb = new StringBuilder().append("For class ").append(clazz.getName());
                    if (currClass != clazz) {
                        sb.append(", in its superclass ").append(currClass.getName());
                    }
                    sb.append(", the field '").append(field.getName()).append("' is not declared 'static final'. Renderer classes must not have instance fields, and must be re-entrant.");
                    log.warning(sb.toString());
                }
            }
        }
        if (ACE_HEAD_RENDERER_CLASSNAME.equals(clazz.getName()) && !this.useAceHeadRenderer()) {
            return;
        }
        MandatoryResourceComponent mrc = clazz.getAnnotation(MandatoryResourceComponent.class);
        if (mrc != null && (compClassName = mrc.value()) != null && compClassName.length() > 0 && !this.mandatoryResourceComponents.contains(mrc)) {
            this.mandatoryResourceComponents.add(mrc);
        }
        Renderer renderer2 = renderer = "javax.faces.Form".equals(family) ? new FormBoost(r) : r;
        if ("javax.faces.Message".equals(family) && "javax.faces.Message".equals(rendererType)) {
            renderer = new MessageRenderer(r);
        } else if ("javax.faces.Messages".equals(family) && "javax.faces.Messages".equals(rendererType)) {
            renderer = new MessagesRenderer(r);
        }
        super.addRenderer(family, rendererType, renderer);
    }

    public Renderer getRenderer(String family, String type) {
        Renderer renderer = this.delegate.getRenderer(family, type);
        if (renderer == null) {
            return renderer;
        }
        return renderer;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String encoding) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter parentWriter = this.delegate.createResponseWriter(writer, contentTypeList, encoding);
        if (facesContext.getPartialViewContext().isPartialRequest()) {
            return parentWriter;
        }
        if (!EnvUtils.isICEfacesView(facesContext)) {
            return parentWriter;
        }
        return new DOMResponseWriter((Writer)parentWriter, parentWriter.getCharacterEncoding(), parentWriter.getContentType());
    }

    public List<MandatoryResourceComponent> getMandatoryResourceComponents() {
        return this.mandatoryResourceComponents;
    }

    static {
        if (log.isLoggable(Level.INFO)) {
            log.info(new ProductInfo().toString());
        }
    }

    private class MessagesRenderer
    extends RendererWrapper {
        private MessagesRenderer(Renderer renderer) {
            super(renderer);
        }

        @Override
        public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", component);
            writer.writeAttribute("id", (Object)component.getClientId(context), "id");
            super.encodeEnd(context, component);
            writer.endElement("div");
        }
    }

    private class MessageRenderer
    extends RendererWrapper {
        private MessageRenderer(Renderer renderer) {
            super(renderer);
        }

        @Override
        public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", component);
            writer.writeAttribute("id", (Object)component.getClientId(context), "id");
            super.encodeEnd(context, component);
            writer.endElement("span");
        }
    }

    private class FormBoost
    extends RendererWrapper {
        private FormBoost(Renderer renderer) {
            super(renderer);
        }

        @Override
        public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
            if (component instanceof BridgeFormsSetup.ShortIdForm) {
                super.encodeEnd(context, component);
                return;
            }
            FormEndRendering.renderIntoForm(context, component);
            if (EnvUtils.isICEfacesView(context)) {
                ResponseWriter writer = context.getResponseWriter();
                if (DOMRenderKit.this.deltaSubmit) {
                    writer.startElement("script", component);
                    writer.writeAttribute("type", (Object)"text/javascript", null);
                    writer.writeText((Object)"ice.calculateInitialParameters('", null);
                    writer.writeText((Object)component.getClientId(context), null);
                    writer.writeText((Object)"');", null);
                    writer.endElement("script");
                }
                super.encodeEnd(context, component);
                if (!EnvUtils.hasHeadAndBodyComponents(context)) {
                    List<UIComponent> bodyResources = BridgeSetup.getBridgeSetup(context).getBodyResources(context);
                    for (UIComponent bodyResource : bodyResources) {
                        bodyResource.encodeBegin(context);
                        bodyResource.encodeEnd(context);
                    }
                }
            } else {
                super.encodeEnd(context, component);
            }
        }
    }
}

