/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.util;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.util.EnvUtils;

public class CharacterEncodingHandler
extends ResourceHandlerWrapper {
    private static Logger log = Logger.getLogger(CharacterEncodingHandler.class.getName());
    private ResourceHandler wrapped;

    public CharacterEncodingHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public boolean isResourceRequest(FacesContext context) {
        if (!EnvUtils.isWebSpherePortal()) {
            this.setCharacterEncoding(context);
        }
        return this.wrapped.isResourceRequest(context);
    }

    private void setCharacterEncoding(FacesContext context) {
        block6: {
            String calculatedEncoding = CharacterEncodingHandler.calculateCharacterEncoding(context);
            if (null != calculatedEncoding) {
                ExternalContext ec = context.getExternalContext();
                String currentEncoding = ec.getRequestCharacterEncoding();
                try {
                    if (!calculatedEncoding.equals(currentEncoding)) {
                        ec.setRequestCharacterEncoding(calculatedEncoding);
                    }
                    break block6;
                }
                catch (UnsupportedEncodingException e) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.warning("can't set encoding to [" + calculatedEncoding + "], current encoding is [" + currentEncoding + "]");
                    }
                    break block6;
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("character encoding could not be determined");
            }
        }
    }

    public static String calculateCharacterEncoding(FacesContext context) {
        ExternalContext extContext = context.getExternalContext();
        Map headerMap = extContext.getRequestHeaderMap();
        String contentType = (String)headerMap.get("Content-Type");
        String charEnc = null;
        if (null == contentType) {
            contentType = (String)headerMap.get("content-type");
        }
        if (null != contentType) {
            String charsetStr = "charset=";
            int len = charsetStr.length();
            int idx = contentType.lastIndexOf(charsetStr);
            if (idx != -1 && idx + len < contentType.length()) {
                charEnc = contentType.substring(idx + len);
            }
        }
        if (null == charEnc && null != extContext.getSession(false)) {
            charEnc = (String)extContext.getSessionMap().get("javax.faces.request.charset");
        }
        return charEnc;
    }
}

