/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class CoreUtils {
    private static Logger log = Logger.getLogger(CoreUtils.class.getName());
    private static Boolean portletEnvironment;

    public static String getRealPath(FacesContext facesContext, String path) {
        Object session;
        if (path == null) {
            path = "";
        }
        if ((session = facesContext.getExternalContext().getSession(false)) == null) {
            log.log(Level.SEVERE, "getRealPath() session is null", new NullPointerException());
            return null;
        }
        if (CoreUtils.isPortletEnvironment()) {
            return CoreUtils.getRealPath(session, "getPortletContext", path);
        }
        return CoreUtils.getRealPath(session, "getServletContext", path);
    }

    private static String getRealPath(Object session, String getContext, String path) {
        try {
            Method getContextMethod = session.getClass().getMethod(getContext, new Class[0]);
            Object context = getContextMethod.invoke(session, new Object[0]);
            Class[] classargs = new Class[]{String.class};
            Method getRealPath = context.getClass().getMethod("getRealPath", classargs);
            Object[] args = new Object[]{path};
            return String.valueOf(getRealPath.invoke(context, args));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error getting realpath", e);
            return null;
        }
    }

    public static String getSessionId(FacesContext facesContext) {
        try {
            Object session = facesContext.getExternalContext().getSession(false);
            if (session == null) {
                log.log(Level.SEVERE, "getSessionId() session is null", new NullPointerException());
                return null;
            }
            Method getIdMethod = session.getClass().getMethod("getId", new Class[0]);
            return String.valueOf(getIdMethod.invoke(session, new Object[0]));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error getting session id", e);
            return null;
        }
    }

    public static boolean isPortletEnvironment() {
        if (portletEnvironment == null) {
            try {
                Class<?> portletRequestClass = Class.forName("javax.portlet.PortletRequest");
                portletEnvironment = new Boolean(portletRequestClass.isInstance(FacesContext.getCurrentInstance().getExternalContext().getRequest()));
            }
            catch (Throwable e) {
                portletEnvironment = Boolean.FALSE;
            }
        }
        return portletEnvironment;
    }

    public static void enableOnElementUpdateNotify(ResponseWriter writer, String id) throws IOException {
        writer.writeAttribute("data-elementupdate", (Object)id, null);
    }
}

