/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class Util {
    private static Logger log = Logger.getLogger(Util.class.getName());
    private static List DEFAULT_EXCLUSIONS = Arrays.asList("application/pdf", "application/zip", "application/x-compress", "application/x-gzip ", "application/java-archive");
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public static Date parseHTTPDate(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.ENGLISH);
        return formatter.parse(date);
    }

    public static String formatHTTPDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.ENGLISH);
        return formatter.format(date);
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1000];
        int l = 1;
        while (l > 0) {
            l = in.read(buf);
            if (l <= 0) continue;
            out.write(buf, 0, l);
        }
        in.close();
        out.close();
    }

    public static int copyStream(InputStream in, OutputStream out, int start, int end) throws IOException {
        long skipped = in.skip(start);
        if ((long)start != skipped) {
            throw new IOException("copyStream failed range start " + start);
        }
        byte[] buf = new byte[1000];
        int pos = start - 1;
        int count = 0;
        int l = 1;
        while (l > 0) {
            l = in.read(buf);
            if (l <= 0) continue;
            if ((pos += l) > end) {
                out.write(buf, 0, l -= pos - end);
                count += l;
                break;
            }
            out.write(buf, 0, l);
            count += l;
        }
        return count;
    }

    public static void compressStream(InputStream in, OutputStream out) throws IOException {
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        Util.copyStream(in, gzip);
        gzip.finish();
    }

    public static boolean acceptGzip(ExternalContext externalContext) {
        String acceptHeader = (String)externalContext.getRequestHeaderMap().get("Accept-Encoding");
        boolean acceptGzip = null != acceptHeader && acceptHeader.indexOf("gzip") >= 0;
        return acceptGzip;
    }

    public static boolean shouldCompress(String contentType) {
        if (contentType == null) {
            return false;
        }
        if (contentType.startsWith("audio/") || contentType.startsWith("video/") || contentType.startsWith("image/")) {
            return false;
        }
        return !DEFAULT_EXCLUSIONS.contains(contentType);
    }

    public static String encodeContentDispositionFilename(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            return null;
        }
        String userAgent = Util.getUserAgent();
        String defaultFileName = "=\"" + fileName + "\"";
        if (userAgent == null || userAgent.trim().length() == 0) {
            return defaultFileName;
        }
        userAgent = userAgent.toLowerCase();
        try {
            if (userAgent.indexOf("msie") > -1) {
                return Util.encodeForIE(fileName);
            }
            if (userAgent.indexOf("firefox") > -1 || userAgent.indexOf("opera") > -1) {
                return Util.encodeForFirefox(fileName);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return defaultFileName;
    }

    private static String encodeForIE(String fileName) throws UnsupportedEncodingException {
        StringBuffer encodedFileName = new StringBuffer();
        encodedFileName.append("=\"");
        encodedFileName.append(URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20"));
        encodedFileName.append("\"");
        return encodedFileName.toString();
    }

    private static String encodeForFirefox(String fileName) throws UnsupportedEncodingException {
        StringBuffer encodedFileName = new StringBuffer();
        encodedFileName.append("*=UTF-8''");
        encodedFileName.append(URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20"));
        return encodedFileName.toString();
    }

    private static String getUserAgent() {
        Map headerMap = FacesContext.getCurrentInstance().getExternalContext().getRequestHeaderMap();
        return (String)headerMap.get("user-agent");
    }
}

