/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.util;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.faces.FactoryFinder;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.context.ExternalContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.icefaces.impl.component.NavigationNotifier;
import org.icefaces.util.EnvUtils;

@ManagedBean(eager=true)
@ApplicationScoped
public class CachingHeaderPhaseListener
implements Serializable {
    @PostConstruct
    private void initialize() {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.addPhaseListener(new PhaseListener(){

            public void afterPhase(PhaseEvent phaseEvent) {
                ExternalContext ec = phaseEvent.getFacesContext().getExternalContext();
                Object responseObj = ec.getResponse();
                boolean avoidAddingHeaders = EnvUtils.instanceofPortletResponse(responseObj) && !EnvUtils.instanceofPortletResourceResponse(responseObj);
                boolean navigationNotifierPresent = ec.getRequestMap().containsKey(NavigationNotifier.class.getName());
                if (!avoidAddingHeaders && !navigationNotifierPresent) {
                    ec.addResponseHeader("Cache-Control", "must-revalidate");
                    ec.addResponseHeader("Pragma", "no-cache");
                    ec.addResponseHeader("Expires", "0");
                }
            }

            public void beforePhase(PhaseEvent phaseEvent) {
            }

            public PhaseId getPhaseId() {
                return PhaseId.RENDER_RESPONSE;
            }
        });
    }
}

