/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.util;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.icefaces.util.EnvUtils;
import org.icefaces.util.UserAgentInfo;

public class ClientDescriptor
implements Serializable {
    private static final String SESSION_KEY = "iceBrowser";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_ACCEPT_BLACKBERRY_EMUL = "vnd.rim";
    private static final String COOKIE_NAME_ICEMOBILE_CONTAINER = "com.icesoft.user-agent";
    private static final String COOKIE_VALUE_ICEMOBILE_CONTAINER = "HyperBrowser";
    private static final String SIMULATOR_KEY = "org.icemobile.simulator";
    private static final String SESSION_KEY_SX_REGISTERED = "sxRegistered";
    private static Logger log = Logger.getLogger(ClientDescriptor.class.getName());
    private String userAgent = "";
    private String httpAccepted;
    private OS os;
    private FORM_FACTOR formFactor;
    private boolean icemobileContainer;
    private boolean sxRegistered;
    private boolean isSimulator = false;
    private UserAgentInfo _userAgentInfo;

    private ClientDescriptor(HttpServletRequest request, String view) {
        this.updateHttpAccepted(request);
        this.updateUserAgent(request);
        this.updateOS();
        this.updateFormFactor(view);
        this.updateICEmobileContainer(request);
        this.updateSXRegistered(request);
        this.updateSimulator(request);
        EnvUtils.getSafeSession(FacesContext.getCurrentInstance()).setAttribute(SESSION_KEY, (Object)this);
    }

    public static ClientDescriptor getInstance(HttpServletRequest request) {
        ClientDescriptor cd = (ClientDescriptor)EnvUtils.getSafeSession(FacesContext.getCurrentInstance()).getAttribute(SESSION_KEY);
        String view = request.getParameter("view");
        if (cd == null || cd.isUserAgentUpdateRequired(request) || view != null) {
            cd = new ClientDescriptor(request, view);
        }
        if (!cd.isSXRegistered()) {
            cd.updateSXRegistered(request);
        }
        if (!cd.isSimulator()) {
            cd.updateSimulator(request);
        }
        return cd;
    }

    private boolean isUserAgentUpdateRequired(HttpServletRequest request) {
        return !this.userAgent.equals(request.getHeader("User-Agent"));
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isHandheldBrowser() {
        return FORM_FACTOR.HANDHELD == this.formFactor;
    }

    public boolean isTabletBrowser() {
        return FORM_FACTOR.TABLET == this.formFactor;
    }

    private void updateOS() {
        if (this._userAgentInfo != null) {
            this.os = this._userAgentInfo.isIOS() ? OS.IOS : (this._userAgentInfo.isAndroidOS() ? OS.ANDROID : (this._userAgentInfo.isBlackberryOS() || this.httpAccepted.contains(HEADER_ACCEPT_BLACKBERRY_EMUL) ? OS.BLACKBERRY : (this._userAgentInfo.isMacOS() ? OS.MAC : (this._userAgentInfo.isWindowsOS() ? OS.WINDOWS : OS.LINUX))));
        }
    }

    public boolean isAndroidOS() {
        return this.os == OS.ANDROID;
    }

    public boolean isBlackBerryOS() {
        return this.os == OS.BLACKBERRY;
    }

    public boolean isBlackBerry10OS() {
        return this._userAgentInfo.isBlackberry10OS();
    }

    public boolean isIEBrowser() {
        return this._userAgentInfo.isIE();
    }

    public boolean isIE8orLessBrowser() {
        return this._userAgentInfo.isIE8orLess();
    }

    public boolean isIE9Browser() {
        return this._userAgentInfo.isIE9();
    }

    public boolean isIE9orLessBrowser() {
        return this._userAgentInfo.isIE9orLess();
    }

    public boolean isIE10Browser() {
        return this._userAgentInfo.isIE10();
    }

    public boolean isIOS() {
        return this.os == OS.IOS;
    }

    public boolean isIOS5() {
        return this.os == OS.IOS && this._userAgentInfo.isIOS5();
    }

    public boolean isIOS6() {
        return this.os == OS.IOS && this._userAgentInfo.isIOS6();
    }

    public boolean isIOS7() {
        return this.os == OS.IOS && this._userAgentInfo.isIOS7();
    }

    public boolean isSXRegistered() {
        return this.sxRegistered;
    }

    public boolean isSimulator() {
        return this.isSimulator;
    }

    public boolean isICEmobileContainer() {
        if (this.isSimulator && this.isDesktopBrowser()) {
            return true;
        }
        return this.icemobileContainer;
    }

    public boolean isEnhancedBrowser() {
        return this.isICEmobileContainer() || this.isSXRegistered();
    }

    public boolean isDesktopBrowser() {
        return this.formFactor == FORM_FACTOR.DESKTOP;
    }

    private void updateUserAgent(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        if (ua == null || ua.length() == 0) {
            log.fine("Could not detect device settings, user agent is null");
        } else {
            this.userAgent = ua;
            this._userAgentInfo = new UserAgentInfo(this.userAgent);
        }
    }

    private void updateHttpAccepted(HttpServletRequest request) {
        String accept = request.getHeader(HEADER_ACCEPT);
        this.httpAccepted = accept == null ? "" : accept.toLowerCase();
    }

    private static Cookie getCookie(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equalsIgnoreCase(name)) continue;
                return cookies[i];
            }
        }
        return null;
    }

    private void updateICEmobileContainer(HttpServletRequest request) {
        Cookie cookie = ClientDescriptor.getCookie(COOKIE_NAME_ICEMOBILE_CONTAINER, request);
        this.icemobileContainer = null != cookie && cookie.getValue().startsWith(COOKIE_VALUE_ICEMOBILE_CONTAINER);
    }

    private static boolean isSXRegistered(HttpServletRequest request) {
        HttpSession session = EnvUtils.getSafeSession(FacesContext.getCurrentInstance());
        return session.getAttribute(SESSION_KEY_SX_REGISTERED) == Boolean.TRUE || session.getAttribute("iceAuxRequestMap") != null;
    }

    private void updateSXRegistered(HttpServletRequest request) {
        this.sxRegistered = ClientDescriptor.isSXRegistered(request);
    }

    private void updateSimulator(HttpServletRequest request) {
        String simulatorSetting;
        HttpSession session = EnvUtils.getSafeSession(FacesContext.getCurrentInstance());
        ServletContext servletContext = null;
        if (null != session) {
            servletContext = EnvUtils.getSafeContext(FacesContext.getCurrentInstance());
            simulatorSetting = (String)session.getAttribute(SIMULATOR_KEY);
            if ("true".equalsIgnoreCase(simulatorSetting)) {
                this.isSimulator = true;
                return;
            }
        }
        if (this.isSimulator) {
            return;
        }
        simulatorSetting = System.getProperty(SIMULATOR_KEY);
        if (simulatorSetting == null) {
            simulatorSetting = request.getParameter("simulator");
        }
        if ("true".equalsIgnoreCase(simulatorSetting)) {
            this.isSimulator = true;
            return;
        }
        if (null != servletContext) {
            simulatorSetting = servletContext.getInitParameter(SIMULATOR_KEY);
        }
        if ("true".equalsIgnoreCase(simulatorSetting)) {
            this.isSimulator = true;
            return;
        }
    }

    private void updateFormFactor(String view) {
        if (this._userAgentInfo != null) {
            this.formFactor = "large".equals(view) || this._userAgentInfo.isTabletBrowser() ? FORM_FACTOR.TABLET : ("small".equals(view) || this._userAgentInfo.isMobileBrowser() ? FORM_FACTOR.HANDHELD : FORM_FACTOR.DESKTOP);
        }
    }

    public boolean isChromeBrowser() {
        return this._userAgentInfo.isChrome();
    }

    public boolean isHasNativeDatePicker() {
        return this.isIOS5() || this.isIOS6() || this.isIOS7() || this.isBlackBerryOS() || this.isChromeBrowser() || this._userAgentInfo.isFirefoxAndroid();
    }

    public boolean isAndroidBrowser() {
        return this._userAgentInfo.isAndroidBrowserOrWebView() && !this.isEnhancedBrowser();
    }

    public boolean isAndroidBrowserOrWebView() {
        return this._userAgentInfo.isAndroidBrowserOrWebView();
    }

    public boolean isAndroid2OS() {
        return this._userAgentInfo.isAndroid2();
    }

    public boolean isSupportsFixedPosition() {
        return !(this.isTabletBrowser() && this.isAndroidBrowserOrWebView() || this.isHandheldBrowser() && this.isAndroid2OS() && !this._userAgentInfo.isFirefoxAndroid() || this._userAgentInfo.isBlackberry6OS() || this._userAgentInfo.isBlackberry10OS() && this.isEnhancedBrowser());
    }

    public static enum FORM_FACTOR {
        HANDHELD,
        TABLET,
        DESKTOP;

    }

    public static enum OS {
        WINDOWS,
        IOS,
        MAC,
        ANDROID,
        BLACKBERRY,
        LINUX;

    }
}

