/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.util;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.resources.BrowserType;
import org.icefaces.util.EnvUtils;
import org.icefaces.util.UserAgentInfo;

public class UserAgentContext
implements Serializable {
    private static Logger log = Logger.getLogger(UserAgentContext.class.getName());
    private static final String SESSION_KEY = "userAgentContext";
    private String userAgent;
    private boolean internetExplorer;
    private boolean internetExplorer7;
    private boolean internetExplorer8;
    private boolean internetExplorer9;
    private boolean internetExplorerOther;
    private boolean internetExplorer8orLower;
    private boolean internetExplorer9orHigher;
    private boolean firefox;
    private boolean safari;
    private boolean chrome;
    private boolean android;
    private boolean ios;
    private OS os;
    private FORM_FACTOR formFactor;

    private UserAgentContext(String userAgent, Map<String, Object> sessionMap) {
        this.userAgent = userAgent;
        UserAgentInfo uaInfo = new UserAgentInfo(userAgent);
        this.detectOS(uaInfo);
        this.detectFormFactor(uaInfo);
        this.detectInternetExplorer(uaInfo);
        this.detectFirefox(uaInfo);
        this.detectSafari(uaInfo);
        this.detectChrome(uaInfo);
        this.detectIOS(uaInfo);
        this.detectAndroid(uaInfo);
        sessionMap.put(SESSION_KEY, this);
    }

    private void detectOS(UserAgentInfo uaInfo) {
        this.os = uaInfo.isIOS() ? OS.IOS : (uaInfo.isAndroidOS() ? OS.ANDROID : (uaInfo.isBlackberryOS() ? OS.BLACKBERRY : (uaInfo.isMacOS() ? OS.MAC : (uaInfo.isWindowsOS() ? OS.WINDOWS : OS.LINUX))));
    }

    private void detectFormFactor(UserAgentInfo uaInfo) {
        this.formFactor = uaInfo.isTabletBrowser() ? FORM_FACTOR.TABLET : (uaInfo.isMobileBrowser() ? FORM_FACTOR.HANDHELD : FORM_FACTOR.DESKTOP);
    }

    private void detectInternetExplorer(UserAgentInfo uaInfo) {
        int ieVersion = uaInfo.getIEVersion();
        if (ieVersion > 0) {
            this.internetExplorer = true;
            this.internetExplorer7 = 7 == ieVersion;
            this.internetExplorer8 = 8 == ieVersion;
            this.internetExplorer9 = 9 == ieVersion;
            this.internetExplorer8orLower = ieVersion < 9;
            this.internetExplorer9orHigher = ieVersion > 8;
            this.internetExplorerOther = !this.internetExplorer7 && !this.internetExplorer8 && !this.internetExplorer9;
        }
    }

    private void detectFirefox(UserAgentInfo uaInfo) {
        this.firefox = uaInfo.isFirefox();
    }

    private void detectSafari(UserAgentInfo uaInfo) {
        this.safari = uaInfo.isSafari();
    }

    private void detectChrome(UserAgentInfo uaInfo) {
        this.chrome = uaInfo.isChrome();
    }

    private void detectAndroid(UserAgentInfo uaInfo) {
        this.android = uaInfo.isAndroidOS();
    }

    private void detectIOS(UserAgentInfo uaInfo) {
        this.ios = uaInfo.isIOS();
    }

    public boolean isHandheldBrowser() {
        return FORM_FACTOR.HANDHELD == this.formFactor;
    }

    public boolean isTabletBrowser() {
        return FORM_FACTOR.TABLET == this.formFactor;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isInternetExplorer() {
        return this.internetExplorer;
    }

    public boolean isInternetExplorer7() {
        return this.internetExplorer7;
    }

    public boolean isInternetExplorer8() {
        return this.internetExplorer8;
    }

    public boolean isInternetExplorer9() {
        return this.internetExplorer9;
    }

    public boolean isInternetExplorerOther() {
        return this.internetExplorerOther;
    }

    public boolean isInternetExplorer8orLower() {
        return this.internetExplorer8orLower;
    }

    public boolean isInternetExplorer9orHigher() {
        return this.internetExplorer9orHigher;
    }

    public boolean isFirefox() {
        return this.firefox;
    }

    public boolean isSafari() {
        return this.safari;
    }

    public boolean isChrome() {
        return this.chrome;
    }

    public boolean isAndroid() {
        return this.android;
    }

    public boolean isIos() {
        return this.ios;
    }

    public OS getOs() {
        return this.os;
    }

    public FORM_FACTOR getFormFactor() {
        return this.formFactor;
    }

    public boolean isBrowserType(BrowserType browserType) {
        if (browserType == BrowserType.ALL) {
            return true;
        }
        if (browserType == BrowserType.ANDROID) {
            return this.isAndroid();
        }
        if (browserType == BrowserType.CHROME) {
            return this.isChrome();
        }
        if (browserType == BrowserType.FIREFOX) {
            return this.isFirefox();
        }
        if (browserType == BrowserType.IE) {
            return this.isInternetExplorer();
        }
        if (browserType == BrowserType.IE7) {
            return this.isInternetExplorer7();
        }
        if (browserType == BrowserType.IE8) {
            return this.isInternetExplorer8();
        }
        if (browserType == BrowserType.IE8_OR_LESS) {
            return this.isInternetExplorer8orLower();
        }
        if (browserType == BrowserType.IE9_OR_GREATER) {
            return this.isInternetExplorer9orHigher();
        }
        if (browserType == BrowserType.IOS) {
            return this.isIos();
        }
        if (browserType == BrowserType.SAFARI) {
            return this.isSafari();
        }
        return false;
    }

    public static UserAgentContext getInstance(FacesContext context) {
        ExternalContext extContext = FacesContext.getCurrentInstance().getExternalContext();
        Map sessionMap = extContext.getSessionMap();
        UserAgentContext uac = (UserAgentContext)sessionMap.get(SESSION_KEY);
        if (uac == null) {
            String userAgent = EnvUtils.getUserAgent(context);
            if (userAgent != null) {
                uac = new UserAgentContext(userAgent, sessionMap);
            } else {
                log.severe("could not get user-agent header");
            }
        }
        return uac;
    }

    public static UserAgentContext getInstance() {
        return UserAgentContext.getInstance(FacesContext.getCurrentInstance());
    }

    public static enum FORM_FACTOR {
        HANDHELD,
        TABLET,
        DESKTOP;

    }

    public static enum OS {
        WINDOWS,
        IOS,
        MAC,
        ANDROID,
        BLACKBERRY,
        LINUX;

    }
}

