if (!window.ice) {
    window.ice = new Object;
}
if (!window.ice.icepush) {
    (function(namespace) {
        window.ice.icepush = true;
        eval(ice.importFrom('ice.lib.functional'));
        eval(ice.importFrom('ice.lib.oo'));
        eval(ice.importFrom('ice.lib.collection'));
        eval(ice.importFrom('ice.lib.string'));
        eval(ice.importFrom('ice.lib.delay'));
        eval(ice.importFrom('ice.lib.cookie'));
        eval(ice.importFrom('ice.lib.window'));
        eval(ice.importFrom('ice.lib.event'));
        eval(ice.importFrom('ice.lib.element'));
        eval(ice.importFrom('ice.lib.logger'));
        eval(ice.importFrom('ice.lib.query'));
        eval(ice.importFrom('ice.lib.http'));
        eval(ice.importFrom('ice.lib.configuration'));
        var ffMatch = navigator.userAgent.match(/Firefox\/(\w\.?\w)/);
        var firefoxGreaterThan3point6 = ffMatch ? (Number(ffMatch[1]) > 3.6) : true;
        function useLocalStorage() {
            return window.localStorage && firefoxGreaterThan3point6;
        }
var register = operator();
var deserializeAndExecute = operator();
function CommandDispatcher() {
    var commands = [];
    return object(function(method) {
        method(register, function(self, messageName, command) {
            commands = reject(commands, function(cell) {
                return key(cell) == messageName;
            });
            append(commands, Cell(messageName, command));
        });
        method(deserializeAndExecute, function(self, message) {
            var messageName = message.nodeName;
            var found = detect(commands, function(cell) {
                return key(cell) == messageName;
            }, function() {
                throw 'Unknown message received: ' + messageName;
            });
            value(found)(message);
        });
    });
}
function NoopCommand() {
    debug(namespace.logger, 'received noop');
}
function ParsingError(message) {
    logger.error('Parsing error');
    var errorNode = message.firstChild;
    logger.error(errorNode.data);
    var sourceNode = errorNode.firstChild;
    logger.error(sourceNode.data);
}
function Macro(dispatcher) {
    return function(message) {
        each(message.childNodes, curry(deserializeAndExecute, dispatcher));
    };
}
var setValue = operator();
var getValue = operator();
var existsSlot;
var removeSlot;
var lookupSlot;
var Slot;
(function () {
    if (window.localStorage) {
        Slot = function LocalStorageSlot(name, val) {
            window.localStorage.setItem(name, window.localStorage.getItem(name) || '');
            return object(function(method) {
                method(getValue, function(self) {
                    var val = window.localStorage.getItem(name);
                    return val ? val : '';
                });
                method(setValue, function(self, val) {
                    window.localStorage.setItem(name, val || '');
                });
            });
        };
        existsSlot = function(name) {
            return window.localStorage.getItem(name) != null;
        };
        removeSlot = function(name) {
            window.localStorage.removeItem(name);
        };
    } else {
        Slot = function CookieSlot(name, val) {
            var c = existsCookie(name) ? lookupCookie(name) : Cookie(name, val);
            return object(function(method) {
                method(getValue, function(self) {
                    try {
                        return value(c);
                    } catch (e) {
                        c = Cookie(name, '');
                        return '';
                    }
                });
                method(setValue, function(self, val) {
                    try {
                        update(c, val);
                    } catch (e) {
                        c = Cookie(name, val);
                    }
                });
            });
        };
        existsSlot = existsCookie;
        removeSlot = function(name) {
            if (existsCookie(name)) {
                remove(lookupCookie(name));
            }
        }
    }
}());
var send = operator();
var onSend = operator();
var onReceive = operator();
var onServerError = operator();
var whenDown = operator();
var whenTrouble = operator();
var whenReEstablished = operator();
var startConnection = operator();
var resumeConnection = operator();
var pauseConnection = operator();
var controlRequest = operator();
var changeHeartbeatInterval = operator();
var shutdown = operator();
var AsyncConnection;
(function() {
    var HeartbeatInterval = 'ice.push.heartbeat';
    var ConnectionRunning = 'ice.connection.running';
    var ConnectionLease = 'ice.connection.lease';
    var ConnectionContextPath = 'ice.connection.contextpath';
    var AcquiredMarker = ':acquired';
    var NetworkDelay = 5000;
    function timedRetryAbort(retryAction, abortAction, timeouts) {
        var index = 0;
        var errorActions = inject(timeouts, [abortAction], function(actions, interval) {
            return insert(actions, curry(runOnce, Delay(retryAction, interval)));
        });
        return function() {
            if (index < errorActions.length) {
                apply(errorActions[index], arguments);
                index++;
            }
        };
    }
    AsyncConnection = function(logger, windowID, configuration) {
        var logger = childLogger(logger, 'async-connection');
        var channel = Client(false);
        var onSendListeners = [];
        var onReceiveListeners = [];
        var onServerErrorListeners = [];
        var connectionDownListeners = [];
        var connectionTroubleListeners = [];
        var connectionReEstablished = [];
        var listener = object(function(method) {
            method(close, noop);
            method(abort, noop);
        });
        var listening = object(function(method) {
            method(remove, noop);
        });
        onBeforeUnload(window, function() {
            connectionDownListeners = [];
        });
        try {
            removeSlot(ConnectionRunning);
        } catch (e) {
        }
        var browserID = Slot(BrowserIDName);
        var lastSentPushIds = registeredPushIds();
        function contextPath() {
            return namespace.push.configuration.contextPath;
        }
        function askForConfiguration(query) {
            if (getValue(browserID)) {
                parameter(query, 'ice.sendConfiguration', '');
                askForConfiguration = noop;
            }
        }
        function requestForBlockingResponse() {
            try {
                debug(logger, "closing previous connection...");
                close(listener);
                setValue(contextPathSlot, contextPath());
                lastSentPushIds = registeredPushIds();
                if (isEmpty(lastSentPushIds)) {
                    offerCandidature();
                } else {
                    debug(logger, 'connect...');
                    var uri = resolveURI(namespace.push.configuration.blockingConnectionURI);
                    listener = postAsynchronously(channel, uri, function(q) {
                        parameter(q, BrowserIDName, getValue(browserID));
                        parameter(q, WindowID, namespace.windowID);
                        parameter(q, APIKey, ice.push.configuration.apikey);
                        parameter(q, AccessToken, ice.push.configuration.access_token);
                        parameter(q, Realm, ice.push.configuration.realm);
                        parameter(q, HeartbeatInterval, heartbeatTimeout - NetworkDelay);
                        each(lastSentPushIds, curry(parameter, q, PushID));
                        broadcast(onSendListeners, [q]);
                        askForConfiguration(q);
                    }, FormPost, $witch(function (condition) {
                        condition(OK, function(response) {
                            var reconnect = getHeader(response, 'X-Connection') != 'close';
                            var nonEmptyResponse = notEmpty(contentAsText(response));
                            if (reconnect) {
                                if (nonEmptyResponse) {
                                    broadcast(onReceiveListeners, [response]);
                                    resetEmptyResponseRetries();
                                } else {
                                    warn(logger, 'empty response received');
                                    decrementEmptyResponseRetries();
                                }
                                if (anyEmptyResponseRetriesLeft()) {
                                    resetTimeoutBomb();
                                    connect();
                                } else {
                                    info(logger, 'blocking connection stopped, too many empty responses received...');
                                }
                            } else {
                                info(logger, 'blocking connection stopped at server\'s request...');
                                var reason = getHeader(response, 'X-Connection-reason');
                                if (reason) {
                                    info(logger, reason);
                                }
                                stopTimeoutBombs();
                            }
                        });
                        condition(ServerInternalError, retryOnServerError);
                    }));
                }
            } catch (e) {
                error(logger, 'failed to re-initiate blocking connection', e);
            }
        }
        var connect = requestForBlockingResponse;
        var retryTimeouts = collect(split(attributeAsString(configuration, 'serverErrorRetryTimeouts', '1000 2000 4000'), ' '), Number);
        var retryOnServerError = timedRetryAbort(connect, broadcaster(onServerErrorListeners), retryTimeouts);
        var heartbeatTimeout = attributeAsNumber(configuration, 'heartbeatTimeout', 15000) + NetworkDelay;
        var emptyResponseRetries;
        function resetEmptyResponseRetries() {
            emptyResponseRetries = attributeAsNumber(configuration, 'emptyResponseRetries', 3);
        }
        function decrementEmptyResponseRetries() {
            --emptyResponseRetries;
        }
        function anyEmptyResponseRetriesLeft() {
            return emptyResponseRetries > 0;
        }
        resetEmptyResponseRetries();
        var NoopDelay = object(function(method) {
            method(runOnce, function(self) {
                return self;
            });
            method(stop, noop);
        });
        var pendingTimeoutThunks = [];
        var timeoutThunks = [
            function() {
                warn(logger, 'failed to connect, first retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                warn(logger, 'failed to connect, second retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                warn(logger, 'failed to connect, 3 retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                warn(logger, 'failed to connect, 4 retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                warn(logger, 'failed to connect, 5 retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                warn(logger, 'failed to connect, 6 retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                warn(logger, 'failed to connect, 7 retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                warn(logger, 'failed to connect, 8 retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                warn(logger, 'failed to connect, 9 retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                warn(logger, 'failed to connect, 10 retry...');
                broadcast(connectionTroubleListeners);
                connect();
            },
            function() {
                broadcast(connectionDownListeners);
            }
        ];
        var stopTimeoutBombs = noop;
        function chainTimeoutBombs(thunks, interval) {
            stopTimeoutBombs();
            var remainingThunks = copy(thunks);
            function startTimeoutBombs() {
                var run = true;
                var timeoutBomb = runOnce(inject(reverse(thunks), NoopDelay, function(result, thunk) {
                    return Delay(function() {
                        if (run) {
                            remainingThunks.length = remainingThunks.length - 1;
                            thunk();
                            timeoutBomb = runOnce(result);
                        }
                    }, interval);
                }));
                return function() {
                    stop(timeoutBomb);
                    run = false;
                }
            }
            stopTimeoutBombs = startTimeoutBombs();
            return remainingThunks;
        }
        function resetTimeoutBomb() {
            pendingTimeoutThunks = chainTimeoutBombs(timeoutThunks, heartbeatTimeout);
        }
        function adjustTimeoutInterval() {
            pendingTimeoutThunks = chainTimeoutBombs(pendingTimeoutThunks, heartbeatTimeout);
        }
        function initializeConnection() {
            info(logger, 'initialize connection within window ' + namespace.windowID);
            resetTimeoutBomb();
            connect();
        }
        var pollingPeriod = 1000;
        var leaseSlot = Slot(ConnectionLease, asString((new Date).getTime()));
        var connectionSlot = listening = Slot(ConnectionRunning, '');
        var contextPathSlot = Slot(ConnectionContextPath, contextPath());
        function updateLease() {
            setValue(leaseSlot, (new Date).getTime() + pollingPeriod * 2);
        }
        function isLeaseExpired() {
            return asNumber(getValue(leaseSlot)) < (new Date).getTime();
        }
        function shouldEstablishBlockingConnection() {
            return !existsSlot(ConnectionRunning) || isEmpty(getValue(connectionSlot));
        }
        function offerCandidature() {
            setValue(connectionSlot, windowID);
        }
        function isWinningCandidate() {
            return startsWith(getValue(connectionSlot), windowID);
        }
        function markAsOwned() {
            setValue(connectionSlot, windowID + AcquiredMarker);
        }
        function isOwner() {
            return getValue(connectionSlot) == (windowID + AcquiredMarker);
        }
        function hasOwner() {
            return endsWith(getValue(connectionSlot), AcquiredMarker);
        }
        function owner() {
            var owner = getValue(connectionSlot);
            var i = indexOf(owner, AcquiredMarker);
            return i > -1 ? substring(owner, 0, i) : owner;
        }
        function nonMatchingContextPath() {
            return getValue(contextPathSlot) != contextPath();
        }
        if (nonMatchingContextPath()) {
            offerCandidature();
            info(logger, 'Blocking connection cannot be shared among multiple web-contexts.\nInitiating blocking connection for "' + contextPath() + '"  web-context...');
        }
        var lastOwningWindow = '';
        var paused = false;
        var blockingConnectionMonitor = object(function(method) {
            method(stop, noop);
        });
        function createBlockingConnectionMonitor() {
            blockingConnectionMonitor = run(Delay(function() {
                if (shouldEstablishBlockingConnection()) {
                    offerCandidature();
                    info(logger, 'blocking connection not initialized...candidate for its creation');
                } else {
                    if (isWinningCandidate()) {
                        if (!hasOwner()) {
                            markAsOwned();
                            if (notEmpty(registeredPushIds())) {
                                initializeConnection();
                            } else {
                                stopTimeoutBombs();
                            }
                        }
                        updateLease();
                    }
                    if (hasOwner() && isLeaseExpired()) {
                        offerCandidature();
                        info(logger, 'blocking connection lease expired...candidate for its creation');
                    }
                }
                if (isOwner()) {
                    var ids = registeredPushIds();
                    if ((size(ids) != size(lastSentPushIds)) || notEmpty(complement(ids, lastSentPushIds))) {
                        abort(listener);
                        connect();
                    }
                } else {
                    stopTimeoutBombs();
                    abort(listener);
                }
                var currentlyOwningWindow = getValue(connectionSlot);
                if (hasOwner()) {
                    if (lastOwningWindow != currentlyOwningWindow) {
                        lastOwningWindow = currentlyOwningWindow;
                        broadcast(connectionReEstablished, [ owner() ]);
                    }
                } else {
                    lastOwningWindow = '';
                }
            }, pollingPeriod));
        }
        return object(function(method) {
            method(onSend, function(self, callback) {
                append(onSendListeners, callback);
            });
            method(onReceive, function(self, callback) {
                append(onReceiveListeners, callback);
            });
            method(onServerError, function(self, callback) {
                append(onServerErrorListeners, callback);
            });
            method(whenDown, function(self, callback) {
                append(connectionDownListeners, callback);
            });
            method(whenTrouble, function(self, callback) {
                append(connectionTroubleListeners, callback);
            });
            method(whenReEstablished, function(self, callback) {
                append(connectionReEstablished, callback);
            });
            method(startConnection, function(self) {
                createBlockingConnectionMonitor();
                info(logger, 'connection monitoring started within window ' + namespace.windowID);
                paused = false;
            });
            method(resumeConnection, function(self) {
                if (paused) {
                    connect = requestForBlockingResponse;
                    initializeConnection();
                    createBlockingConnectionMonitor();
                    paused = false;
                }
            });
            method(pauseConnection, function(self) {
                if (not(paused)) {
                    abort(listener);
                    stop(blockingConnectionMonitor);
                    stopTimeoutBombs();
                    connect = noop;
                    paused = true;
                }
            });
            method(controlRequest, function(self, parameterCallback, headerCallback, responseCallback) {
                if (paused) {
                    var uri = resolveURI(namespace.push.configuration.blockingConnectionURI);
                    postAsynchronously(channel, uri, function(q) {
                        parameter(q, WindowID, namespace.windowID);
                        each(lastSentPushIds, curry(parameter, q, PushID));
                        parameterCallback(curry(parameter, q));
                    }, function(request) {
                        FormPost(request);
                        headerCallback(curry(setHeader, request));
                    }, $witch(function (condition) {
                        condition(OK, function(response) {
                            responseCallback(curry(getHeader, response), contentAsText(response), contentAsDOM(response));
                        });
                        condition(ServerInternalError, function() {
                            throw statusText(response);
                        });
                    }));
                } else {
                    throw 'Cannot make a request while the blocking connection is running.';
                }
            });
            method(changeHeartbeatInterval, function(self, interval) {
                heartbeatTimeout = interval + NetworkDelay;
                adjustTimeoutInterval();
            });
            method(shutdown, function(self) {
                try {
                    method(shutdown, noop);
                    connect = noop;
                    resetTimeoutBomb = noop;
                } catch (e) {
                    error(logger, 'error during shutdown', e);
                } finally {
                    onReceiveListeners = connectionDownListeners = onServerErrorListeners = [];
                    abort(listener);
                    stopTimeoutBombs();
                    stop(blockingConnectionMonitor);
                    removeSlot(listening);
                }
            });
        });
    };
})();
var notifyWindows = operator();
var disposeBroadcast = operator();
function LocalStorageNotificationBroadcaster(name, callback) {
    if (!window.localStorage.getItem(name)) {
        window.localStorage.setItem(name, '');
    }
    var oldValue = window.localStorage.getItem(name);
    function storageListener() {
        var newValue = window.localStorage.getItem(name);
        try {
            if (oldValue != newValue) {
                callback(split(newValue, ' '));
            }
        } finally {
            oldValue = newValue;
        }
    }
    if (window.addEventListener) {
        window.addEventListener('storage', storageListener, false);
    } else {
        document.attachEvent('onstorage', storageListener);
    }
    return object(function(method) {
        method(notifyWindows, function(self, newValue) {
            window.localStorage.setItem(name, join(newValue, ' ') + ' ' + Math.random());
            if (!/MSIE/.test(navigator.userAgent)) {
                callback(newValue);
            }
        });
        method(disposeBroadcast, noop);
    });
}
function CookieBasedNotificationBroadcaster(name, callback) {
    var notifiedPushIDs = lookupCookie(name, function() {
        return Cookie(name, '');
    });
    var notificationMonitor = run(Delay(function() {
        try {
            var ids = split(value(notifiedPushIDs), ' ');
            if (notEmpty(ids)) {
                var notifiedIDs = callback(ids);
                update(notifiedPushIDs, join(complement(ids, notifiedIDs), ' '));
            }
        } catch (e) {
            warn(namespace.logger, 'failed to listen for updates', e);
        }
    }, 300));
    return object(function(method) {
        method(notifyWindows, function(self, receivedPushIDs) {
            var ids = split(value(notifiedPushIDs), ' ');
            update(notifiedPushIDs, join(asSet(concatenate(ids, receivedPushIDs)), ' '));
        });
        method(disposeBroadcast, function(self) {
            stop(notificationMonitor);
        });
    });
}
var testLiveliness = operator();
var PushIDLiveliness;
(function () {
    if (useLocalStorage()) {
        PushIDLiveliness = function LocalStoragePushIDLiveliness(pushIdentifiers) {
            var notificationResponsivness = {};
            var testChannel = "ice.push.liveliness";
            var testLivelinessBroadcaster = LocalStorageNotificationBroadcaster(testChannel, function () {
                notifyWindows(confirmLivelinessBroadcaster, pushIdentifiers());
            });
            var confirmationChannel = "ice.push.confirm";
            var confirmLivelinessBroadcaster = LocalStorageNotificationBroadcaster(confirmationChannel, function (confirmedIDs) {
                each(confirmedIDs, function (id) {
                    var count = notificationResponsivness[id];
                    if (count) {
                        notificationResponsivness[id] = count - 1;
                    } else {
                        delete notificationResponsivness[id];
                    }
                });
            });
            return object(function (method) {
                method(testLiveliness, function (self, ids) {
                    var discardUnresponsiveIds = [];
                    for (var id in notificationResponsivness) {
                        if (notificationResponsivness.hasOwnProperty(id)) {
                            if (not(contains(ids, id))) {
                                append(discardUnresponsiveIds, id);
                            }
                        }
                    }
                    each(discardUnresponsiveIds, function (id) {
                        delete notificationResponsivness[id];
                    });
                    each(ids, function (id) {
                        var count = notificationResponsivness[id];
                        if (count) {
                            notificationResponsivness[id] = count + 1;
                        } else {
                            notificationResponsivness[id] = 1;
                        }
                    });
                    notifyWindows(testLivelinessBroadcaster, ids);
                    return notificationResponsivness;
                });
            });
        }
    } else {
        PushIDLiveliness = function NoOpPushIDLiveliness() {
            return object(function (method) {
                method(testLiveliness, function (self, ids) {
                    return {};
                });
            });
        }
    }
})();
        var notificationListeners = [];
        namespace.onNotification = function(callback) {
            append(notificationListeners, callback);
        };
        var serverErrorListeners = [];
        namespace.onBlockingConnectionServerError = function(callback) {
            append(serverErrorListeners, callback);
        };
        var blockingConnectionUnstableListeners = [];
        namespace.onBlockingConnectionUnstable = function(callback) {
            append(blockingConnectionUnstableListeners, callback);
        };
        var blockingConnectionLostListeners = [];
        namespace.onBlockingConnectionLost = function(callback) {
            append(blockingConnectionLostListeners, callback);
        };
        var blockingConnectionReEstablishedListeners = [];
        namespace.onBlockingConnectionReEstablished = function(callback) {
            append(blockingConnectionReEstablishedListeners, callback);
        };
        var PushID = 'ice.pushid';
        var PushIDs = 'ice.pushids';
        var BrowserIDName = 'ice.push.browser';
        var WindowID = 'ice.push.window';
        var APIKey = "ice.push.apikey";
        var AccessToken = "ice.push.access_token";
        var Realm = "ice.push.realm";
        var NotifiedPushIDs = 'ice.notified.pushids';
        var HeartbeatTimestamp = 'ice.push.heartbeatTimestamp';
        var SequenceNumber = 'ice.push.sequence';
        var handler = window.console ? ConsoleLogHandler(debug) : WindowLogHandler(debug, window.location.href);
        namespace.windowID = namespace.windowID || substring(Math.random().toString(16), 2, 7);
        namespace.logger = Logger([ 'icepush' ], handler);
        namespace.info = info;
        var pushIdentifiers = [];
        function registeredWindowPushIds() {
            return pushIdentifiers;
        }
        var pushIDsSlot = Slot(PushIDs);
        function registeredPushIds() {
            try {
                return split(getValue(pushIDsSlot), ' ');
            } catch (e) {
                return [];
            }
        }
        function enlistPushIDsWithBrowser(ids) {
            var registeredIDs = split(getValue(pushIDsSlot), ' ');
            setValue(pushIDsSlot, join(asSet(concatenate(registeredIDs, ids)), ' '));
        }
        function delistPushIDsWithBrowser(ids) {
            if (existsSlot(PushIDs)) {
                var registeredIDs = split(getValue(pushIDsSlot), ' ');
                setValue(pushIDsSlot, join(complement(registeredIDs, ids), ' '));
            }
        }
        function enlistPushIDsWithWindow(ids) {
            enlistPushIDsWithBrowser(ids);
            pushIdentifiers = concatenate(pushIdentifiers, ids);
        }
        function delistPushIDsWithWindow(ids) {
            delistPushIDsWithBrowser(ids);
            pushIdentifiers = complement(pushIdentifiers, ids);
        }
        function throwServerError(response) {
            throw 'Server internal error: ' + contentAsText(response);
        }
        function resolveURI(path) {
            if (contains(path, "http://") || contains(path, "https://")) {
                return path;
            }
            var contextPath = namespace.push.configuration.contextPath;
            if (startsWith(path, contextPath)) {
                return path;
            }
            if (contextPath) {
                if (endsWith(contextPath, '/')) {
                    contextPath = substring(contextPath, 0, size(contextPath) - 1);
                }
            } else {
                var pathName = window.location.pathname;
                try {
                    var i = lastIndexOf(pathName, '/');
                    contextPath = substring(pathName, 0, i);
                } catch (e) {
                    contextPath = pathName;
                }
            }
            return contextPath + '/' + path;
        }
        function isXMLResponse(response) {
            var mimeType = getHeader(response, 'Content-Type');
            return mimeType && startsWith(mimeType, 'text/xml');
        }
        function parameter(query, name, value) {
            var prefix = namespace.push.configuration.parameterPrefix;
            if (prefix) {
                name = prefix + name;
            }
            addNameValue(query, name, value);
        }
        var commandDispatcher = CommandDispatcher();
        register(commandDispatcher, 'parsererror', ParsingError);
        register(commandDispatcher, 'macro', Macro(commandDispatcher));
        var browserID = Slot(BrowserIDName);
        try {
            setValue(browserID, lookupCookieValue(BrowserIDName));
        } catch (ex) {
        }
        register(commandDispatcher, 'browser', function(message) {
            setValue(browserID, message.getAttribute('id'));
        });
        var currentNotifications = [];
        var apiChannel = Client(true);
        namespace.uriextension = '';
        namespace.push = {
            register: function(pushIds, callback) {
                if ((typeof callback) == 'function') {
                    enlistPushIDsWithWindow(pushIds);
                    namespace.onNotification(function(ids) {
                        currentNotifications = asArray(intersect(ids, pushIds));
                        if (notEmpty(currentNotifications)) {
                            try {
                                callback(currentNotifications);
                            } catch (e) {
                                error(namespace.logger, 'error thrown by push notification callback', e);
                            }
                        }
                    });
                } else {
                    throw 'the callback is not a function';
                }
            },
            deregister: delistPushIDsWithWindow,
            getCurrentNotifications: function() {
                return currentNotifications;
            },
            createPushId: function(retries) {
                var id;
                var uri = resolveURI(namespace.push.configuration.createPushIdURI || 'create-push-id.icepush');
                postSynchronously(apiChannel, uri, function (query) {
                    parameter(query, BrowserIDName, getValue(browserID));
                    parameter(query, APIKey, ice.push.configuration.apikey);
                    parameter(query, AccessToken, ice.push.configuration.access_token);
                    parameter(query, Realm, ice.push.configuration.realm);
                }, FormPost, $witch(function (condition) {
                    condition(OK, function(response) {
                        if (isXMLResponse(response)) {
                            if (retries && retries > 1) {
                                error(namespace.logger, 'failed to set ice.push.browser cookie');
                                return;
                            }
                            deserializeAndExecute(commandDispatcher, contentAsDOM(response).documentElement);
                            retries = retries ? retries + 1 : 1;
                            id = namespace.push.createPushId(retries);
                        } else {
                            id = contentAsText(response);
                        }
                    });
                    condition(ServerInternalError, throwServerError);
                }));
                return id;
            },
            notify: function(group, options) {
                var uri = resolveURI(namespace.push.configuration.notifyURI || 'notify.icepush');
                postAsynchronously(apiChannel, uri, function(q) {
                    parameter(q, BrowserIDName, getValue(browserID));
                    parameter(q, APIKey, ice.push.configuration.apikey);
                    parameter(q, AccessToken, ice.push.configuration.access_token);
                    parameter(q, Realm, ice.push.configuration.realm);
                    parameter(q, 'group', group);
                    if (options) {
                        if (!options.duration) {
                            options.duration = 0;
                        }
                        if (!options.delay) {
                            options.delay = 0;
                        }
                        for (var name in options) {
                            if (options.hasOwnProperty(name)) {
                                var value = options[name];
                                if (name == 'delay') {
                                    parameter(q, 'delay', value);
                                } else if (name == 'at') {
                                    parameter(q, 'at', value);
                                } else if (name == 'duration') {
                                    parameter(q, 'duration', value);
                                } else {
                                    parameter(q, 'option', name + '=' + value);
                                }
                            }
                        }
                    }
                }, FormPost, $witch(function(condition) {
                    condition(ServerInternalError, throwServerError);
                }));
            },
            addGroupMember: function(group, id) {
                var uri = resolveURI(namespace.push.configuration.addGroupMemberURI || 'add-group-member.icepush');
                postAsynchronously(apiChannel, uri, function(q) {
                    parameter(q, BrowserIDName, getValue(browserID));
                    parameter(q, APIKey, ice.push.configuration.apikey);
                    parameter(q, AccessToken, ice.push.configuration.access_token);
                    parameter(q, Realm, ice.push.configuration.realm);
                    parameter(q, 'group', group);
                    parameter(q, 'id', id);
                }, FormPost, $witch(function(condition) {
                    condition(ServerInternalError, throwServerError);
                }));
            },
            removeGroupMember: function(group, id) {
                var uri = resolveURI(namespace.push.configuration.removeGroupMemberURI || 'remove-group-member.icepush');
                postAsynchronously(apiChannel, uri, function(q) {
                    parameter(q, BrowserIDName, getValue(browserID));
                    parameter(q, APIKey, ice.push.configuration.apikey);
                    parameter(q, AccessToken, ice.push.configuration.access_token);
                    parameter(q, Realm, ice.push.configuration.realm);
                    parameter(q, 'group', group);
                    parameter(q, 'id', id);
                }, FormPost, $witch(function(condition) {
                    condition(ServerInternalError, throwServerError);
                }));
            },
            get: function(uri, parameters, responseCallback) {
                getAsynchronously(apiChannel, uri, function(query) {
                    parameter(query, BrowserIDName, getValue(browserID));
                    parameter(query, APIKey, ice.push.configuration.apikey);
                    parameter(query, AccessToken, ice.push.configuration.access_token);
                    parameter(query, Realm, ice.push.configuration.realm);
                    parameters(curry(parameter, query));
                }, noop, $witch(function(condition) {
                    condition(OK, function(response) {
                        responseCallback(statusCode(response), contentAsText(response), contentAsDOM(response));
                    });
                    condition(ServerInternalError, throwServerError);
                }));
            },
            post: function(uri, parameters, responseCallback) {
                postAsynchronously(apiChannel, uri, function(query) {
                    parameter(query, BrowserIDName, getValue(browserID));
                    parameter(query, APIKey, ice.push.configuration.apikey);
                    parameter(query, AccessToken, ice.push.configuration.access_token);
                    parameter(query, Realm, ice.push.configuration.realm);
                    parameters(curry(parameter, query));
                }, FormPost, $witch(function(condition) {
                    condition(OK, function(response) {
                        responseCallback(statusCode(response), contentAsText(response), contentAsDOM(response));
                    });
                    condition(ServerInternalError, throwServerError);
                }));
            },
            searchAndEvaluateScripts: function(element) {
                each(element.getElementsByTagName('script'), function(script) {
                    var newScript = document.createElement('script');
                    newScript.setAttribute('type', 'text/javascript');
                    if (script.src) {
                        newScript.src = script.src;
                    } else {
                        newScript.text = script.text;
                    }
                    element.appendChild(newScript);
                });
            },
            configuration: {
                contextPath: '.',
                blockingConnectionURI: 'listen.icepush',
                apikey: '',
                realm: '',
                access_token: ''
            }
        };
        function Bridge() {
            var windowID = namespace.windowID;
            var logger = childLogger(namespace.logger, windowID);
            var sequenceNo = 0;
            var heartbeatTimestamp;
            var publicConfiguration = namespace.push.configuration;
            var configurationElement = document.documentElement;
            var configuration = XMLDynamicConfiguration(function() {
                return configurationElement;
            });
            var pushIdLiveliness = PushIDLiveliness(registeredWindowPushIds);
            var asyncConnection = AsyncConnection(logger, windowID, configuration);
            register(commandDispatcher, 'configuration', function(message) {
                configurationElement = message;
                publicConfiguration.contextPath = attributeAsString(configuration, 'contextPath', publicConfiguration.contextPath);
                publicConfiguration.blockingConnectionURI = attributeAsString(configuration, 'blockingConnectionURI', publicConfiguration.blockingConnectionURI || 'listen.icepush');
                changeHeartbeatInterval(asyncConnection, attributeAsNumber(configuration, 'heartbeatTimeout', 15000));
            });
            register(commandDispatcher, 'back-off', function(message) {
                debug(logger, 'received back-off');
                var delay = asNumber(message.getAttribute('delay'));
                try {
                    pauseConnection(asyncConnection);
                } finally {
                    runOnce(Delay(function() {
                        resumeConnection(asyncConnection);
                    }, delay));
                }
            });
            function purgeNonRegisteredPushIDs(ids) {
                var registeredIDs = split(getValue(pushIDsSlot), ' ');
                return intersect(ids, registeredIDs);
            }
            function selectWindowNotifications(ids) {
                try {
                    var windowPushIDs = asArray(intersect(ids, pushIdentifiers));
                    if (notEmpty(windowPushIDs)) {
                        broadcast(notificationListeners, [ windowPushIDs ]);
                        debug(logger, 'picked up notifications for this window: ' + windowPushIDs);
                        return windowPushIDs;
                    } else {
                        return [];
                    }
                } catch (e) {
                    warn(logger, 'failed to listen for updates', e);
                    return [];
                }
            }
            function removeUnusedPushIDs() {
                var unresponsivePushIds = testLiveliness(pushIdLiveliness, registeredPushIds());
                var ids = [];
                for (var p in unresponsivePushIds) {
                    if (unresponsivePushIds.hasOwnProperty(p) && unresponsivePushIds[p] > 3) {
                        append(ids, p);
                    }
                }
                if (notEmpty(ids)) {
                    info(logger, 'expirying unused ids: ' + ids);
                    delistPushIDsWithBrowser(ids);
                }
            }
            var notificationBroadcaster = useLocalStorage() ?
                LocalStorageNotificationBroadcaster(NotifiedPushIDs, selectWindowNotifications) : CookieBasedNotificationBroadcaster(NotifiedPushIDs, selectWindowNotifications);
            register(commandDispatcher, 'noop', removeUnusedPushIDs);
            register(commandDispatcher, 'notified-pushids', function(message) {
                var text = message.firstChild;
                if (text && !blank(text.data)) {
                    var receivedPushIDs = split(text.data, ' ');
                    debug(logger, 'received notifications: ' + receivedPushIDs);
                    notifyWindows(notificationBroadcaster, purgeNonRegisteredPushIDs(asSet(receivedPushIDs)));
                    removeUnusedPushIDs();
                } else {
                    warn(logger, "No notification was received.");
                }
            });
            function dispose() {
                try {
                    info(logger, 'shutting down bridge...');
                    dispose = noop;
                    disposeBroadcast(notificationBroadcaster);
                } finally {
                    shutdown(asyncConnection);
                }
            }
            onUnload(window, dispose);
            onSend(asyncConnection, function(query) {
                if(sequenceNo){
                    parameter(query, SequenceNumber, sequenceNo);
                }
                if (heartbeatTimestamp) {
                    parameter(query, HeartbeatTimestamp, heartbeatTimestamp);
                }
            });
            onReceive(asyncConnection, function(response) {
                if (isXMLResponse(response)) {
                    deserializeAndExecute(commandDispatcher, contentAsDOM(response).documentElement);
                } else {
                    var mimeType = getHeader(response, 'Content-Type');
                    warn(logger, 'unknown content in response - ' + mimeType + ', expected text/xml');
                    dispose();
                }
                sequenceNo = Number(getHeader(response, SequenceNumber));
                if (hasHeader(response, HeartbeatTimestamp)) {
                    heartbeatTimestamp = Number(getHeader(response, HeartbeatTimestamp));
                }
            });
            onServerError(asyncConnection, function(response) {
                try {
                    warn(logger, 'server side error');
                    broadcast(serverErrorListeners, [ statusCode(response), contentAsText(response), contentAsDOM(response) ]);
                } finally {
                    dispose();
                }
            });
            whenReEstablished(asyncConnection, function(windowID) {
                info(logger, 'connection will be established in window [' + windowID + ']');
                broadcast(blockingConnectionReEstablishedListeners);
            });
            whenDown(asyncConnection, function(reconnectAttempts) {
                try {
                    warn(logger, 'connection to server was lost');
                    broadcast(blockingConnectionLostListeners, [ reconnectAttempts ]);
                } finally {
                    dispose();
                }
            });
            whenTrouble(asyncConnection, function() {
                warn(logger, 'connection in trouble');
                broadcast(blockingConnectionUnstableListeners);
            });
            namespace.push.connection = {
                startConnection: function() {
                    startConnection(asyncConnection);
                },
                resumeConnection: function() {
                    sequenceNo++;
                    resumeConnection(asyncConnection);
                },
                pauseConnection: function() {
                    pauseConnection(asyncConnection);
                },
                changeHeartbeatInterval: function(interval) {
                    changeHeartbeatInterval(asyncConnection, interval);
                },
                onSend: function(callback) {
                    onSend(asyncConnection, function(query) {
                        callback(function(name, value) {
                            parametr(query, name, value);
                        });
                    });
                },
                onReceive: function(callback) {
                    onReceive(asyncConnection, function(response) {
                        callback(function(name) {
                            return getHeader(response, name);
                        }, contentAsText(response), contentAsDOM(response));
                    });
                },
                controlRequest: function(addParameter, addHeader, responseCallback) {
                    controlRequest(asyncConnection, addParameter, addHeader, responseCallback);
                }
            };
            var deviceURI;
            namespace.push.parkInactivePushIds = function(url) {
                deviceURI = url;
                namespace.push.connection.pauseConnection();
                namespace.push.connection.resumeConnection();
            };
            namespace.push.connection.onSend(function(header) {
                if (deviceURI) {
                    header('ice.parkids', 'true');
                    header('ice.notifyBack', deviceURI)
                }
            });
            info(logger, 'bridge loaded!');
            onLoad(window, namespace.push.connection.startConnection);
        }
        Bridge();
        onKeyPress(document, function(ev) {
            var e = $event(ev);
            if (isEscKey(e)) cancelDefaultAction(e);
        });
    })(window.ice);
}
