/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.application;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.icefaces.application.PortableRenderer;
import org.icefaces.application.PushIsolator;
import org.icefaces.application.PushOptions;
import org.icefaces.impl.application.LazyPushManager;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.impl.push.SessionViewManager;
import org.icefaces.util.EnvUtils;
import org.icepush.PushContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushRenderer {
    private static Logger log = Logger.getLogger(PushRenderer.class.getName());
    public static final String ALL_SESSIONS = "PushRenderer.ALL_SESSIONS";
    private static final String MissingICEpushMessage = "ICEpush library missing. Push notification disabled.";
    private static final PortableRenderer MissingICEpushPortableRenderer = new PortableRenderer(){

        public void render(String group) {
            log.warning(PushRenderer.MissingICEpushMessage);
        }

        public void render(String group, PushOptions options) {
            log.warning(PushRenderer.MissingICEpushMessage);
        }
    };

    public static synchronized void addCurrentView(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            String viewID = PushRenderer.lookupViewState(context);
            LazyPushManager.enablePushForView(context, viewID);
            PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            pushContext.addGroupMember(groupName, viewID);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized String getCurrentViewPushID() {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            return PushRenderer.lookupViewState(context);
        }
        log.warning(MissingICEpushMessage);
        return null;
    }

    public static synchronized void removeCurrentView(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (context == null) {
                log.fine("FacesContext is not present for thread " + Thread.currentThread() + ", leave the current view to expire.");
            } else {
                String viewID = PushRenderer.lookupViewState(context);
                LazyPushManager.disablePushForView(context, viewID);
                PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
                pushContext.removeGroupMember(groupName, viewID);
            }
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized void addCurrentSession(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            LazyPushManager.enablePushForSessionViews(context);
            SessionViewManager.addCurrentSessionToGroup(context, groupName);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized Set<String> getCurrentSessionPushIDSet() {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            return SessionViewManager.getCurrentSessionViewSet(context);
        }
        log.warning(MissingICEpushMessage);
        return null;
    }

    public static synchronized void removeCurrentSession(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            LazyPushManager.disablePushForSessionViews(context);
            SessionViewManager.removeCurrentSessionFromGroup(context, groupName);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized PushContext getPushContext() {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            return (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
        }
        log.warning(MissingICEpushMessage);
        return null;
    }

    public static void render(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            pushContext.push(groupName);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static void render(String group, PushOptions options) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            Boolean pushOthers = (Boolean)options.getAttributes().get("pushOthers");
            if (pushOthers != null && pushOthers.booleanValue()) {
                options.getAttributes().put("pushIDSet", SessionViewManager.getCurrentSessionViewSet(context));
            }
            Map applicationMap = context.getExternalContext().getApplicationMap();
            PushIsolator.render(applicationMap, group, options);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static PortableRenderer getPortableRenderer() {
        if (EnvUtils.isICEpushPresent()) {
            final Map applicationMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
            return new PortableRenderer(){

                public void render(String group) {
                    PushContext pushContext = (PushContext)applicationMap.get(PushContext.class.getName());
                    if (pushContext == null) {
                        log.fine("PushContext not initialized yet.");
                    } else {
                        pushContext.push(group);
                    }
                }

                public void render(String group, PushOptions options) {
                    PushIsolator.render(applicationMap, group, options);
                }
            };
        }
        log.warning(MissingICEpushMessage);
        return MissingICEpushPortableRenderer;
    }

    public static PortableRenderer getPortableRenderer(final ServletContext servletContext) {
        if (EnvUtils.isICEpushPresent()) {
            return new PortableRenderer(){

                public void render(String group) {
                    PushContext pushContext = (PushContext)servletContext.getAttribute(PushContext.class.getName());
                    if (pushContext == null) {
                        log.fine("PushContext not initialized yet.");
                    } else {
                        pushContext.push(group);
                    }
                }

                public void render(String group, PushOptions options) {
                    PushIsolator.render(servletContext, group, options);
                }
            };
        }
        log.warning(MissingICEpushMessage);
        return MissingICEpushPortableRenderer;
    }

    private static String lookupViewState(FacesContext context) {
        return BridgeSetup.getViewID(context.getExternalContext());
    }

    private static void missingFacesContext(FacesContext context) {
        if (context == null) {
            throw new RuntimeException("FacesContext is not present for thread " + Thread.currentThread());
        }
    }
}

