/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import javax.faces.application.Application;
import javax.faces.application.ResourceHandler;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.util.EnvUtils;

@ManagedBean(name="auxUpload", eager=true)
@ApplicationScoped
public class AuxUploadSetup {
    private AuxUploadResourceHandler auxHandler;
    private static String AUX_UPLOAD = "auxUpload";

    public AuxUploadSetup() {
        Application application = FacesContext.getCurrentInstance().getApplication();
        ResourceHandler currentHandler = application.getResourceHandler();
        this.auxHandler = new AuxUploadResourceHandler(currentHandler);
        application.setResourceHandler((ResourceHandler)this.auxHandler);
    }

    public static AuxUploadSetup getInstance() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        AuxUploadSetup auxUpload = (AuxUploadSetup)externalContext.getApplicationMap().get(AUX_UPLOAD);
        return auxUpload;
    }

    public String getUploadPath() {
        return this.auxHandler.getTokenResourcePath();
    }

    public String getUploadURL() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        String protocol = (String)externalContext.getRequestHeaderMap().get("x-forwarded-proto");
        String serverName = (String)externalContext.getRequestHeaderMap().get("x-forwarded-host");
        if (null == protocol) {
            protocol = externalContext.getRequestScheme();
        }
        if (null == serverName) {
            serverName = externalContext.getRequestServerName() + ":" + externalContext.getRequestServerPort();
        }
        return protocol + "://" + serverName + this.getUploadPath();
    }

    public boolean getEnabled() {
        return EnvUtils.isAuxUploadBrowser(FacesContext.getCurrentInstance());
    }

    public String getCloudPushId() {
        return this.auxHandler.getCloudPushId();
    }
}

