/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.util.CoreUtils;

public class InitializeHeadAndBodyFacetContainers
implements PhaseListener {
    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        this.initializeFacetContainer("head");
        this.initializeFacetContainer("body");
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    private void initializeFacetContainer(String target) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot root = context.getViewRoot();
        UIComponent container = CoreUtils.getResourceContainer(root, target);
        if (container == null) {
            ArrayList preRemoveFromViewListeners;
            ArrayList postAddToViewListeners = root.getViewListenersForEventClass(PostAddToViewEvent.class);
            if (postAddToViewListeners != null) {
                postAddToViewListeners = new ArrayList(postAddToViewListeners);
                for (SystemEventListener l : postAddToViewListeners) {
                    root.unsubscribeFromViewEvent(PostAddToViewEvent.class, l);
                }
            }
            if ((preRemoveFromViewListeners = root.getViewListenersForEventClass(PreRemoveFromViewEvent.class)) != null) {
                preRemoveFromViewListeners = new ArrayList(preRemoveFromViewListeners);
                for (SystemEventListener l : preRemoveFromViewListeners) {
                    root.unsubscribeFromViewEvent(PreRemoveFromViewEvent.class, l);
                }
            }
            UIOutput c = new UIOutput();
            c.setId("initialize_" + target);
            root.addComponentResource(context, (UIComponent)c, target);
            root.removeComponentResource(context, (UIComponent)c, target);
            if (postAddToViewListeners != null) {
                for (SystemEventListener l : postAddToViewListeners) {
                    root.subscribeToViewEvent(PostAddToViewEvent.class, l);
                }
            }
            if (preRemoveFromViewListeners != null) {
                for (SystemEventListener l : preRemoveFromViewListeners) {
                    root.subscribeToViewEvent(PreRemoveFromViewEvent.class, l);
                }
            }
        }
    }
}

