/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.impl.application.WindowScopeTracker;

class JSFURLWindowScopeTracker
implements WindowScopeTracker {
    private static final Logger logger = Logger.getLogger(JSFURLWindowScopeTracker.class.getName());

    JSFURLWindowScopeTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowScopeManager.ScopeMap lookupScope(FacesContext context) {
        ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
        if (context.getExternalContext().getRequest() != null && resourceHandler.isResourceRequest(context)) {
            return null;
        }
        String id = this.lookupAssociatedWindowID(context);
        WindowScopeManager.State state = WindowScopeManager.getState(context);
        if (state == null) {
            return null;
        }
        Lock synchronizationMonitor = WindowScopeManager.getSynchronizationObject(context);
        synchronizationMonitor.lock();
        try {
            WindowScopeManager.ScopeMap scopeMap = (WindowScopeManager.ScopeMap)state.windowScopedMaps.get(id);
            synchronizationMonitor.unlock();
            return scopeMap;
        }
        catch (Throwable throwable) {
            try {
                synchronizationMonitor.unlock();
                throw throwable;
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "Cannot acquire the window corresponding scope map yet.", ex);
                return null;
            }
        }
    }

    private String lookupAssociatedWindowID(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        try {
            Method getClientWindow = ExternalContext.class.getDeclaredMethod("getClientWindow", new Class[0]);
            Object clientWindow = getClientWindow.invoke((Object)externalContext, new Object[0]);
            if (clientWindow == null) {
                return null;
            }
            Method getId = clientWindow.getClass().getMethod("getId", new Class[0]);
            String id = (String)getId.invoke(clientWindow, new Object[0]);
            externalContext.getRequestMap().put(WindowScopeManager.AssociatedWindowID, id);
            return id;
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Cannot use URL based window scope with JSF 2.1 or lower.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot use URL based window scope with JSF 2.1 or lower.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot use URL based window scope with JSF 2.1 or lower.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setupScope(FacesContext context) {
        Lock synchronizationMonitor = WindowScopeManager.getSynchronizationObject(context);
        if (synchronizationMonitor == null) {
            return null;
        }
        synchronizationMonitor.lock();
        try {
            WindowScopeManager.State state = WindowScopeManager.getState(context);
            String id = this.lookupAssociatedWindowID(context);
            if (!state.windowScopedMaps.containsKey(id)) {
                SpecificScopeMap scopeMap = new SpecificScopeMap(id, context);
                scopeMap.activate(state);
            }
            String string = id;
            return string;
        }
        finally {
            synchronizationMonitor.unlock();
        }
    }

    @Override
    public void disposeScope(FacesContext context) {
    }

    static class SpecificScopeMap
    extends WindowScopeManager.ScopeMap {
        public SpecificScopeMap(String id, FacesContext facesContext) {
            super(id, facesContext);
        }
    }
}

