/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.icefaces.util.EnvUtils;

public class LazyPushManager {
    public static boolean enablePush(FacesContext context, String viewID) {
        if (!EnvUtils.isLazyPush(context)) {
            return true;
        }
        State state = LazyPushManager.getState(context);
        if (state.sessionViewsEnabled) {
            return true;
        }
        Integer no = (Integer)state.individualyRegisteredViews.get(viewID);
        return no != null && no > 0;
    }

    public static void enablePushForView(FacesContext context, String viewID) {
        State state = LazyPushManager.getState(context);
        Integer no = (Integer)state.individualyRegisteredViews.get(viewID);
        if (no == null) {
            state.individualyRegisteredViews.put(viewID, 1);
        } else {
            no = no + 1;
            state.individualyRegisteredViews.put(viewID, no);
        }
    }

    public static void disablePushForView(FacesContext context, String viewID) {
        State state = LazyPushManager.getState(context);
        Integer no = (Integer)state.individualyRegisteredViews.get(viewID);
        if (no != null) {
            if ((no = Integer.valueOf(no - 1)) > 0) {
                state.individualyRegisteredViews.put(viewID, no);
            } else {
                state.individualyRegisteredViews.remove(viewID);
            }
        }
    }

    public static void enablePushForSessionViews(FacesContext context) {
        State state = LazyPushManager.getState(context);
        state.sessionViewsEnabled = true;
    }

    public static void disablePushForSessionViews(FacesContext context) {
        State state = LazyPushManager.getState(context);
        state.sessionViewsEnabled = false;
    }

    private static State getState(FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        State state = (State)sessionMap.get(LazyPushManager.class.getName());
        if (state == null) {
            state = new State();
            sessionMap.put(LazyPushManager.class.getName(), state);
        }
        return state;
    }

    private static class State
    implements Serializable {
        private boolean sessionViewsEnabled = false;
        private HashMap individualyRegisteredViews = new HashMap();

        private State() {
        }
    }
}

