/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.util.EnvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadAfterNavigationFix
extends ConfigurableNavigationHandler {
    private static final Logger log = Logger.getLogger(ReloadAfterNavigationFix.class.getName());
    private static final String NavigationKey = NavigationInfo.class.getName();
    private NavigationHandler handler;

    public ReloadAfterNavigationFix(NavigationHandler handler) {
        this.handler = handler;
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        if (this.handler instanceof ConfigurableNavigationHandler) {
            return ((ConfigurableNavigationHandler)this.handler).getNavigationCase(context, fromAction, outcome);
        }
        log.warning(this.handler.toString() + " is not a ConfigurableNavigationHandler");
        return null;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this.handler instanceof ConfigurableNavigationHandler) {
            return ((ConfigurableNavigationHandler)this.handler).getNavigationCases();
        }
        log.warning(this.handler.toString() + " is not a ConfigurableNavigationHandler");
        return null;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        NavigationCase navigationCase;
        if (EnvUtils.isICEfacesView(context) && EnvUtils.isReplayNavigationOnReload(context) && (navigationCase = this.getNavigationCase(context, fromAction, outcome)) != null && !navigationCase.isRedirect()) {
            UIViewRoot viewRoot = context.getViewRoot();
            String fromViewId = viewRoot.getViewId();
            WindowScopeManager.ScopeMap map = WindowScopeManager.lookupWindowScope(context);
            map.put(NavigationKey, new NavigationInfo(fromViewId, fromAction, outcome, this.handler));
        }
        this.handler.handleNavigation(context, fromAction, outcome);
    }

    private static class NavigationInfo
    implements Serializable {
        private String fromViewId;
        private String navigateFrom;
        private String navigateTo;
        private transient NavigationHandler handler;

        private NavigationInfo(String fromViewId, String navigateFrom, String navigateTo, NavigationHandler handler) {
            this.fromViewId = fromViewId;
            this.navigateFrom = navigateFrom;
            this.navigateTo = navigateTo;
            this.handler = handler;
        }

        public void navigate(FacesContext context) {
            if (this.navigateTo != null && this.handler != null) {
                context.getViewRoot().setViewId(this.fromViewId);
                this.handler.handleNavigation(context, this.navigateFrom, this.navigateTo);
            }
        }
    }

    public static class TriggerNavigation
    implements PhaseListener {
        public void afterPhase(PhaseEvent event) {
            WindowScopeManager.ScopeMap map;
            NavigationInfo navigation;
            FacesContext context = event.getFacesContext();
            if (EnvUtils.isReplayNavigationOnReload(context) && !context.isPostback() && (navigation = (NavigationInfo)(map = WindowScopeManager.lookupWindowScope(context)).get(NavigationKey)) != null) {
                navigation.navigate(context);
            }
        }

        public void beforePhase(PhaseEvent event) {
        }

        public PhaseId getPhaseId() {
            return PhaseId.RESTORE_VIEW;
        }
    }
}

