/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.icefaces.impl.application.SessionAwareResourceHandlerWrapper;
import org.icefaces.util.EnvUtils;

public class SessionTimeoutMonitor
extends SessionAwareResourceHandlerWrapper {
    private static final Logger Log = Logger.getLogger(SessionTimeoutMonitor.class.getName());
    private ResourceHandler handler;

    public SessionTimeoutMonitor(ResourceHandler handler) {
        this.handler = handler;
    }

    public ResourceHandler getWrapped() {
        return this.handler;
    }

    public boolean isSessionAwareResourceRequest(FacesContext context) {
        int maxInactiveInterval;
        if (!EnvUtils.isStrictSessionTimeout(context)) {
            return this.handler.isResourceRequest(context);
        }
        HttpSession httpSession = EnvUtils.getSafeSession(context);
        Long lastAccessTime = (Long)httpSession.getAttribute(SessionTimeoutMonitor.class.getName());
        boolean isPushRelatedRequest = EnvUtils.isPushRequest(context);
        if (lastAccessTime == null || !isPushRelatedRequest) {
            lastAccessTime = System.currentTimeMillis();
            httpSession.setAttribute(SessionTimeoutMonitor.class.getName(), (Object)System.currentTimeMillis());
        }
        if ((maxInactiveInterval = httpSession.getMaxInactiveInterval()) > 0 && (System.currentTimeMillis() - lastAccessTime) / 1000L > (long)maxInactiveInterval) {
            Log.fine("invalidating session enforcing strictSessionTimeout");
            httpSession.removeAttribute(SessionTimeoutMonitor.class.getName());
            context.getExternalContext().invalidateSession();
        }
        return this.handler.isResourceRequest(context);
    }

    public void handleSessionAwareResourceRequest(FacesContext context) throws IOException {
        this.handler.handleResourceRequest(context);
    }
}

