/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.ScopeContext;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.icefaces.bean.AllWindowsClosed;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.impl.application.WindowScopeTracker;
import org.icefaces.util.EnvUtils;

class TimeBasedWindowScopeTracker
implements WindowScopeTracker {
    private static final Pattern VERIFY_WINDOW_ID = Pattern.compile("\\w*");
    private static final String WindowParameter = "ice.window";
    private static final Logger logger = Logger.getLogger(TimeBasedWindowScopeTracker.class.getName());
    private SharedMapLookupStrategy lookupStrategy;

    public TimeBasedWindowScopeTracker() {
        boolean isLiferay;
        try {
            URL url = FacesContext.getCurrentInstance().getExternalContext().getResource("/WEB-INF/portlet.xml");
            isLiferay = EnvUtils.isLiferay() && url != null;
        }
        catch (MalformedURLException e) {
            isLiferay = false;
        }
        try {
            this.lookupStrategy = isLiferay ? new LiferayOriginalRequestWindowScopeSharing() : new TimeBasedHeuristicWindowScopeSharing();
        }
        catch (Exception e) {
            this.lookupStrategy = new TimeBasedHeuristicWindowScopeSharing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WindowScopeManager.ScopeMap lookupScope(FacesContext context) {
        try {
            WindowScopeManager.ScopeMap next;
            WindowScopeManager.State state;
            String id;
            block12: {
                ExternalContext externalContext = context.getExternalContext();
                Map parameterMap = externalContext.getRequestParameterMap();
                ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
                if (externalContext.getRequest() != null && !parameterMap.containsKey(WindowParameter) && resourceHandler.isResourceRequest(context)) {
                    return null;
                }
                id = this.lookupAssociatedWindowID(context);
                state = WindowScopeManager.getState(context);
                if (state == null) {
                    return null;
                }
                Lock synchronizationMonitor = WindowScopeManager.getSynchronizationObject(context);
                synchronizationMonitor.lock();
                WindowScopeManager.ScopeMap map = (WindowScopeManager.ScopeMap)state.windowScopedMaps.get(id);
                if (map != null) {
                    WindowScopeManager.ScopeMap scopeMap = map;
                    return scopeMap;
                }
                break block12;
                finally {
                    synchronizationMonitor.unlock();
                }
            }
            Iterator iterator = state.disposedWindowScopedMaps.iterator();
            do {
                if (!iterator.hasNext()) {
                    iterator = null;
                    return iterator;
                }
                Object scopeMap = iterator.next();
                next = (WindowScopeManager.ScopeMap)scopeMap;
            } while (next.id == null || !next.id.equals(id));
            WindowScopeManager.ScopeMap scopeMap = next;
            return scopeMap;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Cannot acquire the window corresponding scope map yet.", ex);
            return null;
        }
    }

    private String lookupAssociatedWindowID(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String id = (String)requestMap.get(WindowScopeManager.class.getName());
        if (id == null) {
            id = this.setupScope(facesContext);
            requestMap.put(WindowScopeManager.class.getName(), id);
        }
        requestMap.put(WindowScopeManager.AssociatedWindowID, id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setupScope(FacesContext context) {
        Lock synchronizationMonitor = WindowScopeManager.getSynchronizationObject(context);
        if (synchronizationMonitor == null) {
            return null;
        }
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        String presetID = WindowScopeManager.getAssociatedWindowID(requestMap);
        if (presetID != null) {
            return presetID;
        }
        synchronizationMonitor.lock();
        try {
            Object scopeMap;
            SpecificScopeMap map;
            WindowScopeManager.State state = WindowScopeManager.getState(context);
            String id = (String)externalContext.getRequestParameterMap().get(WindowParameter);
            try {
                for (Object scopeMap2 : new ArrayList(state.windowScopedMaps.values())) {
                    map = (SpecificScopeMap)scopeMap2;
                    if (map.getId().equals(id)) continue;
                    map.disactivateIfUnused(context);
                }
            }
            catch (Throwable e) {
                logger.log(Level.FINE, "Failed to remove window scope map", e);
            }
            try {
                for (Object scopeMap2 : new ArrayList(state.disposedWindowScopedMaps)) {
                    map = (SpecificScopeMap)scopeMap2;
                    if (map.getId().equals(id)) continue;
                    map.discardIfExpired(context);
                }
            }
            catch (Throwable e) {
                logger.log(Level.FINE, "Failed to remove window scope map", e);
            }
            if (id == null) {
                scopeMap = this.lookupStrategy.lookup(context);
                if (scopeMap == null) {
                    long delay = EnvUtils.getWindowScopeCreationDelay(context);
                    if (delay > 0L) {
                        synchronizationMonitor.unlock();
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        synchronizationMonitor.lock();
                    }
                    scopeMap = state.disposedWindowScopedMaps.isEmpty() ? new SpecificScopeMap(context) : (SpecificScopeMap)state.disposedWindowScopedMaps.removeFirst();
                    ((SpecificScopeMap)scopeMap).activate(state);
                }
                WindowScopeManager.associateWindowID(((WindowScopeManager.ScopeMap)scopeMap).getId(), requestMap);
                String delay = ((WindowScopeManager.ScopeMap)scopeMap).getId();
                return delay;
            }
            if (state.windowScopedMaps.containsKey(id)) {
                WindowScopeManager.associateWindowID(id, requestMap);
                scopeMap = id;
                return scopeMap;
            }
            for (Object disposedScopeMap : new ArrayList(state.disposedWindowScopedMaps)) {
                SpecificScopeMap scopeMap3 = (SpecificScopeMap)disposedScopeMap;
                if (!scopeMap3.getId().equals(id)) continue;
                scopeMap3.activate(state);
                WindowScopeManager.associateWindowID(id, requestMap);
                String string = id;
                return string;
            }
            scopeMap = VERIFY_WINDOW_ID.matcher(id).matches() ? new SpecificScopeMap(id, context) : new SpecificScopeMap(context);
            ((SpecificScopeMap)scopeMap).activate(state);
            WindowScopeManager.associateWindowID(((WindowScopeManager.ScopeMap)scopeMap).getId(), requestMap);
            String string = ((WindowScopeManager.ScopeMap)scopeMap).getId();
            return string;
        }
        finally {
            synchronizationMonitor.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeScope(FacesContext context) {
        Lock synchronizationMonitor = WindowScopeManager.getSynchronizationObject(context);
        synchronizationMonitor.lock();
        try {
            WindowScopeManager.State state = WindowScopeManager.getState(context);
            String id = this.lookupAssociatedWindowID(context);
            SpecificScopeMap scopeMap = (SpecificScopeMap)state.windowScopedMaps.get(id);
            if (scopeMap != null) {
                scopeMap.disactivate(state);
                scopeMap.discardIfExpired(context);
            }
            if (state.windowScopedMaps.isEmpty()) {
                long windowScopeExpiration = EnvUtils.getWindowScopeExpiration(context);
                HashMap session = new HashMap(context.getExternalContext().getSessionMap());
                Timer timer = WindowScopeManager.SetupTimer.get(context);
                timer.schedule((TimerTask)new AllWindowsClosedNotifier(state, session), windowScopeExpiration * 2L);
            }
            WindowScopeManager.disposeViewScopeBeans(context);
        }
        finally {
            synchronizationMonitor.unlock();
        }
    }

    private static class LiferayOriginalRequestWindowScopeSharing
    implements SharedMapLookupStrategy {
        private Class PortalUtilClass = Class.forName("com.liferay.portal.util.PortalUtil");
        private Method GetHttpServletRequest = this.PortalUtilClass.getDeclaredMethod("getHttpServletRequest", PortletRequest.class);
        private Method GetOriginalServletRequest = this.PortalUtilClass.getDeclaredMethod("getOriginalServletRequest", HttpServletRequest.class);

        private LiferayOriginalRequestWindowScopeSharing() throws ClassNotFoundException, NoSuchMethodException {
        }

        @Override
        public SpecificScopeMap lookup(FacesContext context) {
            WindowScopeManager.State state = WindowScopeManager.getState(context);
            ExternalContext externalContext = context.getExternalContext();
            HttpServletRequest originalRequest = this.getOriginalServletRequest(externalContext);
            String sharedWindowID = (String)originalRequest.getAttribute(WindowScopeManager.class.getName());
            return sharedWindowID == null ? null : (SpecificScopeMap)state.windowScopedMaps.get(sharedWindowID);
        }

        @Override
        public void associate(FacesContext context, String windowID) {
            ExternalContext externalContext = context.getExternalContext();
            HttpServletRequest originalRequest = this.getOriginalServletRequest(externalContext);
            originalRequest.setAttribute(WindowScopeManager.class.getName(), (Object)windowID);
        }

        private HttpServletRequest getOriginalServletRequest(ExternalContext externalContext) {
            try {
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                HttpServletRequest httpPortletRequest = (HttpServletRequest)this.GetHttpServletRequest.invoke((Object)this.PortalUtilClass, portletRequest);
                HttpServletRequest originalRequest = (HttpServletRequest)this.GetOriginalServletRequest.invoke((Object)this.PortalUtilClass, httpPortletRequest);
                return originalRequest;
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
    }

    private static class TimeBasedHeuristicWindowScopeSharing
    implements SharedMapLookupStrategy {
        private long sameWindowMaxDelay = -1L;

        private TimeBasedHeuristicWindowScopeSharing() {
        }

        @Override
        public SpecificScopeMap lookup(FacesContext context) {
            if (this.sameWindowMaxDelay == -1L) {
                this.sameWindowMaxDelay = EnvUtils.getWindowScopeExpiration(context);
            }
            WindowScopeManager.State state = WindowScopeManager.getState(context);
            for (SpecificScopeMap sm : state.windowScopedMaps.values()) {
                if (sm.activateTimestamp + this.sameWindowMaxDelay <= System.currentTimeMillis()) continue;
                return sm;
            }
            return null;
        }

        @Override
        public void associate(FacesContext context, String windowID) {
        }
    }

    private static interface SharedMapLookupStrategy {
        public SpecificScopeMap lookup(FacesContext var1);

        public void associate(FacesContext var1, String var2);
    }

    static class AllWindowsClosedNotifier
    extends TimerTask {
        private final WindowScopeManager.State state;
        private final Map session;

        public AllWindowsClosedNotifier(WindowScopeManager.State state, Map session) {
            this.state = state;
            this.session = session;
        }

        @Override
        public void run() {
            if (this.state.windowScopedMaps.isEmpty()) {
                ArrayList<WindowScopeManager.ScopeMap> expiredMaps = new ArrayList<WindowScopeManager.ScopeMap>();
                for (SpecificScopeMap scopeMap : this.state.disposedWindowScopedMaps) {
                    if (System.currentTimeMillis() <= scopeMap.deactivateTimestamp + this.state.expirationPeriod) continue;
                    expiredMaps.add(scopeMap);
                }
                WindowScopeManager.notifyPreDestroyForAll(expiredMaps);
                for (Object object : this.session.values()) {
                    WindowScopeManager.callAnnotatedMethod(object, AllWindowsClosed.class);
                }
            }
        }
    }

    public class SpecificScopeMap
    extends WindowScopeManager.ScopeMap {
        private long activateTimestamp;
        private long deactivateTimestamp;

        public SpecificScopeMap(String id, FacesContext facesContext) {
            super(id, facesContext);
            this.activateTimestamp = System.currentTimeMillis();
            this.deactivateTimestamp = -1L;
            TimeBasedWindowScopeTracker.this.lookupStrategy.associate(facesContext, id);
        }

        public SpecificScopeMap(FacesContext facesContext) {
            super(facesContext);
            this.activateTimestamp = System.currentTimeMillis();
            this.deactivateTimestamp = -1L;
            TimeBasedWindowScopeTracker.this.lookupStrategy.associate(facesContext, this.id);
        }

        @Override
        public void activate(WindowScopeManager.State state) {
            state.windowScopedMaps.put(this.getId(), this);
            this.activateTimestamp = System.currentTimeMillis();
        }

        @Override
        public void disactivate(WindowScopeManager.State state) {
            this.deactivateTimestamp = System.currentTimeMillis();
            state.disposedWindowScopedMaps.addLast(state.windowScopedMaps.remove(this.getId()));
        }

        public void disactivateIfUnused(FacesContext facesContext) {
            UIViewRoot viewRoot = facesContext.getViewRoot();
            if (!(!EnvUtils.isLazyWindowScope(facesContext) || EnvUtils.containsBeans(this) || viewRoot != null && EnvUtils.containsDisposedBeans(viewRoot.getViewMap()))) {
                this.disactivate(WindowScopeManager.getState(facesContext));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discardIfExpired(FacesContext facesContext) {
            block7: {
                WindowScopeManager.State state = WindowScopeManager.getState(facesContext);
                if (System.currentTimeMillis() > this.deactivateTimestamp + state.expirationPeriod) {
                    try {
                        if (this.isPreDestroyInvoked()) break block7;
                        boolean processingEvents = facesContext.isProcessingEvents();
                        try {
                            facesContext.setProcessingEvents(true);
                            ScopeContext context = new ScopeContext("window", (Map)this);
                            facesContext.getApplication().publishEvent(facesContext, PreDestroyCustomScopeEvent.class, (Object)context);
                        }
                        finally {
                            this.preDestroyInvoked();
                            facesContext.setProcessingEvents(processingEvents);
                        }
                    }
                    finally {
                        state.disposedWindowScopedMaps.remove(this);
                    }
                }
            }
        }
    }
}

