/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.el.ELContext;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ResourceHandler;
import javax.faces.bean.ViewScoped;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostConstructCustomScopeEvent;
import javax.faces.event.ScopeContext;
import javax.faces.event.SystemEvent;
import javax.portlet.PortletSession;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import org.icefaces.bean.WindowDisposed;
import org.icefaces.impl.application.IcefacesBeanDestroyRecorder;
import org.icefaces.impl.application.JSFURLWindowScopeTracker;
import org.icefaces.impl.application.SessionAwareResourceHandlerWrapper;
import org.icefaces.impl.application.TimeBasedWindowScopeTracker;
import org.icefaces.impl.application.WindowScopeTracker;
import org.icefaces.util.EnvUtils;

public class WindowScopeManager
extends SessionAwareResourceHandlerWrapper {
    public static final String SessionSynchronizationMonitor = WindowScopeManager.class.getName() + "$SessionSynchronizationMonitor";
    public static final String AssociatedWindowID = WindowScopeManager.class.getName() + "$WindowID";
    public static final String ScopeName = "window";
    private static final String ICEFACES_BEAN_DESTROY_RECORDER = "icefacesBeanDestroyRecorder";
    private static final Logger log = Logger.getLogger(WindowScopeManager.class.getName());
    private static final String seed = Integer.toString(new Random().nextInt(1000), 36);
    private static WindowScopeTracker tracker;
    private ResourceHandler wrapped;

    public WindowScopeManager(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    @Override
    public void handleSessionAwareResourceRequest(FacesContext facesContext) throws IOException {
        this.wrapped.handleResourceRequest(facesContext);
    }

    @Override
    public boolean isResourceRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map parameters = externalContext.getRequestParameterMap();
        if (WindowScopeManager.isDisposeWindowRequest(parameters)) {
            return facesContext.getExternalContext().getSession(false) == null;
        }
        return super.isResourceRequest(facesContext);
    }

    @Override
    public boolean isSessionAwareResourceRequest(FacesContext context) {
        return this.wrapped.isResourceRequest(context);
    }

    public static String lookupAssociatedWindowID(Map requestMap) {
        return (String)requestMap.get(AssociatedWindowID);
    }

    public static String determineWindowID(FacesContext context) {
        return tracker.setupScope(context);
    }

    public static ScopeMap lookupWindowScope(FacesContext context) {
        return tracker.lookupScope(context);
    }

    static Lock getSynchronizationObject(FacesContext context) {
        HttpSession safeSession = EnvUtils.getSafeSession(context);
        if (safeSession == null) {
            return null;
        }
        Object synchronizationMonitor = safeSession.getAttribute(SessionSynchronizationMonitor);
        if (synchronizationMonitor == null) {
            log.log(Level.FINE, "synchronization monitor not set by session listener");
            synchronizationMonitor = new ReentrantLock();
            safeSession.setAttribute(SessionSynchronizationMonitor, synchronizationMonitor);
        }
        return (Lock)synchronizationMonitor;
    }

    public static boolean isDisposeWindowRequest(Map parameters) {
        return "ice.dispose.window".equals(parameters.get("ice.submit.type"));
    }

    public static void disposeWindows(HttpSession session) {
        State state = (State)session.getAttribute(WindowScopeManager.class.getName());
        if (state == null) {
            return;
        }
        WindowScopeManager.notifyPreDestroyForAll(state.windowScopedMaps.values());
        WindowScopeManager.notifyPreDestroyForAll(state.disposedWindowScopedMaps);
    }

    static void notifyPreDestroyForAll(Collection<ScopeMap> scopeMaps) {
        for (ScopeMap scopeMap : scopeMaps) {
            if (scopeMap.isPreDestroyInvoked()) continue;
            try {
                WindowScopeManager.notifyPreDestroy(scopeMap.values());
            }
            finally {
                scopeMap.preDestroyInvoked();
            }
        }
    }

    static void notifyPreDestroy(Collection beans) {
        try {
            for (Object bean : beans) {
                try {
                    WindowScopeManager.callAnnotatedMethod(bean, PreDestroy.class);
                }
                catch (Exception exception) {
                    log.log(Level.FINE, "An exception occurred while trying to invoke @PreDestroy on a window scoped bean: " + exception.getMessage());
                }
            }
        }
        catch (Exception exception) {
            log.log(Level.FINE, "An exception occurred while trying to invoke @PreDestroy on window scoped beans: " + exception.getMessage());
        }
    }

    static void disposeViewScopeBeans(FacesContext facesContext) {
        ExceptionHandler oldHandler = facesContext.getExceptionHandler();
        facesContext.setExceptionHandler((ExceptionHandler)new DiscardingExceptionHandler(oldHandler));
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (null == viewRoot) {
            return;
        }
        Map viewMap = viewRoot.getViewMap();
        IcefacesBeanDestroyRecorder beanDestroyRecorder = (IcefacesBeanDestroyRecorder)viewMap.get(ICEFACES_BEAN_DESTROY_RECORDER);
        if (!beanDestroyRecorder.isDisposed()) {
            viewMap.clear();
        }
        if (!beanDestroyRecorder.isDisposed()) {
            Iterator keys = viewMap.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                Object object = viewMap.get(key);
                if (!object.getClass().isAnnotationPresent(WindowDisposed.class)) continue;
                keys.remove();
                WindowScopeManager.callAnnotatedMethod(object, PreDestroy.class);
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Closing window disposed ViewScoped bean " + key);
            }
        }
        facesContext.setExceptionHandler(oldHandler);
    }

    static void callAnnotatedMethod(Object object, Class annotation) {
        Class<?> theClass;
        try {
            for (theClass = object.getClass(); null != theClass; theClass = theClass.getSuperclass()) {
                Method[] methods;
                for (Method method : methods = object.getClass().getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    method.setAccessible(true);
                    method.invoke(object, new Object[0]);
                    return;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to invoke" + annotation + " on " + theClass, e);
        }
    }

    public static void sessionCreated(HttpSession session) {
        session.setAttribute(SessionSynchronizationMonitor, (Object)new ReentrantLock());
    }

    public static void associateWindowIDToRequest(String id, FacesContext facesContext) {
        WindowScopeManager.associateWindowID(id, facesContext.getExternalContext().getRequestMap());
    }

    static void associateWindowID(String id, Map requestMap) {
        requestMap.put(WindowScopeManager.class.getName(), id);
    }

    static String getAssociatedWindowID(Map requestMap) {
        return (String)requestMap.get(WindowScopeManager.class.getName());
    }

    static State getState(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Object session = externalContext.getSession(false);
        if (session != null) {
            return EnvUtils.instanceofPortletSession(session) ? WindowScopeManager.getPortletState(context, session) : WindowScopeManager.getServletState(context, session);
        }
        return null;
    }

    private static State getServletState(FacesContext context, Object session) {
        HttpSession servletSession = (HttpSession)session;
        State state = (State)servletSession.getAttribute(WindowScopeManager.class.getName());
        if (state == null) {
            state = new State(EnvUtils.getWindowScopeExpiration(context));
            servletSession.setAttribute(WindowScopeManager.class.getName(), (Object)state);
        }
        return state;
    }

    private static State getPortletState(FacesContext context, Object session) {
        PortletSession portletSession = (PortletSession)session;
        State state = (State)portletSession.getAttribute(WindowScopeManager.class.getName(), 1);
        if (state == null) {
            state = new State(EnvUtils.getWindowScopeExpiration(context));
            portletSession.setAttribute(WindowScopeManager.class.getName(), (Object)state, 1);
        }
        return state;
    }

    static {
        boolean urlBasedWindowTracking = "url".equals(FacesContext.getCurrentInstance().getExternalContext().getInitParameter("javax.faces.CLIENT_WINDOW_MODE"));
        tracker = urlBasedWindowTracking ? new JSFURLWindowScopeTracker() : new TimeBasedWindowScopeTracker();
    }

    public static class SaveScopeState
    implements PhaseListener {
        public void afterPhase(PhaseEvent event) {
            FacesContext context = FacesContext.getCurrentInstance();
            try {
                ExternalContext externalContext = context.getExternalContext();
                Object session = externalContext.getSession(false);
                if (session != null) {
                    if (EnvUtils.instanceofPortletSession(session)) {
                        PortletSession portletSession = (PortletSession)session;
                        Object state = portletSession.getAttribute(WindowScopeManager.class.getName(), 1);
                        if (state != null) {
                            portletSession.setAttribute(WindowScopeManager.class.getName(), state, 1);
                        }
                    } else {
                        HttpSession servletSession = (HttpSession)session;
                        Object state = servletSession.getAttribute(WindowScopeManager.class.getName());
                        if (state != null) {
                            servletSession.setAttribute(WindowScopeManager.class.getName(), state);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, "Unable to reset WindowScope", e);
            }
        }

        public void beforePhase(PhaseEvent event) {
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            elContext.getELResolver().getValue(elContext, null, (Object)WindowScopeManager.ICEFACES_BEAN_DESTROY_RECORDER);
        }

        public PhaseId getPhaseId() {
            return PhaseId.RENDER_RESPONSE;
        }
    }

    public static class FixViewScopedBeansOnRedirect
    extends ConfigurableNavigationHandler {
        private NavigationHandler handler;

        public FixViewScopedBeansOnRedirect(NavigationHandler handler) {
            this.handler = handler;
        }

        public void handleNavigation(FacesContext context, String fromAction, String outcome) {
            NavigationCase navigationCase = this.getNavigationCase(context, fromAction, outcome);
            boolean redirect = navigationCase != null && navigationCase.isRedirect();
            HashMap beans = Collections.EMPTY_MAP;
            if (redirect) {
                beans = new HashMap();
                Set viewMapEntries = context.getViewRoot().getViewMap().entrySet();
                for (Map.Entry viewMapEntry : viewMapEntries) {
                    if (!viewMapEntry.getValue().getClass().isAnnotationPresent(ViewScoped.class)) continue;
                    beans.put(viewMapEntry.getKey(), viewMapEntry.getValue());
                }
            }
            this.handler.handleNavigation(context, fromAction, outcome);
            if (redirect && !beans.isEmpty()) {
                Map viewMap = context.getViewRoot().getViewMap();
                viewMap.putAll(beans);
            }
        }

        public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
            if (this.handler instanceof ConfigurableNavigationHandler) {
                return ((ConfigurableNavigationHandler)this.handler).getNavigationCase(context, fromAction, outcome);
            }
            log.warning(this.handler.toString() + " is not a ConfigurableNavigationHandler");
            return null;
        }

        public Map<String, Set<NavigationCase>> getNavigationCases() {
            if (this.handler instanceof ConfigurableNavigationHandler) {
                return ((ConfigurableNavigationHandler)this.handler).getNavigationCases();
            }
            log.warning(this.handler.toString() + " is not a ConfigurableNavigationHandler");
            return null;
        }
    }

    public static class DetermineOrDisposeScope
    implements PhaseListener {
        public void afterPhase(PhaseEvent event) {
        }

        public void beforePhase(PhaseEvent event) {
            FacesContext context = event.getFacesContext();
            if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
                tracker.setupScope(context);
            }
            ExternalContext externalContext = context.getExternalContext();
            Map parameters = externalContext.getRequestParameterMap();
            if (event.getPhaseId() == PhaseId.APPLY_REQUEST_VALUES && WindowScopeManager.isDisposeWindowRequest(parameters)) {
                context.responseComplete();
                tracker.disposeScope(context);
            }
        }

        public PhaseId getPhaseId() {
            return PhaseId.ANY_PHASE;
        }
    }

    public static class SetupTimer
    implements ServletContextListener {
        private Timer timer;

        public void contextInitialized(ServletContextEvent servletContextEvent) {
            this.timer = new Timer("WindowScopeManager timer", true);
            servletContextEvent.getServletContext().setAttribute(SetupTimer.class.getName(), (Object)this.timer);
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
            this.timer.cancel();
        }

        public static Timer get(FacesContext context) {
            return (Timer)context.getExternalContext().getApplicationMap().get(SetupTimer.class.getName());
        }
    }

    static class DiscardingExceptionHandler
    extends ExceptionHandlerWrapper {
        ExceptionHandler wrapped;

        public DiscardingExceptionHandler(ExceptionHandler wrapped) {
            this.wrapped = wrapped;
        }

        public void processEvent(SystemEvent exceptionQueuedEvent) {
            Throwable throwable = ((ExceptionQueuedEvent)exceptionQueuedEvent).getContext().getException();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception during window disposal " + throwable);
            }
        }

        public ExceptionHandler getWrapped() {
            return this.wrapped;
        }
    }

    public static class State
    implements Externalizable {
        public HashMap windowScopedMaps = new HashMap();
        public LinkedList disposedWindowScopedMaps = new LinkedList();
        public long expirationPeriod;

        public State() {
        }

        private State(long expirationPeriod) {
            this.expirationPeriod = expirationPeriod;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.windowScopedMaps);
            out.writeObject(this.disposedWindowScopedMaps);
            out.writeLong(this.expirationPeriod);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.windowScopedMaps = (HashMap)in.readObject();
            this.disposedWindowScopedMaps = (LinkedList)in.readObject();
            this.expirationPeriod = in.readLong();
        }
    }

    public static class ScopeMap
    extends HashMap {
        String id;
        private boolean preDestroyInvoked;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScopeMap(String id, FacesContext facesContext) {
            this.id = id;
            boolean processingEvents = facesContext.isProcessingEvents();
            try {
                facesContext.setProcessingEvents(true);
                ScopeContext context = new ScopeContext(WindowScopeManager.ScopeName, (Map)this);
                facesContext.getApplication().publishEvent(facesContext, PostConstructCustomScopeEvent.class, (Object)context);
            }
            finally {
                facesContext.setProcessingEvents(processingEvents);
            }
        }

        public String getId() {
            return this.id;
        }

        public ScopeMap(FacesContext facesContext) {
            this(ScopeMap.generateID(), facesContext);
        }

        public void activate(State state) {
            state.windowScopedMaps.put(this.getId(), this);
        }

        public void disactivate(State state) {
            state.disposedWindowScopedMaps.addLast(state.windowScopedMaps.remove(this.getId()));
        }

        public void preDestroyInvoked() {
            this.preDestroyInvoked = true;
        }

        public boolean isPreDestroyInvoked() {
            return this.preDestroyInvoked;
        }

        private static synchronized String generateID() {
            return seed + Long.toString(System.currentTimeMillis(), 36);
        }
    }
}

