/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.component.Focusable;
import org.icefaces.util.FocusController;

public class FocusManager
extends UIComponentBase {
    private static final Logger log = Logger.getLogger(FocusManager.class.getName());
    private static final Random RANDOM = new Random();
    private static final String LAST_FOCUSED_COMPONENT = "lastFocusedComponent";

    public String getFamily() {
        return "javax.faces.Output";
    }

    public String getFor() {
        return (String)this.getStateHelper().eval((Serializable)((Object)"for"));
    }

    public void setFor(String id) {
        this.getStateHelper().put((Serializable)((Object)"for"), (Object)id);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        Map componentAttributes;
        String lastFocusedComponent;
        String id;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)this);
        writer.writeAttribute("id", (Object)this.getClientId(context), null);
        UIInput source = null;
        Map attributes = context.getAttributes();
        UIInput invalidUIInput = (UIInput)attributes.get(DetectInvalidChild.class.getName());
        if (invalidUIInput == null) {
            String focusFor = this.getFor();
            if (focusFor != null && !"".equals(focusFor)) {
                UIComponent c = FocusManager.findComponent((UIComponent)this, focusFor);
                if (c instanceof UIInput || c instanceof Focusable) {
                    source = c;
                } else {
                    log.warning("The \"for\" attribute points to a component that is not an instance of UIInput");
                }
            }
            if (source == null) {
                LinkedList<FocusManager> queue = new LinkedList<FocusManager>();
                queue.add(this);
                while (!queue.isEmpty()) {
                    UIComponent c = (UIComponent)queue.removeFirst();
                    if (c instanceof UIInput || c instanceof Focusable) {
                        source = c;
                        break;
                    }
                    queue.addAll(c.getChildren());
                }
            }
        } else {
            source = invalidUIInput;
        }
        if (source != null && !(id = source instanceof Focusable ? ((Focusable)source).getFocusedElementId() : source.getClientId(context)).equals(lastFocusedComponent = (String)(componentAttributes = this.getAttributes()).get(LAST_FOCUSED_COMPONENT))) {
            if (invalidUIInput == null) {
                componentAttributes.put(LAST_FOCUSED_COMPONENT, id);
            }
            FocusController.setFocus(context, id);
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeText((Object)"try { ice.applyFocus('", null);
            writer.writeText((Object)id, null);
            writer.writeText((Object)"'); } catch (ex) {ice.log.warn(ice.logger, 'failed to focus element ", null);
            writer.writeText((Object)id, null);
            writer.writeText((Object)"'); }//", null);
            writer.writeText((Object)RANDOM.nextLong(), null);
            writer.endElement("script");
        }
        writer.endElement("span");
    }

    public static UIComponent findComponent(UIComponent base, String id) {
        if (id.equals(base.getId())) {
            return base;
        }
        UIComponent result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            UIComponent kid = (UIComponent)kids.next();
            if (id.equals(kid.getId())) {
                result = kid;
                break;
            }
            result = FocusManager.findComponent(kid, id);
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static class DetectInvalidChild
    implements SystemEventListener {
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            FacesContext context = FacesContext.getCurrentInstance();
            UIInput source = (UIInput)event.getSource();
            Map attributes = context.getAttributes();
            if (!attributes.containsKey(DetectInvalidChild.class.getName()) && !source.isValid() && source.isRendered()) {
                attributes.put(DetectInvalidChild.class.getName(), source);
            }
        }

        public boolean isListenerForSource(Object source) {
            if (source instanceof UIInput) {
                UIComponent component = (UIComponent)source;
                for (UIComponent cursor = component.getParent(); cursor != null; cursor = cursor.getParent()) {
                    if (!(cursor instanceof FocusManager)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

