/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.context;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.impl.context.DOMResponseWriter;
import org.icefaces.impl.context.DocumentOperation;
import org.icefaces.impl.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DOMPartialRenderCallback
implements VisitCallback {
    private static Logger log = Logger.getLogger(DOMPartialRenderCallback.class.getName());
    private FacesContext facesContext;
    private ArrayList<DOMUtils.EditOperation> diffs;
    private DOMUtils.DiffConfig diffConfig = null;
    private boolean exception;
    private ArrayList<DocumentOperation> documentOperations = new ArrayList();

    public DOMPartialRenderCallback(DOMUtils.DiffConfig diffConfig, FacesContext facesContext) {
        this.facesContext = facesContext;
        this.diffs = new ArrayList();
        this.exception = false;
        this.diffConfig = diffConfig;
    }

    public VisitResult visit(VisitContext visitContext, UIComponent component) {
        block14: {
            Element oldSubtree;
            FacesContext facesContext = visitContext.getFacesContext();
            boolean isDevMode = !facesContext.isProjectStage(ProjectStage.Production);
            String clientId = component.getClientId(facesContext);
            DOMResponseWriter domWriter = (DOMResponseWriter)facesContext.getResponseWriter();
            Document oldDocument = domWriter.getOldDocument();
            Element element = oldSubtree = oldDocument == null ? null : oldDocument.getElementById(clientId);
            if (null == oldSubtree) {
                StringWriter stringWriter;
                ResponseWriter originalWriter;
                block13: {
                    log.fine("DOM Subtree rendering for " + clientId + " could not be found and is reverting to standard rendering.");
                    originalWriter = facesContext.getResponseWriter();
                    stringWriter = new StringWriter();
                    ResponseWriter captureWriter = facesContext.getRenderKit().createResponseWriter((Writer)stringWriter, originalWriter.getContentType(), originalWriter.getCharacterEncoding());
                    facesContext.setResponseWriter(captureWriter);
                    try {
                        component.encodeAll(facesContext);
                    }
                    catch (IOException e) {
                        this.exception = true;
                        if (!log.isLoggable(Level.SEVERE)) break block13;
                        log.log(Level.SEVERE, "Subtree rendering failed for " + component.getClass() + " " + clientId, e);
                    }
                }
                facesContext.setResponseWriter(originalWriter);
                DOMUtils.ReplaceOperation replaceOp = new DOMUtils.ReplaceOperation(clientId, domWriter.getDocument().createTextNode(stringWriter.toString()));
                this.diffs.add(replaceOp);
                return VisitResult.REJECT;
            }
            try {
                domWriter.startDocument();
                domWriter.startElement("div", null);
                component.encodeAll(facesContext);
                Element newSubtree = domWriter.getDocument().getElementById(clientId);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Subtree rendering for " + clientId + " oldSubtree: " + oldSubtree + " newSubtree: " + newSubtree);
                }
                if (null == oldSubtree) {
                    if (null != newSubtree) {
                        this.diffs.add(new DOMUtils.ReplaceOperation(newSubtree));
                        this.documentOperations.add(new ReplaceNodeOperation(clientId, newSubtree));
                    }
                    if (isDevMode) {
                        log.warning("Subtree rendering " + clientId + " which not exist on client and replace may fail.");
                    }
                } else if (null != newSubtree) {
                    List<DOMUtils.EditOperation> editOperations = DOMUtils.nodeDiff(this.diffConfig, oldSubtree, newSubtree);
                    this.diffs.addAll(editOperations);
                    this.documentOperations.add(new ReplaceNodeOperation(clientId, newSubtree));
                } else {
                    this.diffs.add(new DOMUtils.DeleteOperation(clientId));
                    this.documentOperations.add(new DeleteNodeOperation(clientId));
                    if (isDevMode) {
                        log.warning("Subtree rendering deleting " + clientId + " and subsequent updates may fail.");
                    }
                }
                domWriter.endElement("div");
            }
            catch (Exception e) {
                this.exception = true;
                if (!log.isLoggable(Level.SEVERE)) break block14;
                log.log(Level.SEVERE, "Subtree rendering failed for " + component.getClass() + " " + clientId, e);
            }
        }
        return VisitResult.REJECT;
    }

    public List<DocumentOperation> getDocumentOperations() {
        return this.documentOperations;
    }

    public List<DOMUtils.EditOperation> getDiffs() {
        return this.diffs;
    }

    public boolean didFail() {
        return this.exception;
    }

    private static class DeleteNodeOperation
    implements DocumentOperation {
        private final String clientId;

        public DeleteNodeOperation(String clientId) {
            this.clientId = clientId;
        }

        public void operateOn(Document document) {
            Element node = document.getElementById(this.clientId);
            node.getParentNode().removeChild(node);
        }
    }

    private static class ReplaceNodeOperation
    implements DocumentOperation {
        private final String clientId;
        private final Node newSubtree;

        public ReplaceNodeOperation(String clientId, Node newSubtree) {
            this.clientId = clientId;
            this.newSubtree = newSubtree;
        }

        public void operateOn(Document document) {
            Element node = document.getElementById(this.clientId);
            Element newNode = (Element)node.getOwnerDocument().importNode(this.newSubtree, true);
            newNode.setIdAttribute("id", true);
            NodeList elements = newNode.getElementsByTagName("*");
            int l = elements.getLength();
            for (int i = 0; i < l; ++i) {
                Element e = (Element)elements.item(i);
                if (!e.hasAttribute("id")) continue;
                e.setIdAttribute("id", true);
            }
            node.getParentNode().replaceChild(newNode, node);
        }
    }
}

