/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.context;

import java.io.IOException;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.icefaces.impl.context.CustomPartialRenderCallback;
import org.icefaces.impl.context.DOMPartialRenderCallback;
import org.icefaces.impl.context.DOMResponseWriter;
import org.icefaces.impl.context.DocumentOperation;
import org.icefaces.impl.util.DOMUtils;
import org.icefaces.util.EnvUtils;
import org.icefaces.util.FocusController;
import org.icefaces.util.JavaScriptRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMPartialViewContext
extends PartialViewContextWrapper {
    private static final String JAVAX_FACES_VIEW_HEAD = "javax.faces.ViewHead";
    private static final String JAVAX_FACES_VIEW_BODY = "javax.faces.ViewBody";
    private static final String JAVAX_FACES_VIEW_ROOT = "javax.faces.ViewRoot";
    private static final Logger log = Logger.getLogger(DOMPartialViewContext.class.getName());
    private static final Pattern SPACE_SEPARATED = Pattern.compile("[ ]+");
    private static final Pattern OPTION_TAG = Pattern.compile("<option ([^>]*)>");
    private static final Pattern OPTION_VALUE = Pattern.compile("value=\\\"([^\"]*)\\\"");
    private static final Pattern OPTION_SELECTED = Pattern.compile("(selected=\\\"[^\"]*\\\")");
    public static final String CUSTOM_UPDATE = "ice.customUpdate";
    public static final String DATA_ELEMENTUPDATE = "data-elementupdate";
    private PartialViewContext wrapped;
    protected FacesContext facesContext;
    private PartialResponseWriter partialWriter;
    private Boolean isAjaxRequest;
    private DOMUtils.DiffConfig diffConfig = null;
    private boolean clientSideElementUpdateDetermination;
    private static final Runnable NOOP = new Runnable(){

        public void run() {
        }
    };

    public DOMPartialViewContext(PartialViewContext partialViewContext, FacesContext facesContext) {
        this.wrapped = partialViewContext;
        this.facesContext = facesContext;
        this.clientSideElementUpdateDetermination = EnvUtils.isClientSideElementUpdateDetermination(facesContext);
    }

    public PartialViewContext getWrapped() {
        return this.wrapped;
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.wrapped.setPartialRequest(isPartialRequest);
    }

    public boolean isAjaxRequest() {
        if (this.isAjaxRequest != null) {
            return this.isAjaxRequest;
        }
        return this.wrapped.isAjaxRequest();
    }

    public void setAjaxRequest(boolean isAjaxRequest) {
        this.isAjaxRequest = isAjaxRequest;
    }

    /*
     * WARNING - void declaration
     */
    public void processPartial(PhaseId phaseId) {
        if (!EnvUtils.isICEfacesView(this.facesContext)) {
            this.wrapped.processPartial(phaseId);
            return;
        }
        if (!this.isRenderAll() && !EnvUtils.isSubtreeDiff(this.facesContext)) {
            this.wrapped.processPartial(phaseId);
            return;
        }
        ExternalContext ec = this.facesContext.getExternalContext();
        String customUpdate = (String)ec.getRequestParameterMap().get(CUSTOM_UPDATE);
        if ("true".equals(customUpdate)) {
            this.wrapped.processPartial(phaseId);
            return;
        }
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            try {
                PartialResponseWriter partialWriter = this.getPartialResponseWriter();
                Writer outputWriter = this.getResponseOutputWriter();
                ec.setResponseContentType("text/xml");
                ec.addResponseHeader("Cache-Control", "no-cache");
                String diffConfigString = EnvUtils.getDiffConfig(this.facesContext);
                if (null != diffConfigString) {
                    this.diffConfig = new DOMUtils.DiffConfig(diffConfigString);
                }
                DOMResponseWriter writer = new DOMResponseWriter(outputWriter, ec.getResponseCharacterEncoding(), ec.getResponseContentType());
                this.facesContext.setResponseWriter((ResponseWriter)writer);
                Document oldDOM = writer.getOldDocument();
                UIViewRoot viewRoot = this.facesContext.getViewRoot();
                if (oldDOM != null) {
                    this.applyBrowserChanges(this.getRenderIds(), this.getExecuteIds(), ec.getRequestParameterValuesMap(), oldDOM);
                    writer.setDocument(oldDOM);
                    writer.saveOldDocument();
                }
                List<DOMUtils.EditOperation> diffs = null;
                Collection<String> customIds = null;
                Document newDOM = null;
                List<DocumentOperation> documentOperations = null;
                writer.startDocument();
                if (this.isRenderAll()) {
                    for (UIComponent kid : viewRoot.getChildren()) {
                        kid.encodeAll(this.facesContext);
                    }
                    writer.endDocument();
                    newDOM = writer.getOldDocument();
                    if (oldDOM != null && newDOM != null) {
                        diffs = this.domDiff(oldDOM, newDOM);
                    }
                } else {
                    writer.startSubtreeRendering(oldDOM);
                    Collection renderIds = this.getRenderIds();
                    customIds = this.getCustomIds(customUpdate);
                    if (null != customIds) {
                        renderIds.removeAll(customIds);
                    }
                    if (renderIds != null && !renderIds.isEmpty()) {
                        DOMPartialRenderCallback visitor = this.renderSubtrees(viewRoot, renderIds);
                        diffs = visitor.getDiffs();
                        documentOperations = visitor.getDocumentOperations();
                    }
                    writer.endDocument();
                    newDOM = writer.getOldDocument();
                }
                partialWriter.startDocument();
                if (null != customIds) {
                    this.customRenderSubtrees(viewRoot, customIds);
                }
                String viewState = this.facesContext.getApplication().getStateManager().getViewState(this.facesContext);
                this.facesContext.getExternalContext().getRequestMap().put("javax.faces.ViewState", viewState);
                if (null == oldDOM && this.isRenderAll()) {
                    void var16_21;
                    if (EnvUtils.generateHeadUpdate(this.facesContext)) {
                        Node head = newDOM.getElementsByTagName("head").item(0);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("type", JAVAX_FACES_VIEW_HEAD);
                        partialWriter.startExtension(hashMap);
                        partialWriter.startCDATA();
                        DOMUtils.printNodeCDATA(head, (Writer)partialWriter);
                        partialWriter.endCDATA();
                        partialWriter.endExtension();
                    }
                    Node body = newDOM.getElementsByTagName("body").item(0);
                    String string = JAVAX_FACES_VIEW_BODY;
                    if (body == null && EnvUtils.instanceofPortletRequest(this.facesContext.getExternalContext().getRequest())) {
                        body = newDOM.getDocumentElement();
                        String string2 = JAVAX_FACES_VIEW_ROOT;
                    }
                    if (!this.clientSideElementUpdateDetermination) {
                        partialWriter.startEval();
                        partialWriter.writeText((Object)"ice.notifyAllOnElementUpdateCallbacks();", null);
                        partialWriter.endEval();
                    }
                    partialWriter.startUpdate((String)var16_21);
                    DOMUtils.printNodeCDATA(body, outputWriter);
                    partialWriter.endUpdate();
                } else if (null != diffs) {
                    for (DOMUtils.EditOperation editOperation : diffs) {
                        String tagName = "";
                        if (null != editOperation.element && editOperation.element instanceof Element) {
                            tagName = ((Element)editOperation.element).getTagName();
                        }
                        if ("head".equalsIgnoreCase(tagName) || JAVAX_FACES_VIEW_HEAD.equals(editOperation.id)) {
                            if (!EnvUtils.generateHeadUpdate(this.facesContext)) continue;
                            HashMap<String, String> attributes = new HashMap<String, String>();
                            attributes.put("type", JAVAX_FACES_VIEW_HEAD);
                            partialWriter.startExtension(attributes);
                            partialWriter.startCDATA();
                            DOMUtils.printNodeCDATA(editOperation.element, (Writer)partialWriter);
                            partialWriter.endCDATA();
                            partialWriter.endExtension();
                            continue;
                        }
                        if (editOperation instanceof DOMUtils.InsertOperation) {
                            partialWriter.startInsertAfter(editOperation.id);
                            DOMUtils.printNodeCDATA(editOperation.element, outputWriter);
                            partialWriter.endInsert();
                            continue;
                        }
                        if (editOperation instanceof DOMUtils.DeleteOperation) {
                            if (!this.clientSideElementUpdateDetermination) {
                                DOMPartialViewContext.generateElementUpdateNotifications(editOperation, partialWriter, oldDOM);
                            }
                            partialWriter.delete(editOperation.id);
                            continue;
                        }
                        if (editOperation instanceof DOMUtils.AttributeOperation) {
                            partialWriter.updateAttributes(editOperation.id, editOperation.attributes);
                            continue;
                        }
                        if (!(editOperation instanceof DOMUtils.ReplaceOperation)) continue;
                        String updateId = editOperation.id;
                        if (null == editOperation.id) {
                            updateId = DOMPartialViewContext.getUpdateId((Element)editOperation.element);
                        }
                        if (!this.clientSideElementUpdateDetermination) {
                            DOMPartialViewContext.generateElementUpdateNotifications(editOperation, partialWriter, oldDOM);
                        }
                        partialWriter.startUpdate(updateId);
                        DOMUtils.printNodeCDATA(editOperation.element, outputWriter);
                        partialWriter.endUpdate();
                    }
                }
                if (documentOperations != null && oldDOM != null) {
                    for (DocumentOperation documentOperation : documentOperations) {
                        documentOperation.operateOn(oldDOM);
                    }
                    writer.setDocument(oldDOM);
                    writer.saveOldDocument();
                }
                this.renderState(viewState);
                this.renderExtensions();
                this.renderFixViewState(viewState);
                this.runScripts();
                partialWriter.endDocument();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw ex;
            }
        } else {
            super.processPartial(phaseId);
        }
    }

    private static void generateElementUpdateNotifications(DOMUtils.EditOperation op, PartialResponseWriter partialWriter, Document oldDOM) throws IOException {
        Element e;
        String id = op.id == null ? (op.element instanceof Element ? ((Element)op.element).getAttribute("id") : null) : op.id;
        if (id == null) {
            log.warning("Cannot search for onElementUpdate markers into the update " + op);
            return;
        }
        Element element = e = oldDOM == null ? null : oldDOM.getElementById(id);
        if (e != null) {
            ArrayList<String> collectedIDs = new ArrayList<String>();
            if (e.hasAttribute(DATA_ELEMENTUPDATE)) {
                collectedIDs.add(e.getAttribute("id"));
            }
            NodeList elements = e.getElementsByTagName("*");
            for (int i = 0; i < elements.getLength(); ++i) {
                Element child = (Element)elements.item(i);
                if (!child.hasAttribute(DATA_ELEMENTUPDATE)) continue;
                collectedIDs.add(child.getAttribute("id"));
            }
            if (!collectedIDs.isEmpty()) {
                partialWriter.startEval();
                partialWriter.writeText((Object)("ice.notifyOnElementUpdateCallbacks(['" + DOMPartialViewContext.join(collectedIDs, "','") + "']);"), null);
                partialWriter.endEval();
            }
        }
    }

    private static String join(Collection collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator iter = collection.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            sb.append(delimiter);
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    protected Writer getResponseOutputWriter() throws IOException {
        return this.facesContext.getExternalContext().getResponseOutputWriter();
    }

    private void writeXMLPreamble(Writer writer) throws IOException {
        FacesContext fc = FacesContext.getCurrentInstance();
        UIViewRoot root = fc.getViewRoot();
        Object val = root.getAttributes().get("<?xml");
        if (val != null) {
            writer.write(val.toString());
        }
        if ((val = root.getAttributes().get("<!DOCTYPE")) != null) {
            writer.write(val.toString());
        }
    }

    private Collection<String> getCustomIds(String idList) {
        if (null == idList) {
            return null;
        }
        String[] ids = SPACE_SEPARATED.split(idList);
        return new ArrayList<String>(Arrays.asList(ids));
    }

    private static String getUpdateId(Element element) {
        if ("head".equalsIgnoreCase(element.getTagName())) {
            return JAVAX_FACES_VIEW_HEAD;
        }
        if ("body".equalsIgnoreCase(element.getTagName())) {
            return JAVAX_FACES_VIEW_BODY;
        }
        return element.getAttribute("id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DOMUtils.EditOperation> domDiff(Document oldDOM, Document newDOM) {
        Runnable oldHeadRollback = DOMPartialViewContext.setHeadID(oldDOM);
        Runnable oldBodyRollback = DOMPartialViewContext.setBodyID(oldDOM);
        Runnable newHeadRollback = DOMPartialViewContext.setHeadID(newDOM);
        Runnable newBodyRollback = DOMPartialViewContext.setBodyID(newDOM);
        try {
            List<DOMUtils.EditOperation> list = DOMUtils.domDiff(this.diffConfig, oldDOM, newDOM);
            return list;
        }
        finally {
            oldHeadRollback.run();
            oldBodyRollback.run();
            newHeadRollback.run();
            newBodyRollback.run();
        }
    }

    private static Runnable setBodyID(Document document) {
        Element body;
        NodeList nodes = document.getElementsByTagName("body");
        if (nodes.getLength() > 0 && !(body = (Element)nodes.item(0)).hasAttribute("id")) {
            body.setAttribute("id", JAVAX_FACES_VIEW_BODY);
            return new Runnable(){

                public void run() {
                    body.removeAttribute("id");
                }
            };
        }
        return NOOP;
    }

    private static Runnable setHeadID(Document document) {
        Element head;
        NodeList nodes = document.getElementsByTagName("head");
        if (nodes.getLength() > 0 && !(head = (Element)nodes.item(0)).hasAttribute("id")) {
            head.setAttribute("id", JAVAX_FACES_VIEW_HEAD);
            return new Runnable(){

                public void run() {
                    head.removeAttribute("id");
                }
            };
        }
        return NOOP;
    }

    private void customRenderSubtrees(UIViewRoot viewRoot, Collection<String> renderIds) {
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)this.facesContext, renderIds, hints);
        CustomPartialRenderCallback renderCallback = new CustomPartialRenderCallback(this.facesContext);
        viewRoot.visitTree(visitContext, (VisitCallback)renderCallback);
    }

    private DOMPartialRenderCallback renderSubtrees(UIViewRoot viewRoot, Collection<String> renderIds) {
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)this.facesContext, renderIds, hints);
        DOMPartialRenderCallback renderCallback = new DOMPartialRenderCallback(this.diffConfig, this.facesContext);
        viewRoot.visitTree(visitContext, (VisitCallback)renderCallback);
        return renderCallback;
    }

    private boolean shouldApplyChange(Collection<String> ids, String id, Document document) {
        if (ids.contains("@all")) {
            return true;
        }
        if (ids.contains(id)) {
            return true;
        }
        for (Node cursor = document.getElementById(id); cursor != null && cursor instanceof Element; cursor = cursor.getParentNode()) {
            String parentID = cursor.getAttribute("id");
            if (!ids.contains(parentID)) continue;
            return true;
        }
        return false;
    }

    private void applyBrowserChanges(Collection<String> renderIds, Collection<String> executeIds, Map parameters, Document document) {
        String[] values;
        if (null == document) {
            return;
        }
        NodeList inputElements = document.getElementsByTagName("input");
        int inputElementsLength = inputElements.getLength();
        for (int i = 0; i < inputElementsLength; ++i) {
            String currValue;
            String type;
            Element inputElement = (Element)inputElements.item(i);
            String id = inputElement.getAttribute("id");
            if (id == null || "".equals(id)) continue;
            if (parameters.containsKey(id) && this.shouldApplyChange(executeIds, id, document) && this.shouldApplyChange(renderIds, id, document)) {
                String value = "";
                Object rawValue = parameters.get(id);
                if (rawValue != null && rawValue instanceof String[]) {
                    value = ((String[])rawValue)[0];
                }
                if ("".equals(value)) {
                    inputElement.setAttribute("value", "");
                    continue;
                }
                if (inputElement.getAttribute("type").equals("checkbox")) {
                    inputElement.setAttribute("checked", "checked");
                    continue;
                }
                inputElement.setAttribute("value", value);
                continue;
            }
            String name = inputElement.getAttribute("name");
            if ("".equals(name) || !parameters.containsKey(name) || !this.shouldApplyChange(executeIds, id, document) || !this.shouldApplyChange(renderIds, id, document) || (type = inputElement.getAttribute("type")) == null || !type.equals("checkbox") && !type.equals("radio") || "".equals(currValue = inputElement.getAttribute("value"))) continue;
            boolean found = false;
            values = (String[])parameters.get(name);
            if (values != null) {
                for (int v = 0; v < values.length; ++v) {
                    if (!currValue.equals(values[v])) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                if (type.equals("checkbox")) {
                    inputElement.setAttribute("checked", "true");
                    continue;
                }
                if (!type.equals("radio")) continue;
                inputElement.setAttribute("checked", "checked");
                continue;
            }
            inputElement.removeAttribute("checked");
        }
        NodeList textareaElements = document.getElementsByTagName("textarea");
        int textareaElementsLength = textareaElements.getLength();
        for (int i = 0; i < textareaElementsLength; ++i) {
            Element textareaElement = (Element)textareaElements.item(i);
            String id = textareaElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id) || !this.shouldApplyChange(executeIds, id, document) || !this.shouldApplyChange(renderIds, id, document)) continue;
            String value = ((String[])parameters.get(id))[0];
            Node firstChild = textareaElement.getFirstChild();
            if (null != firstChild) {
                String escapedValue = DOMUtils.escapeAnsi(value);
                firstChild.setNodeValue(escapedValue);
                continue;
            }
            if (value == null || value.length() <= 0) continue;
            textareaElement.appendChild(document.createTextNode(value));
        }
        NodeList selectElements = document.getElementsByTagName("select");
        int selectElementsLength = selectElements.getLength();
        for (int i = 0; i < selectElementsLength; ++i) {
            Node optionBodyNode;
            Element selectElement = (Element)selectElements.item(i);
            String id = selectElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id) || !this.shouldApplyChange(executeIds, id, document) || !this.shouldApplyChange(renderIds, id, document)) continue;
            values = Arrays.asList((String[])parameters.get(id));
            NodeList optionElements = selectElement.getElementsByTagName("option");
            int optionElementsLength = optionElements.getLength();
            for (int j = 0; j < optionElementsLength; ++j) {
                Element optionElement = (Element)optionElements.item(j);
                if (values.contains(optionElement.getAttribute("value"))) {
                    optionElement.setAttribute("selected", "selected");
                    continue;
                }
                optionElement.removeAttribute("selected");
            }
            if (0 != optionElementsLength || (optionBodyNode = selectElement.getFirstChild()) == null) continue;
            String optionBody = optionBodyNode.getNodeValue();
            String SELECTED = "selected=\"true\"";
            Matcher tagMatcher = OPTION_TAG.matcher(Matcher.quoteReplacement(optionBody));
            StringBuffer outBuffer = new StringBuffer();
            while (tagMatcher.find()) {
                String optionTag = tagMatcher.group(0);
                Matcher valueMatcher = OPTION_VALUE.matcher(optionTag);
                Matcher selectedMatcher = OPTION_SELECTED.matcher(optionTag);
                String valuePair = null;
                String value = null;
                String selected = null;
                if (valueMatcher.find()) {
                    valuePair = valueMatcher.group(0);
                    value = valueMatcher.group(1);
                }
                if (selectedMatcher.find()) {
                    SELECTED = selected = selectedMatcher.group(1);
                }
                if (values.contains(value)) {
                    if (null == selected) {
                        optionTag = optionTag.replace(valuePair, valuePair + " " + SELECTED);
                    }
                } else if (null != selected) {
                    optionTag = optionTag.replace(" " + selected, "");
                }
                tagMatcher.appendReplacement(outBuffer, optionTag.replace("\"", "\\\""));
            }
            tagMatcher.appendTail(outBuffer);
            optionBodyNode.setNodeValue(outBuffer.toString());
        }
    }

    private void renderFixViewState(String viewState) throws IOException {
        Map facesMap = this.facesContext.getAttributes();
        ArrayList formIdList = (ArrayList)facesMap.get("ice.faces.formList");
        if (formIdList == null || formIdList.isEmpty()) {
            return;
        }
        String escapedViewState = DOMPartialViewContext.escapeJSString(viewState);
        StringBuilder buff = new StringBuilder("var iceFormIdList=[");
        for (int i = 0; i < formIdList.size(); ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            String fullFormId = (String)formIdList.get(i);
            buff.append("'").append(fullFormId).append("'");
        }
        buff.append("]; ice.fixViewStates(iceFormIdList,'").append(escapedViewState).append("');");
        JavaScriptRunner.runScript(this.facesContext, buff.toString());
    }

    private static String escapeJSString(String text) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\"') {
                result.append("\\\"");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '/') {
                result.append("\\/");
            } else if (character == '\b') {
                result.append("\\b");
            } else if (character == '\f') {
                result.append("\\f");
            } else if (character == '\n') {
                result.append("\\n");
            } else if (character == '\r') {
                result.append("\\r");
            } else if (character == '\t') {
                result.append("\\t");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    private String renderState(String viewState) throws IOException {
        Map facesMap = this.facesContext.getAttributes();
        PartialResponseWriter writer = this.getPartialResponseWriter();
        if (EnvUtils.isJSF22OrGreater()) {
            ArrayList formIdList = (ArrayList)facesMap.get("ice.faces.formList");
            if (formIdList != null && !formIdList.isEmpty()) {
                UIViewRoot viewRoot = this.facesContext.getViewRoot();
                String viewRootId = viewRoot.getId();
                char separator = UINamingContainer.getSeparatorChar((FacesContext)this.facesContext);
                for (int i = 0; i < formIdList.size(); ++i) {
                    writer.startUpdate(viewRootId + separator + "javax.faces.ViewState" + separator + i);
                    writer.write(viewState);
                    writer.endUpdate();
                }
            }
        } else {
            writer.startUpdate("javax.faces.ViewState");
            writer.write(viewState);
            writer.endUpdate();
        }
        return viewState;
    }

    protected void renderExtensions() {
        this.manageFocus();
    }

    private void manageFocus() {
        if (EnvUtils.isFocusManaged(FacesContext.getCurrentInstance())) {
            boolean focusNotYetSet;
            String focusId = FocusController.getReceivedFocus(this.facesContext);
            boolean bl = focusNotYetSet = !FocusController.isFocusSet(this.facesContext);
            if (focusNotYetSet && focusId != null) {
                FocusController.setFocus(this.facesContext, focusId);
            }
            if (FocusController.isFocusSet(this.facesContext)) {
                JavaScriptRunner.runScript(this.facesContext, "ice.applyFocus('" + FocusController.getFocus(this.facesContext) + "');");
            }
        }
    }

    private void runScripts() {
        String scripts = JavaScriptRunner.collateScripts(this.facesContext);
        if (scripts.length() > 0) {
            try {
                PartialResponseWriter partialWriter = this.getPartialResponseWriter();
                partialWriter.startEval();
                partialWriter.write(scripts);
                partialWriter.endEval();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

