/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.context;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.icefaces.impl.context.BasicResponseWriter;
import org.icefaces.impl.fastinfoset.com.sun.xml.fastinfoset.dom.DOMDocumentParser;
import org.icefaces.impl.fastinfoset.com.sun.xml.fastinfoset.dom.DOMDocumentSerializer;
import org.icefaces.impl.fastinfoset.org.jvnet.fastinfoset.FastInfosetException;
import org.icefaces.impl.util.DOMUtils;
import org.icefaces.util.EnvUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMResponseWriter
extends ResponseWriterWrapper {
    private static Logger log = Logger.getLogger("org.icefaces.impl.context.DOMResponseWriter");
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String encoding;
    public static final String DEFAULT_TYPE = "text/html";
    private String contentType;
    public static final String OLD_DOM = "org.icefaces.old-dom";
    protected static final String XML_MARKER = "<?xml";
    protected static final String DOCTYPE_MARKER = "<!DOCTYPE";
    private Writer writer;
    private ResponseWriter wrapped;
    private Document document;
    private Node cursor;
    private List<Node> stateNodes = new ArrayList<Node>();
    private boolean suppressNextNode = false;
    private boolean dontEscape;
    private boolean isScript;
    private boolean isStyle;

    public DOMResponseWriter(Writer writer, String encoding, String contentType) {
        this.writer = writer;
        if (writer instanceof ResponseWriter) {
            this.wrapped = (ResponseWriter)writer;
        }
        this.encoding = encoding != null ? encoding : DEFAULT_ENCODING;
        this.contentType = contentType != null ? contentType : DEFAULT_TYPE;
    }

    public ResponseWriter getWrapped() {
        return this.wrapped;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void writeDoctype(String doctype) throws IOException {
        this.processXMLPreamble(doctype);
    }

    public void writePreamble(String preamble) throws IOException {
        this.processXMLPreamble(preamble);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        block6: {
            if (this.suppressNextNode) {
                return;
            }
            if (0 == len) {
                return;
            }
            if (null == this.document) {
                this.writer.write(cbuf, off, len);
                return;
            }
            try {
                String data = new String(cbuf, off, len);
                if (data.startsWith(XML_MARKER) || data.startsWith(DOCTYPE_MARKER)) {
                    this.processXMLPreamble(data);
                    return;
                }
                this.appendToCursor(data);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.INFO)) break block6;
                log.log(Level.INFO, "cannot write " + new String(cbuf, off, len), e);
            }
        }
    }

    private void processXMLPreamble(String data) throws IOException {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (EnvUtils.instanceofPortletRequest(fc.getExternalContext().getRequest())) {
            return;
        }
        PartialViewContext pvc = fc.getPartialViewContext();
        if (pvc != null && pvc.isAjaxRequest()) {
            if (data.startsWith(XML_MARKER)) {
                this.storeViewAttribute(XML_MARKER, data);
            }
            if (data.startsWith(DOCTYPE_MARKER)) {
                this.storeViewAttribute(DOCTYPE_MARKER, data);
            }
        } else {
            this.writer.write(data);
        }
    }

    private void storeViewAttribute(String key, Object value) {
        FacesContext fc = FacesContext.getCurrentInstance();
        UIViewRoot root = fc.getViewRoot();
        root.getAttributes().put(key, value);
    }

    public void write(String str) throws IOException {
        if ("".equals(str)) {
            return;
        }
        if (EnvUtils.getStateMarker().equals(str)) {
            Text stateNode = this.document.createTextNode(str);
            this.stateNodes.add(stateNode);
            this.appendToCursor(stateNode);
            return;
        }
        if (null == this.document) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.writer.getClass() + " raw write str " + str);
            }
            this.writer.write(str);
            return;
        }
        try {
            if (this.cursor == null) {
                Element doc = this.document.getDocumentElement();
                this.cursor = doc != null ? doc : this.document;
            }
            if (this.cursor.getNodeType() == 4) {
                CDATASection section = (CDATASection)this.cursor;
                section.appendData(str);
            } else {
                this.appendToCursor(this.document.createTextNode(str));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "failed to write " + str, e);
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public void startDocument() throws IOException {
        this.document = DOMUtils.getNewDocument();
        this.cursor = this.document;
    }

    public void endDocument() throws IOException {
        String value;
        FacesContext context = FacesContext.getCurrentInstance();
        boolean isPartialRequest = context.getPartialViewContext().isPartialRequest();
        if (context.isProjectStage(ProjectStage.Development) && log.isLoggable(Level.WARNING) && this.cursor != this.document) {
            this.logUnclosedNode(this.document);
        }
        Element documentElement = this.document.getDocumentElement();
        String diffConfig = EnvUtils.getDiffConfig(context);
        if (diffConfig != null && diffConfig.indexOf("att") > -1 && documentElement != null && ((value = documentElement.getAttribute("id")) == null || value.length() == 0)) {
            documentElement.setAttribute("id", "javax_faces_viewroot");
        }
        if (!isPartialRequest) {
            if (EnvUtils.isMojarra()) {
                DOMUtils.printNode(this.document, this.writer);
            } else if (EnvUtils.isMyFaces()) {
                DOMUtils.printNode(this.document, new WriteViewStateMarkup(this.writer));
            }
        }
        if (null != documentElement) {
            for (Node stateNode : this.stateNodes) {
                Node parent = stateNode.getParentNode();
                if (parent != null) {
                    parent.removeChild(stateNode);
                    continue;
                }
                log.fine("could not remove state node " + stateNode + " as it had no parent");
            }
            this.stateNodes.clear();
            this.saveOldDocument();
        }
        this.document = null;
        this.cursor = null;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (this.suppressNextNode) {
            this.suppressNextNode = false;
            return;
        }
        this.isScriptOrStyle(name);
        if (null == this.document) {
            this.document = DOMUtils.getNewDocument();
        }
        this.pointCursorAt(this.appendToCursor(this.document.createElement(name)));
        if (FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development)) {
            this.cursor.setUserData("closed", Boolean.FALSE, null);
        }
    }

    public void endElement(String name) throws IOException {
        if (FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development)) {
            if (log.isLoggable(Level.WARNING) && this.cursor.getUserData("closed") != null && !this.cursor.getNodeName().equals(name)) {
                this.logUnclosedNode(this.cursor);
            }
            this.cursor.setUserData("closed", Boolean.TRUE, null);
        }
        this.pointCursorAt(this.cursor.getParentNode());
    }

    private void logUnclosedNode(Node node) {
        if (node == null) {
            return;
        }
        StringBuilder path = new StringBuilder();
        for (Node tempCursor = node; tempCursor != null; tempCursor = tempCursor.getParentNode()) {
            if (tempCursor != node) {
                path.insert(0, " -> ");
            }
            path.insert(0, tempCursor.getNodeName());
        }
        Node idNode = node.hasAttributes() ? node.getAttributes().getNamedItem("id") : null;
        log.log(Level.WARNING, "Missing end-element for: " + node.getNodeName() + (idNode == null ? "" : "[" + idNode.toString() + "]") + " (path: " + path + ")");
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (null == value) {
            return;
        }
        if (EnvUtils.isMyFaces() && name != null && name.equalsIgnoreCase("name") && value instanceof String && ((String)value).equalsIgnoreCase("javax.faces.ViewState")) {
            this.stateNodes.add(this.cursor);
        }
        Attr attribute = this.document.createAttribute(name.trim());
        attribute.setValue(String.valueOf(value));
        this.appendToCursor(attribute);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        String stringValue = String.valueOf(value);
        if (stringValue.startsWith("javascript:")) {
            this.writeAttribute(name, stringValue, property);
        } else {
            this.writeAttribute(name, stringValue.replace(' ', '+'), property);
        }
    }

    public void writeComment(Object comment) throws IOException {
        String commentString = String.valueOf(comment);
        if (null == this.document) {
            this.writer.write(commentString);
            return;
        }
        this.appendToCursor(this.document.createComment(commentString));
    }

    public void writeText(Object text, String property) throws IOException {
        if (this.suppressNextNode) {
            return;
        }
        if (text == null) {
            throw new NullPointerException("WriteText method cannot write null text");
        }
        String textString = String.valueOf(text);
        if (textString.length() == 0) {
            return;
        }
        if (!this.dontEscape) {
            textString = DOMUtils.escapeAnsi(textString);
        }
        this.appendToCursor(textString);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (this.suppressNextNode) {
            return;
        }
        if (len == 0) {
            return;
        }
        this.writeText(new String(text, off, len), null);
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        this.writeText(text, property);
    }

    public void startCDATA() throws IOException {
        if (null == this.document) {
            this.document = DOMUtils.getNewDocument();
        }
        this.pointCursorAt(this.appendToCursor(this.document.createCDATASection("")));
    }

    public void endCDATA() throws IOException {
        this.pointCursorAt(this.cursor.getParentNode());
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        String enc = this.getCharacterEncoding();
        String type = this.getContentType();
        if (writer instanceof ResponseWriter) {
            this.wrapped = (ResponseWriter)writer;
            enc = this.wrapped.getCharacterEncoding();
            type = this.wrapped.getContentType();
        }
        ResponseWriterWrapper clone = null;
        clone = writer.getClass().getName().endsWith("FastStringWriter") ? new BasicResponseWriter(writer, enc, type) : new DOMResponseWriter(writer, enc, type);
        return clone;
    }

    private Node appendToCursor(String data) {
        if (this.cursor == null) {
            Element doc = this.document.getDocumentElement();
            this.cursor = doc != null ? doc : this.document;
        }
        if (this.cursor.getNodeType() == 4) {
            CDATASection section = (CDATASection)this.cursor;
            section.appendData(data);
            return section;
        }
        return this.appendToCursor(this.document.createTextNode(data));
    }

    private Node appendToCursor(Node node) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("appending " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor));
            }
            if (this.cursor == null) {
                Element doc = this.document.getDocumentElement();
                this.cursor = doc != null ? doc : this.document;
            }
            return this.cursor.appendChild(node);
        }
        catch (DOMException e) {
            String message = "failed to append " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor);
            log.log(Level.SEVERE, message, e);
            throw new RuntimeException(message, e);
        }
    }

    private Node appendToCursor(Attr node) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Appending " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor));
            }
            Attr result = ((Element)this.cursor).setAttributeNode(node);
            if ("id".equals(node.getName())) {
                ((Element)this.cursor).setIdAttributeNode(node, true);
            }
            return result;
        }
        catch (DOMException e) {
            String message = "failed to append " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor);
            log.log(Level.SEVERE, message, e);
            throw new RuntimeException(message, e);
        }
        catch (ClassCastException e) {
            String message = "cursor is not an element: " + DOMUtils.toDebugString(this.cursor);
            log.log(Level.SEVERE, message, e);
            throw new RuntimeException(message, e);
        }
    }

    private void pointCursorAt(Node node) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("moving cursor to " + DOMUtils.toDebugString(node));
        }
        this.cursor = node;
    }

    public void startSubtreeRendering(Document doc) {
        if (doc == null && (doc = this.getOldDocument()) == null) {
            this.refreshDocument();
            return;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void saveOldDocument() throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!EnvUtils.isCompressDOM(facesContext)) {
            facesContext.getViewRoot().getViewMap().put(OLD_DOM, this.document);
            return;
        }
        byte[] data = DOMResponseWriter.serializeDocument(this.document);
        facesContext.getViewRoot().getViewMap().put(OLD_DOM, data);
    }

    private static byte[] serializeDocument(Document document) throws IOException {
        DOMDocumentSerializer serializer = new DOMDocumentSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream(10000);
        serializer.setOutputStream(out);
        serializer.serialize(document);
        byte[] data = out.toByteArray();
        return data;
    }

    public Document getOldDocument() {
        return DOMResponseWriter.getOldDocument(FacesContext.getCurrentInstance());
    }

    public static Document getOldDocument(FacesContext facesContext) {
        Object oldDOMObject = facesContext.getViewRoot().getViewMap().get(OLD_DOM);
        if (null == oldDOMObject) {
            return null;
        }
        if (!EnvUtils.isCompressDOM(facesContext)) {
            return (Document)oldDOMObject;
        }
        try {
            return DOMResponseWriter.deserializeDocument((byte[])oldDOMObject);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to restore old DOM ", e);
            return DOMUtils.getNewDocument();
        }
    }

    private static Document deserializeDocument(byte[] data) throws FastInfosetException, IOException {
        Document document = DOMUtils.getNewDocument();
        document.setStrictErrorChecking(false);
        DOMDocumentParser parser = new DOMDocumentParser();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        parser.parse(document, in);
        return document;
    }

    public Node getCursorParent() {
        return this.cursor;
    }

    public void setCursorParent(Node cursorParent) {
        this.cursor = cursorParent;
    }

    private void refreshDocument() {
        this.document = DOMUtils.getNewDocument();
        Element root = this.document.createElement("html");
        this.document.appendChild(root);
        this.cursor = this.document.getDocumentElement();
    }

    public void setDocument(Document doc) {
        this.document = doc;
        this.cursor = doc;
    }

    private boolean isScriptOrStyle(String name) {
        if ("script".equalsIgnoreCase(name)) {
            this.isScript = true;
            this.dontEscape = true;
        } else if ("style".equalsIgnoreCase(name)) {
            this.isStyle = true;
            this.dontEscape = true;
        } else {
            this.isScript = false;
            this.isStyle = false;
            this.dontEscape = false;
        }
        return this.isScript || this.isStyle;
    }

    private class WriteViewStateMarkup
    extends FilterWriter {
        protected WriteViewStateMarkup(Writer out) {
            super(out);
        }

        public void write(String str) throws IOException {
            if (EnvUtils.getStateMarker().equals(str)) {
                FacesContext fc = FacesContext.getCurrentInstance();
                this.out.write("<input id=\"javax.faces.ViewState\" type=\"hidden\" autocomplete=\"off\" value=\"");
                this.out.write(fc.getApplication().getStateManager().getViewState(fc));
                this.out.write("\" name=\"javax.faces.ViewState\"/>");
            } else {
                this.out.write(str);
            }
        }
    }
}

