/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.context;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.icefaces.impl.context.AjaxForcedRequestWrapper;
import org.icefaces.impl.context.ICEfacesContext;
import org.icefaces.util.EnvUtils;

public class ICEFacesContextFactory
extends FacesContextFactory {
    private static Logger log = Logger.getLogger(ICEFacesContextFactory.class.getName());
    public static String AJAX_FORCED_VIEWS = "org.icefaces.ajaxforcedviews";
    FacesContextFactory delegate;

    public ICEFacesContextFactory(FacesContextFactory delegate) {
        this.delegate = delegate;
    }

    public FacesContextFactory getWrapped() {
        return this.delegate;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) {
        Object wrappedRequest = request;
        Object ajaxForcedViews = null;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest servletRequest = (HttpServletRequest)request;
            HttpSession session = servletRequest.getSession(false);
            if (null != session) {
                ajaxForcedViews = session.getAttribute(AJAX_FORCED_VIEWS);
            }
            if (null != ajaxForcedViews) {
                wrappedRequest = this.wrapIfMultipart(servletRequest);
            }
        }
        FacesContext nativeFacesContext = this.delegate.getFacesContext(context, wrappedRequest, response, lifecycle);
        if (!EnvUtils.isWebSpherePortal()) {
            this.setCharacterEncoding(nativeFacesContext);
        }
        return new ICEfacesContext(nativeFacesContext);
    }

    private Object wrapIfMultipart(HttpServletRequest request) {
        if (null != request.getContentType() && request.getContentType().contains("multipart")) {
            return new AjaxForcedRequestWrapper(request);
        }
        return request;
    }

    private void setCharacterEncoding(FacesContext context) {
        block6: {
            String calculatedEncoding = EnvUtils.calculateCharacterEncoding(context);
            if (null != calculatedEncoding) {
                ExternalContext ec = context.getExternalContext();
                String currentEncoding = ec.getRequestCharacterEncoding();
                try {
                    if (!calculatedEncoding.equals(currentEncoding)) {
                        ec.setRequestCharacterEncoding(calculatedEncoding);
                    }
                    break block6;
                }
                catch (UnsupportedEncodingException e) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.warning("can't set encoding to [" + calculatedEncoding + "], current encoding is [" + currentEncoding + "]");
                    }
                    break block6;
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("character encoding could not be determined");
            }
        }
    }
}

