/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.PortletRequest;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.icefaces.impl.context.DOMResponseWriter;
import org.icefaces.util.EnvUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeltaSubmitPhaseListener
implements PhaseListener {
    public static final String PreviousParameters = "previous-parameters";
    private static final String[] StringArray = new String[0];
    private static final Logger log = Logger.getLogger("org.icefaces.event");
    private static final String Append = "patch+";
    private static final String Subtract = "patch-";

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (EnvUtils.isDeltaSubmit(facesContext)) {
            this.reconstructParametersFromDeltaSubmit(facesContext);
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.APPLY_REQUEST_VALUES;
    }

    private void reconstructParametersFromDeltaSubmit(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map submittedParameters = externalContext.getRequestParameterValuesMap();
        String[] deltaSubmitFormValues = (String[])submittedParameters.get("ice.deltasubmit.form");
        if (deltaSubmitFormValues == null) {
            return;
        }
        Document oldDOM = DOMResponseWriter.getOldDocument(facesContext);
        Map previousParameters = this.calculateParametersFromDOM(externalContext, oldDOM);
        HashMap<String, String[]> parameterValuesMap = new HashMap<String, String[]>(previousParameters);
        ArrayList<String> directParameters = new ArrayList<String>();
        for (Map.Entry entry : submittedParameters.entrySet()) {
            ArrayList<String> allValues;
            String[] previousValues;
            String key;
            String patchKey = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (patchKey.startsWith(Append)) {
                key = patchKey.substring(6);
                previousValues = (String[])parameterValuesMap.get(key);
                if (previousValues == null) {
                    parameterValuesMap.put(key, values);
                    continue;
                }
                allValues = new ArrayList<String>();
                allValues.addAll(Arrays.asList(previousValues));
                allValues.addAll(Arrays.asList(values));
                parameterValuesMap.put(key, allValues.toArray(StringArray));
                continue;
            }
            if (patchKey.startsWith(Subtract)) {
                key = patchKey.substring(6);
                previousValues = (String[])parameterValuesMap.get(key);
                if (previousValues == null) {
                    log.fine("Missing previous parameters: " + key);
                    continue;
                }
                if ("".equals(previousValues[0])) {
                    previousValues[0] = values[0];
                }
                allValues = new ArrayList();
                allValues.addAll(Arrays.asList(previousValues));
                allValues.removeAll(Arrays.asList(values));
                if (allValues.isEmpty()) {
                    parameterValuesMap.remove(key);
                    continue;
                }
                parameterValuesMap.put(key, allValues.toArray(StringArray));
                continue;
            }
            if (!submittedParameters.containsKey(Subtract + patchKey) && !submittedParameters.containsKey(Append + patchKey)) {
                parameterValuesMap.put(patchKey, values);
            }
            directParameters.add(patchKey);
        }
        this.orderMultiValueParameters(parameterValuesMap, externalContext, DOMResponseWriter.getOldDocument(facesContext));
        HashMap newPreviousParameters = new HashMap(parameterValuesMap);
        for (String parameterName : directParameters) {
            if (submittedParameters.containsKey(Append + parameterName)) continue;
            newPreviousParameters.remove(parameterName);
        }
        Object request = externalContext.getRequest();
        if (EnvUtils.instanceofPortletRequest(request)) {
            externalContext.setRequest((Object)new DeltaPortletRequest((PortletRequest)request, parameterValuesMap));
        } else {
            externalContext.setRequest((Object)new DeltaHttpServletRequest((HttpServletRequest)request, parameterValuesMap));
        }
    }

    private void orderMultiValueParameters(Map parameterValuesMap, ExternalContext externalContext, Document doc) {
        Map orderedParameters = this.calculateMultiValueParameterOrder(externalContext, doc);
        for (Map.Entry entry : parameterValuesMap.entrySet()) {
            String name = (String)entry.getKey();
            String[] unorderedValues = (String[])entry.getValue();
            String[] orderedValues = (String[])orderedParameters.get(name);
            if (unorderedValues.length <= 1 || orderedValues == null) continue;
            Arrays.sort(unorderedValues, new ParameterOrderComparator(Arrays.asList(orderedValues)));
        }
    }

    private Map calculateMultiValueParameterOrder(ExternalContext externalContext, Document doc) {
        HashMap<String, String[]> multiParameters = new HashMap<String, String[]>();
        Map parameters = externalContext.getRequestParameterMap();
        NodeList forms = doc.getElementsByTagName("form");
        for (int i = 0; i < forms.getLength(); ++i) {
            Object values;
            String name;
            Element form = (Element)forms.item(i);
            String formID = form.getAttribute("id");
            if (!parameters.containsKey(formID)) continue;
            NodeList inputs = form.getElementsByTagName("input");
            for (int j = 0; j < inputs.getLength(); ++j) {
                Element input = (Element)inputs.item(j);
                String type = input.getAttribute("type");
                if (!"checkbox".equalsIgnoreCase(type)) continue;
                name = input.getAttribute("name");
                String value = input.getAttribute("value");
                values = (String[])multiParameters.get(name);
                if (values == null) {
                    multiParameters.put(name, new String[]{value});
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(values));
                list.add(value);
                multiParameters.put(name, list.toArray(StringArray));
            }
            NodeList selects = form.getElementsByTagName("select");
            for (int j = 0; j < selects.getLength(); ++j) {
                Element select = (Element)selects.item(j);
                name = select.getAttribute("name");
                NodeList options = select.getElementsByTagName("option");
                values = new ArrayList();
                for (int k = 0; k < options.getLength(); ++k) {
                    Element option = (Element)options.item(k);
                    ((ArrayList)values).add(option.getAttribute("value"));
                }
                if (((ArrayList)values).isEmpty()) continue;
                multiParameters.put(name, ((ArrayList)values).toArray(StringArray));
            }
            break;
        }
        return multiParameters;
    }

    private Map calculateParametersFromDOM(ExternalContext externalContext, Document doc) {
        HashMap<String, String[]> multiParameters = new HashMap<String, String[]>();
        Map parameters = externalContext.getRequestParameterMap();
        NodeList forms = doc.getElementsByTagName("form");
        for (int i = 0; i < forms.getLength(); ++i) {
            String name;
            Element form = (Element)forms.item(i);
            String formID = form.getAttribute("id");
            if (!parameters.containsKey(formID)) continue;
            NodeList inputs = form.getElementsByTagName("input");
            for (int j = 0; j < inputs.getLength(); ++j) {
                ArrayList<String> list;
                String[] values;
                String value;
                Element input = (Element)inputs.item(j);
                String type = input.getAttribute("type");
                if ("image".equalsIgnoreCase(type) || "button".equalsIgnoreCase(type) || "submit".equalsIgnoreCase(type) || "reset".equalsIgnoreCase(type)) continue;
                name = input.getAttribute("name");
                if ("checkbox".equalsIgnoreCase(type) || "radio".equalsIgnoreCase(type)) {
                    if (!input.hasAttribute("checked")) continue;
                    value = input.getAttribute("value");
                    value = "".equals(value) ? "on" : value;
                    values = (String[])multiParameters.get(name);
                    if (values == null) {
                        multiParameters.put(name, new String[]{value});
                        continue;
                    }
                    list = new ArrayList<String>(Arrays.asList(values));
                    list.add(value);
                    multiParameters.put(name, list.toArray(StringArray));
                    continue;
                }
                value = input.getAttribute("value");
                values = (String[])multiParameters.get(name);
                if (values == null) {
                    multiParameters.put(name, new String[]{value});
                    continue;
                }
                list = new ArrayList<String>(Arrays.asList(values));
                list.add(value);
                multiParameters.put(name, list.toArray(StringArray));
            }
            NodeList textareas = form.getElementsByTagName("textarea");
            for (int j = 0; j < textareas.getLength(); ++j) {
                Element txtarea = (Element)textareas.item(j);
                name = txtarea.getAttribute("name");
                if (parameters.containsKey(name)) continue;
                Node child = txtarea.getFirstChild();
                String value = child == null ? "" : child.getNodeValue();
                multiParameters.put(name, new String[]{value});
            }
            NodeList selects = form.getElementsByTagName("select");
            for (int j = 0; j < selects.getLength(); ++j) {
                Element option;
                Element select = (Element)selects.item(j);
                String name2 = select.getAttribute("name");
                String multiple = select.getAttribute("multiple");
                NodeList options = select.getElementsByTagName("option");
                ArrayList<String> selectedOptions = new ArrayList<String>();
                for (int k = 0; k < options.getLength(); ++k) {
                    option = (Element)options.item(k);
                    String selectedAttribute = option.getAttribute("selected");
                    if (!"selected".equalsIgnoreCase(selectedAttribute) && !"true".equalsIgnoreCase(selectedAttribute)) continue;
                    selectedOptions.add(option.getAttribute("value"));
                }
                if (selectedOptions.isEmpty()) {
                    boolean isMultipleSelection = "multiple".equals(multiple);
                    if (options.getLength() <= 0 || isMultipleSelection) continue;
                    option = (Element)options.item(0);
                    multiParameters.put(name2, new String[]{option.getAttribute("value")});
                    continue;
                }
                multiParameters.put(name2, selectedOptions.toArray(StringArray));
            }
            break;
        }
        return multiParameters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterOrderComparator
    implements Comparator<String> {
        private final List orderedValueList;

        public ParameterOrderComparator(List orderedValueList) {
            this.orderedValueList = orderedValueList;
        }

        @Override
        public int compare(String a, String b) {
            return this.orderedValueList.indexOf(a) - this.orderedValueList.indexOf(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeltaPortletRequest
    extends PortletRequestWrapper {
        private final Map parameterValuesMap;

        public DeltaPortletRequest(PortletRequest originalRequest, Map parameterValuesMap) {
            super(originalRequest);
            this.parameterValuesMap = parameterValuesMap;
        }

        public String getParameter(String s) {
            String[] values = (String[])this.parameterValuesMap.get(s);
            return values == null ? null : values[0];
        }

        public String[] getParameterValues(String s) {
            return (String[])this.parameterValuesMap.get(s);
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.parameterValuesMap.keySet());
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(this.parameterValuesMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeltaHttpServletRequest
    extends HttpServletRequestWrapper {
        private final Map parameterValuesMap;

        public DeltaHttpServletRequest(HttpServletRequest originalRequest, Map parameterValuesMap) {
            super(originalRequest);
            this.parameterValuesMap = parameterValuesMap;
        }

        public String getParameter(String s) {
            String[] values = (String[])this.parameterValuesMap.get(s);
            return values == null ? null : values[0];
        }

        public String[] getParameterValues(String s) {
            return (String[])this.parameterValuesMap.get(s);
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.parameterValuesMap.keySet());
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(this.parameterValuesMap);
        }
    }
}

